/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import java.io.File;
import java.net.SocketAddress;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

public class StringUtils {
    public static String getModVersionString(String modId) {
        for (ModInfo modInfo : FMLLoader.getLoadingModList().getMods()) {
            if (!modInfo.getModId().equals(modId)) continue;
            return modInfo.getVersion().getQualifier();
        }
        return "?";
    }

    public static int getColor(String colorStr, int defaultColor) {
        Pattern pattern = Pattern.compile("(?:0x|#)([a-fA-F0-9]{1,8})");
        Matcher matcher = pattern.matcher(colorStr);
        if (matcher.matches()) {
            try {
                return (int)Long.parseLong(matcher.group(1), 16);
            }
            catch (NumberFormatException e) {
                return defaultColor;
            }
        }
        try {
            return Integer.parseInt(colorStr, 10);
        }
        catch (NumberFormatException e) {
            return defaultColor;
        }
    }

    public static String splitCamelCase(String str) {
        if (((String)(str = ((String)str).replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " "))).length() > 1 && ((String)str).charAt(0) > 'Z') {
            str = ((String)str).substring(0, 1).toUpperCase(Locale.ROOT) + ((String)str).substring(1);
        }
        return str;
    }

    public static void sendOpenFileChatMessage(Entity sender, String messageKey, File file) {
        MutableComponent name = Component.m_237113_((String)file.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
        sender.m_213846_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{name}));
    }

    public static void splitTextToLines(List<String> linesOut, String textIn, int maxLineLength) {
        String[] lines;
        for (String line : lines = textIn.split("\\\\n")) {
            String[] parts = line.split(" ");
            StringBuilder sb = new StringBuilder(256);
            int spaceWidth = StringUtils.getStringWidth(" ");
            int lineWidth = 0;
            for (String str : parts) {
                int width = StringUtils.getStringWidth(str);
                if (lineWidth + width + spaceWidth > maxLineLength) {
                    if (lineWidth > 0) {
                        linesOut.add(sb.toString());
                        sb = new StringBuilder(256);
                        lineWidth = 0;
                    }
                    if (width > maxLineLength) {
                        int chars = str.length();
                        for (int i = 0; i < chars; ++i) {
                            String c = str.substring(i, i + 1);
                            if ((lineWidth += StringUtils.getStringWidth(c)) > maxLineLength) {
                                linesOut.add(sb.toString());
                                sb = new StringBuilder(256);
                                lineWidth = 0;
                            }
                            sb.append(c);
                        }
                        linesOut.add(sb.toString());
                        sb = new StringBuilder(256);
                        lineWidth = 0;
                    }
                }
                if (lineWidth > 0) {
                    sb.append(" ");
                }
                if (width > maxLineLength) continue;
                sb.append(str);
                lineWidth += width + spaceWidth;
            }
            linesOut.add(sb.toString());
        }
    }

    public static String getClampedDisplayStringStrlen(List<String> list, int maxWidth, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(prefix);
        int width = prefix.length() + suffix.length();
        int size = list.size();
        if (size > 0) {
            for (int i = 0; i < size && width < maxWidth; ++i) {
                String str;
                int len;
                int end;
                if (i > 0) {
                    sb.append(", ");
                    width += 2;
                }
                if ((end = Math.min(len = (str = list.get(i)).length(), maxWidth - width)) < len) {
                    end = Math.max(0, Math.min(len, maxWidth - width - 3));
                    if (end >= 1) {
                        sb.append(str.substring(0, end));
                    }
                    sb.append("...");
                    width += end + 3;
                    continue;
                }
                sb.append(str);
                width += len;
            }
        } else {
            sb.append("<empty>");
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static String getClampedDisplayStringRenderlen(List<String> list, int maxWidth, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(prefix);
        String entrySep = ", ";
        String dots = " ...";
        int listSize = list.size();
        int widthSep = StringUtils.getStringWidth(entrySep);
        int widthDots = StringUtils.getStringWidth(dots);
        int width = StringUtils.getStringWidth(prefix) + StringUtils.getStringWidth(suffix);
        if (listSize > 0) {
            int len;
            for (int listIndex = 0; listIndex < listSize && width < maxWidth; width += len, ++listIndex) {
                String c;
                int charWidth;
                String str;
                if (listIndex > 0) {
                    sb.append(entrySep);
                    width += widthSep;
                }
                if (width + (len = StringUtils.getStringWidth(str = list.get(listIndex))) <= maxWidth) {
                    sb.append(str);
                    continue;
                }
                for (int i = 0; i < str.length() && width + (charWidth = StringUtils.getStringWidth(c = str.substring(i, i + 1))) + widthDots <= maxWidth; ++i) {
                    sb.append(c);
                    width += charWidth;
                }
                sb.append(dots);
                width += widthDots;
                break;
            }
        } else {
            sb.append("<empty>");
        }
        sb.append(suffix);
        return sb.toString();
    }

    @Nullable
    public static String getWorldOrServerName() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91091_()) {
            IntegratedServer server = mc.m_91092_();
            if (server != null) {
                String name = server.m_129910_().m_5462_();
                return FileUtils.generateSimpleSafeFileName(name);
            }
        } else {
            ServerData server;
            if (mc.m_91294_()) {
                Connection connection;
                if (MaLiLibConfigs.Generic.REALMS_COMMON_CONFIG.getBooleanValue()) {
                    return "realms";
                }
                ClientPacketListener handler = mc.m_91403_();
                Connection connection2 = connection = handler != null ? handler.m_6198_() : null;
                if (connection != null) {
                    return "realms_" + StringUtils.stringifyAddress(connection.m_129523_());
                }
            }
            if ((server = mc.m_91089_()) != null) {
                return server.f_105363_.replace(':', '_');
            }
        }
        return null;
    }

    public static String getStorageFileName(boolean globalData, String prefix, String suffix, String defaultName) {
        String name = StringUtils.getWorldOrServerName();
        if (name != null) {
            if (globalData) {
                return prefix + name + suffix;
            }
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null) {
                return prefix + name + "_dim_" + WorldUtils.getDimensionId((Level)world) + suffix;
            }
        }
        return prefix + defaultName + suffix;
    }

    public static String stringifyAddress(SocketAddress address) {
        String str = address.toString();
        if (str.contains("/")) {
            str = str.substring(str.indexOf(47) + 1);
        }
        return str.replace(':', '_');
    }

    @Nullable
    public static String getTranslatedOrFallback(String key, @Nullable String fallback) {
        String translated = StringUtils.translate(key, new Object[0]);
        if (!key.equals(translated)) {
            return translated;
        }
        return fallback;
    }

    public static String translate(String translationKey, Object ... args) {
        return I18n.m_118938_((String)translationKey, (Object[])args);
    }

    public static int getFontHeight() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9;
    }

    public static int getStringWidth(String text) {
        return Minecraft.m_91087_().f_91062_.m_92895_(text);
    }

    public static void drawString(int x, int y, int color, String text, PoseStack matrixStack) {
        Minecraft.m_91087_().f_91062_.m_92883_(matrixStack, text, (float)x, (float)y, color);
    }
}

