/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class BlockInfo {
    private final String title;
    private final BlockState state;
    private final ItemStack stack;
    private final String blockRegistryname;
    private final String stackName;
    private final List<String> props;
    private final int totalWidth;
    private final int totalHeight;
    private final int columnWidth;

    public BlockInfo(BlockState state, String titleKey) {
        String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
        this.title = pre + StringUtils.translate((String)titleKey, (Object[])new Object[0]) + GuiBase.TXT_RST;
        this.state = state;
        this.stack = ItemUtils.getItemForState(this.state);
        ResourceLocation rl = Registry.f_122824_.m_7981_((Object)this.state.m_60734_());
        this.blockRegistryname = rl != null ? rl.toString() : "<null>";
        this.stackName = this.stack.m_41786_().getString();
        int w = StringUtils.getStringWidth((String)this.stackName) + 20;
        w = Math.max(w, StringUtils.getStringWidth((String)this.blockRegistryname));
        this.columnWidth = w = Math.max(w, StringUtils.getStringWidth((String)this.title));
        this.props = BlockUtils.getFormattedBlockStateProperties((BlockState)this.state, (String)" = ");
        this.totalWidth = this.columnWidth + 40;
        this.totalHeight = this.props.size() * (StringUtils.getFontHeight() + 2) + 60;
    }

    public int getTotalWidth() {
        return this.totalWidth;
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public void render(int x, int y, Minecraft mc, PoseStack matrixStack) {
        if (this.state != null) {
            RenderUtils.drawOutlinedBox((int)x, (int)y, (int)this.totalWidth, (int)this.totalHeight, (int)-16777216, (int)-6710887);
            Font textRenderer = mc.f_91062_;
            int x1 = x + 10;
            textRenderer.m_92883_(matrixStack, this.title, (float)x1, (float)(y += 4), -1);
            RenderUtils.enableDiffuseLightingGui3D();
            RenderUtils.drawRect((int)x1, (int)(y += 12), (int)16, (int)16, (int)0x20FFFFFF);
            mc.m_91291_().m_115218_(this.stack, x1, y);
            mc.m_91291_().m_115174_(textRenderer, this.stack, x1, y, null);
            RenderUtils.disableDiffuseLighting();
            textRenderer.m_92883_(matrixStack, this.stackName, (float)(x1 + 20), (float)(y + 4), -1);
            textRenderer.m_92883_(matrixStack, this.blockRegistryname, (float)x1, (float)(y += 20), -12558081);
            Objects.requireNonNull(textRenderer);
            RenderUtils.renderText((int)x1, (int)(y += 9 + 4), (int)-5197648, this.props, (PoseStack)matrixStack);
        }
    }
}

