/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.schematic.BlockModelRendererSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import fi.dy.masa.litematica.render.schematic.IChunkRendererFactory;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.LayerRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class WorldRendererSchematic {
    private final Minecraft mc;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final BlockRenderDispatcher blockRenderManager;
    private final BlockModelRendererSchematic blockModelRenderer;
    private final Set<BlockEntity> blockEntities = new HashSet<BlockEntity>();
    private final List<ChunkRendererSchematicVbo> renderInfos = new ArrayList<ChunkRendererSchematicVbo>(1024);
    private final RenderBuffers bufferBuilders;
    private Set<ChunkRendererSchematicVbo> chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
    private WorldSchematic world;
    private ChunkRenderDispatcherSchematic chunkRendererDispatcher;
    private double lastCameraChunkUpdateX = Double.MIN_VALUE;
    private double lastCameraChunkUpdateY = Double.MIN_VALUE;
    private double lastCameraChunkUpdateZ = Double.MIN_VALUE;
    private double lastCameraX = Double.MIN_VALUE;
    private double lastCameraY = Double.MIN_VALUE;
    private double lastCameraZ = Double.MIN_VALUE;
    private float lastCameraPitch = Float.MIN_VALUE;
    private float lastCameraYaw = Float.MIN_VALUE;
    private ChunkRenderDispatcherLitematica renderDispatcher;
    private final IChunkRendererFactory renderChunkFactory;
    private int renderDistanceChunks = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private double lastTranslucentSortX;
    private double lastTranslucentSortY;
    private double lastTranslucentSortZ;
    private boolean displayListEntitiesDirty = true;

    public WorldRendererSchematic(Minecraft mc) {
        this.mc = mc;
        this.entityRenderDispatcher = mc.m_91290_();
        this.bufferBuilders = mc.m_91269_();
        this.renderChunkFactory = ChunkRendererSchematicVbo::new;
        this.blockRenderManager = Minecraft.m_91087_().m_91289_();
        this.blockModelRenderer = new BlockModelRendererSchematic(mc.m_91298_());
    }

    public void markNeedsUpdate() {
        this.displayListEntitiesDirty = true;
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    public String getDebugInfoRenders() {
        int rcTotal = this.chunkRendererDispatcher != null ? this.chunkRendererDispatcher.getRendererCount() : 0;
        int rcRendered = this.chunkRendererDispatcher != null ? this.getRenderedChunks() : 0;
        return String.format("C: %d/%d %sD: %d, L: %d, %s", rcRendered, rcTotal, this.mc.f_90980_ ? "(s) " : "", this.renderDistanceChunks, 0, this.renderDispatcher == null ? "null" : this.renderDispatcher.getDebugInfo());
    }

    public String getDebugInfoEntities() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ", B: " + this.countEntitiesHidden;
    }

    protected int getRenderedChunks() {
        int count = 0;
        for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
            ChunkRenderDataSchematic data = chunkRenderer.chunkRenderData;
            if (data == ChunkRenderDataSchematic.EMPTY || data.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public void setWorldAndLoadRenderers(@Nullable WorldSchematic worldSchematic) {
        this.lastCameraChunkUpdateX = Double.MIN_VALUE;
        this.lastCameraChunkUpdateY = Double.MIN_VALUE;
        this.lastCameraChunkUpdateZ = Double.MIN_VALUE;
        this.world = worldSchematic;
        if (worldSchematic != null) {
            this.loadRenderers();
        } else {
            this.chunksToUpdate.clear();
            this.renderInfos.clear();
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
                this.chunkRendererDispatcher = null;
            }
            if (this.renderDispatcher != null) {
                this.renderDispatcher.stopWorkerThreads();
            }
            this.renderDispatcher = null;
            this.blockEntities.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRenderers() {
        if (this.hasWorld()) {
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcherLitematica();
            }
            this.displayListEntitiesDirty = true;
            this.renderDistanceChunks = (Integer)this.mc.f_91066_.m_231984_().m_231551_();
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
            }
            this.stopChunkUpdates();
            Set<BlockEntity> set = this.blockEntities;
            synchronized (set) {
                this.blockEntities.clear();
            }
            this.chunkRendererDispatcher = new ChunkRenderDispatcherSchematic(this.world, this.renderDistanceChunks, this, this.renderChunkFactory);
            this.renderEntitiesStartupCounter = 2;
        }
    }

    protected void stopChunkUpdates() {
        this.chunksToUpdate.clear();
        this.renderDispatcher.stopChunkUpdates();
    }

    public void setupTerrain(Camera camera, Frustum frustum, int frameCount, boolean playerSpectator) {
        Entity entity;
        this.world.m_46473_().m_6180_("setup_terrain");
        if (this.chunkRendererDispatcher == null || (Integer)this.mc.f_91066_.m_231984_().m_231551_() != this.renderDistanceChunks) {
            this.loadRenderers();
        }
        if ((entity = EntityUtils.getCameraEntity()) == null) {
            entity = this.mc.f_91074_;
        }
        this.world.m_46473_().m_6180_("camera");
        double entityX = entity.m_20185_();
        double entityY = entity.m_20186_();
        double entityZ = entity.m_20189_();
        double diffX = entityX - this.lastCameraChunkUpdateX;
        double diffY = entityY - this.lastCameraChunkUpdateY;
        double diffZ = entityZ - this.lastCameraChunkUpdateZ;
        if (diffX * diffX + diffY * diffY + diffZ * diffZ > 256.0) {
            this.lastCameraChunkUpdateX = entityX;
            this.lastCameraChunkUpdateY = entityY;
            this.lastCameraChunkUpdateZ = entityZ;
            this.chunkRendererDispatcher.removeOutOfRangeRenderers();
        }
        this.world.m_46473_().m_6182_("renderlist_camera");
        Vec3 cameraPos = camera.m_90583_();
        double cameraX = cameraPos.f_82479_;
        double cameraY = cameraPos.f_82480_;
        double cameraZ = cameraPos.f_82481_;
        this.renderDispatcher.setCameraPosition(cameraPos);
        this.world.m_46473_().m_6182_("culling");
        BlockPos viewPos = new BlockPos(cameraX, cameraY + (double)entity.m_20192_(), cameraZ);
        int centerChunkX = viewPos.m_123341_() >> 4;
        int centerChunkZ = viewPos.m_123343_() >> 4;
        int renderDistance = (Integer)this.mc.f_91066_.m_231984_().m_231551_();
        ChunkPos viewChunk = new ChunkPos(viewPos);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || entityX != this.lastCameraX || entityY != this.lastCameraY || entityZ != this.lastCameraZ || entity.m_146909_() != this.lastCameraPitch || entity.m_146908_() != this.lastCameraYaw;
        this.lastCameraX = cameraX;
        this.lastCameraY = cameraY;
        this.lastCameraZ = cameraZ;
        this.lastCameraPitch = camera.m_90589_();
        this.lastCameraYaw = camera.m_90590_();
        this.world.m_46473_().m_6182_("update");
        if (this.displayListEntitiesDirty) {
            this.world.m_46473_().m_6180_("fetch");
            this.displayListEntitiesDirty = false;
            this.renderInfos.clear();
            this.world.m_46473_().m_6182_("sort");
            List<ChunkPos> positions = DataManager.getSchematicPlacementManager().getAndUpdateVisibleChunks(viewChunk);
            this.world.m_46473_().m_6182_("iteration");
            for (ChunkPos chunkPos : positions) {
                ChunkRendererSchematicVbo chunkRenderer;
                int cx = chunkPos.f_45578_;
                int cz = chunkPos.f_45579_;
                if (Math.abs(cx - centerChunkX) > renderDistance || Math.abs(cz - centerChunkZ) > renderDistance || !this.world.getChunkProvider().m_5563_(cx, cz) || (chunkRenderer = this.chunkRendererDispatcher.getChunkRenderer(cx, cz)) == null || !frustum.m_113029_(chunkRenderer.getBoundingBox())) continue;
                if (chunkRenderer.needsUpdate() && chunkPos.equals((Object)viewChunk)) {
                    chunkRenderer.setNeedsUpdate(true);
                }
                this.renderInfos.add(chunkRenderer);
            }
            this.world.m_46473_().m_7238_();
        }
        this.world.m_46473_().m_6182_("rebuild_near");
        Set<ChunkRendererSchematicVbo> set = this.chunksToUpdate;
        this.chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
        for (ChunkRendererSchematicVbo chunkRendererTmp : this.renderInfos) {
            boolean isNear;
            if (!chunkRendererTmp.needsUpdate() && !set.contains(chunkRendererTmp)) continue;
            this.displayListEntitiesDirty = true;
            BlockPos pos = chunkRendererTmp.getOrigin().m_7918_(8, 8, 8);
            boolean bl = isNear = pos.m_123331_((Vec3i)viewPos) < 1024.0;
            if (!chunkRendererTmp.needsImmediateUpdate() && !isNear) {
                this.chunksToUpdate.add(chunkRendererTmp);
                continue;
            }
            this.world.m_46473_().m_6180_("build_near");
            this.renderDispatcher.updateChunkNow(chunkRendererTmp);
            chunkRendererTmp.clearNeedsUpdate();
            this.world.m_46473_().m_7238_();
        }
        this.chunksToUpdate.addAll(set);
        this.world.m_46473_().m_7238_();
        this.world.m_46473_().m_7238_();
    }

    public void updateChunks(long finishTimeNano) {
        this.mc.m_91307_().m_6180_("litematica_run_chunk_uploads");
        this.displayListEntitiesDirty |= this.renderDispatcher.runChunkUploads(finishTimeNano);
        this.mc.m_91307_().m_6182_("litematica_check_update");
        if (!this.chunksToUpdate.isEmpty()) {
            Iterator<ChunkRendererSchematicVbo> iterator = this.chunksToUpdate.iterator();
            while (iterator.hasNext()) {
                boolean flag;
                ChunkRendererSchematicVbo renderChunk = iterator.next();
                if (renderChunk.needsImmediateUpdate()) {
                    this.mc.m_91307_().m_6180_("litematica_update_now");
                    flag = this.renderDispatcher.updateChunkNow(renderChunk);
                } else {
                    this.mc.m_91307_().m_6180_("litematica_update_later");
                    flag = this.renderDispatcher.updateChunkLater(renderChunk);
                }
                this.mc.m_91307_().m_7238_();
                if (!flag) break;
                renderChunk.clearNeedsUpdate();
                iterator.remove();
                long i = finishTimeNano - System.nanoTime();
                if (i >= 0L) continue;
                break;
            }
        }
        this.mc.m_91307_().m_7238_();
    }

    public int renderBlockLayer(RenderType renderLayer, PoseStack matrices, Camera camera, Matrix4f projMatrix) {
        this.world.m_46473_().m_6180_("render_block_layer_" + renderLayer.toString());
        boolean isTranslucent = renderLayer == RenderType.m_110466_();
        renderLayer.m_110185_();
        Vec3 cameraPos = camera.m_90583_();
        double x = cameraPos.f_82479_;
        double y = cameraPos.f_82480_;
        double z = cameraPos.f_82481_;
        if (isTranslucent) {
            this.world.m_46473_().m_6180_("translucent_sort");
            double diffX = x - this.lastTranslucentSortX;
            double diffY = y - this.lastTranslucentSortY;
            double diffZ = z - this.lastTranslucentSortZ;
            if (diffX * diffX + diffY * diffY + diffZ * diffZ > 1.0) {
                this.lastTranslucentSortX = x;
                this.lastTranslucentSortY = y;
                this.lastTranslucentSortZ = z;
                int i = 0;
                for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                    if (!chunkRenderer.getChunkRenderData().isBlockLayerStarted(renderLayer) && (chunkRenderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !chunkRenderer.hasOverlay()) || i++ >= 15) continue;
                    this.renderDispatcher.updateTransparencyLater(chunkRenderer);
                }
            }
            this.world.m_46473_().m_7238_();
        }
        this.world.m_46473_().m_6180_("filter_empty");
        this.world.m_46473_().m_6182_("render");
        boolean reverse = isTranslucent;
        int startIndex = reverse ? this.renderInfos.size() - 1 : 0;
        int stopIndex = reverse ? -1 : this.renderInfos.size();
        int increment = reverse ? -1 : 1;
        int count = 0;
        ShaderInstance shader = RenderSystem.m_157196_();
        BufferUploader.m_166835_();
        boolean renderAsTranslucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
        if (renderAsTranslucent) {
            float alpha = (float)Configs.Visuals.GHOST_BLOCK_ALPHA.getDoubleValue();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        WorldRendererSchematic.initShader(shader, matrices, projMatrix);
        RenderSystem.m_157461_((ShaderInstance)shader);
        shader.m_173363_();
        Uniform chunkOffsetUniform = shader.f_173320_;
        boolean startedDrawing = false;
        for (int i = startIndex; i != stopIndex; i += increment) {
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData().isBlockLayerEmpty(renderLayer)) continue;
            BlockPos chunkOrigin = renderer.getOrigin();
            VertexBuffer buffer = renderer.getBlocksVertexBufferByLayer(renderLayer);
            if (chunkOffsetUniform != null) {
                chunkOffsetUniform.m_5889_((float)((double)chunkOrigin.m_123341_() - x), (float)((double)chunkOrigin.m_123342_() - y), (float)((double)chunkOrigin.m_123343_() - z));
                chunkOffsetUniform.m_85633_();
            }
            buffer.m_85921_();
            buffer.m_166882_();
            VertexBuffer.m_85931_();
            startedDrawing = true;
            ++count;
        }
        if (renderAsTranslucent) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (chunkOffsetUniform != null) {
            chunkOffsetUniform.m_142276_(Vector3f.f_176763_);
        }
        shader.m_173362_();
        if (startedDrawing) {
            renderLayer.m_110508_().m_86024_();
        }
        VertexBuffer.m_85931_();
        renderLayer.m_110188_();
        this.world.m_46473_().m_7238_();
        this.world.m_46473_().m_7238_();
        return count;
    }

    public void renderBlockOverlays(PoseStack matrices, Camera camera, Matrix4f projMatrix) {
        this.renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType.OUTLINE, matrices, camera, projMatrix);
        this.renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType.QUAD, matrices, camera, projMatrix);
    }

    protected static void initShader(ShaderInstance shader, PoseStack matrices, Matrix4f projMatrix) {
        for (int i = 0; i < 12; ++i) {
            shader.m_173350_("Sampler" + i, (Object)RenderSystem.m_157203_((int)i));
        }
        if (shader.f_173308_ != null) {
            shader.f_173308_.m_5679_(matrices.m_85850_().m_85861_());
        }
        if (shader.f_173309_ != null) {
            shader.f_173309_.m_5679_(projMatrix);
        }
        if (shader.f_173312_ != null) {
            shader.f_173312_.m_5941_(RenderSystem.m_157197_());
        }
        if (shader.f_173315_ != null) {
            shader.f_173315_.m_5985_(RenderSystem.m_157200_());
        }
        if (shader.f_173316_ != null) {
            shader.f_173316_.m_5985_(RenderSystem.m_157199_());
        }
        if (shader.f_173317_ != null) {
            shader.f_173317_.m_5941_(RenderSystem.m_157198_());
        }
        if (shader.f_173310_ != null) {
            shader.f_173310_.m_5679_(RenderSystem.m_157207_());
        }
        if (shader.f_173319_ != null) {
            shader.f_173319_.m_5985_(RenderSystem.m_157201_());
        }
    }

    protected void renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType type, PoseStack matrixStack, Camera camera, Matrix4f projMatrix) {
        boolean renderThrough;
        RenderType renderLayer = RenderType.m_110466_();
        renderLayer.m_110185_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        Vec3 cameraPos = camera.m_90583_();
        double x = cameraPos.f_82479_;
        double y = cameraPos.f_82480_;
        double z = cameraPos.f_82481_;
        this.world.m_46473_().m_6180_("overlay_" + type.name());
        this.world.m_46473_().m_6182_("render");
        boolean bl = renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
        if (renderThrough) {
            RenderSystem.m_69465_();
        } else {
            RenderSystem.m_69482_();
        }
        ShaderInstance originalShader = RenderSystem.m_157196_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        ShaderInstance shader = RenderSystem.m_157196_();
        BufferUploader.m_166835_();
        for (int i = this.renderInfos.size() - 1; i >= 0; --i) {
            ChunkRenderDataSchematic compiledChunk;
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !renderer.hasOverlay() || (compiledChunk = renderer.getChunkRenderData()).isOverlayTypeEmpty(type)) continue;
            VertexBuffer buffer = renderer.getOverlayVertexBuffer(type);
            BlockPos chunkOrigin = renderer.getOrigin();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)chunkOrigin.m_123341_() - x, (double)chunkOrigin.m_123342_() - y, (double)chunkOrigin.m_123343_() - z);
            buffer.m_85921_();
            buffer.m_166867_(matrixStack.m_85850_().m_85861_(), projMatrix, shader);
            VertexBuffer.m_85931_();
            matrixStack.m_85849_();
        }
        renderLayer.m_110188_();
        RenderSystem.m_157427_(() -> originalShader);
        RenderSystem.m_69461_();
        this.world.m_46473_().m_7238_();
    }

    public boolean renderBlock(BlockAndTintGetter world, BlockState state, BlockPos pos, PoseStack matrices, BufferBuilder bufferBuilderIn) {
        try {
            RenderShape renderType = state.m_60799_();
            if (renderType == RenderShape.INVISIBLE) {
                return false;
            }
            return renderType == RenderShape.MODEL && this.blockModelRenderer.renderModel(world, this.getModelForState(state), state, pos, matrices, (VertexConsumer)bufferBuilderIn, state.m_60726_(pos));
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being tesselated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)world, (BlockPos)pos, (BlockState)state);
            throw new ReportedException(crashreport);
        }
    }

    public void renderFluid(BlockAndTintGetter world, FluidState state, BlockPos pos, BufferBuilder bufferBuilderIn) {
        this.blockRenderManager.m_234363_(pos, world, (VertexConsumer)bufferBuilderIn, state.m_76188_(), state);
    }

    public BakedModel getModelForState(BlockState state) {
        if (state.m_60799_() == RenderShape.ENTITYBLOCK_ANIMATED) {
            return this.blockRenderManager.m_110907_().m_110881_().m_119409_();
        }
        return this.blockRenderManager.m_110910_(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderEntities(Camera camera, Frustum frustum, PoseStack matrices, float partialTicks) {
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
        } else {
            this.world.m_46473_().m_6180_("prepare");
            double cameraX = camera.m_90583_().f_82479_;
            double cameraY = camera.m_90583_().f_82480_;
            double cameraZ = camera.m_90583_().f_82481_;
            Minecraft.m_91087_().m_167982_().m_173564_((Level)this.world, camera, this.mc.f_91077_);
            this.entityRenderDispatcher.m_114408_((Level)this.world, camera, this.mc.f_91076_);
            this.countEntitiesTotal = 0;
            this.countEntitiesRendered = 0;
            this.countEntitiesHidden = 0;
            this.countEntitiesTotal = this.world.getRegularEntityCount();
            this.world.m_46473_().m_6182_("regular_entities");
            MultiBufferSource.BufferSource entityVertexConsumers = this.bufferBuilders.m_110104_();
            LayerRange layerRange = DataManager.getRenderLayerRange();
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                BlockPos pos = chunkRenderer.getOrigin();
                ChunkSchematic chunk = this.world.getChunk(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
                List<Entity> list = chunk.getEntityList();
                if (list.isEmpty()) continue;
                for (Entity entityTmp : list) {
                    boolean shouldRender;
                    if (!layerRange.isPositionWithinRange((int)entityTmp.m_20185_(), (int)entityTmp.m_20186_(), (int)entityTmp.m_20189_()) || !(shouldRender = this.entityRenderDispatcher.m_114397_(entityTmp, frustum, cameraX, cameraY, cameraZ))) continue;
                    double x = entityTmp.m_20185_() - cameraX;
                    double y = entityTmp.m_20186_() - cameraY;
                    double z = entityTmp.m_20189_() - cameraZ;
                    this.entityRenderDispatcher.m_114384_(entityTmp, x, y, z, entityTmp.m_146908_(), 1.0f, matrices, (MultiBufferSource)entityVertexConsumers, this.entityRenderDispatcher.m_114394_(entityTmp, partialTicks));
                    ++this.countEntitiesRendered;
                }
            }
            this.world.m_46473_().m_6182_("block_entities");
            BlockEntityRenderDispatcher renderer = Minecraft.m_91087_().m_167982_();
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                ChunkRenderDataSchematic data = chunkRenderer.getChunkRenderData();
                List<BlockEntity> tiles = data.getBlockEntities();
                if (tiles.isEmpty()) continue;
                BlockPos chunkOrigin = chunkRenderer.getOrigin();
                ChunkSchematic chunk = this.world.getChunkProvider().getChunk(chunkOrigin.m_123341_() >> 4, chunkOrigin.m_123343_() >> 4);
                if (chunk == null || data.getTimeBuilt() < chunk.getTimeCreated()) continue;
                for (BlockEntity te : tiles) {
                    try {
                        BlockPos pos = te.m_58899_();
                        matrices.m_85836_();
                        matrices.m_85837_((double)pos.m_123341_() - cameraX, (double)pos.m_123342_() - cameraY, (double)pos.m_123343_() - cameraZ);
                        renderer.m_112267_(te, partialTicks, matrices, (MultiBufferSource)entityVertexConsumers);
                        matrices.m_85849_();
                    }
                    catch (Exception exception) {}
                }
            }
            Set<BlockEntity> set = this.blockEntities;
            synchronized (set) {
                for (BlockEntity te : this.blockEntities) {
                    try {
                        BlockPos pos = te.m_58899_();
                        matrices.m_85836_();
                        matrices.m_85837_((double)pos.m_123341_() - cameraX, (double)pos.m_123342_() - cameraY, (double)pos.m_123343_() - cameraZ);
                        renderer.m_112267_(te, partialTicks, matrices, (MultiBufferSource)entityVertexConsumers);
                        matrices.m_85849_();
                    }
                    catch (Exception exception) {}
                }
            }
            this.world.m_46473_().m_7238_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlockEntities(Collection<BlockEntity> toRemove, Collection<BlockEntity> toAdd) {
        Set<BlockEntity> set = this.blockEntities;
        synchronized (set) {
            this.blockEntities.removeAll(toRemove);
            this.blockEntities.addAll(toAdd);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkZ) {
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            this.chunkRendererDispatcher.scheduleChunkRender(chunkX, chunkZ);
        }
    }
}

