/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.Queues;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkBase;
import fi.dy.masa.litematica.scheduler.tasks.TaskProcessChunkMultiPhase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PasteNbtBehavior;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Queue;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TaskPasteSchematicPerChunkCommand
extends TaskPasteSchematicPerChunkBase {
    protected final Queue<String> queuedCommands = Queues.newArrayDeque();
    protected final Long2LongOpenHashMap placedPositionTimestamps = new Long2LongOpenHashMap();
    protected final LongArrayList fillVolumes = new LongArrayList();
    protected final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    protected final PasteNbtBehavior nbtBehavior;
    protected final String cloneCommand;
    protected final String fillCommand;
    protected final String setBlockCommand;
    protected final String summonCommand;
    protected final int maxBoxVolume;
    protected final boolean useFillCommand;
    protected final boolean useWorldEdit;
    protected int[][][] workArr;
    protected int sentFillCommands;
    protected int sentSetblockCommands;

    public TaskPasteSchematicPerChunkCommand(Collection<SchematicPlacement> placements, LayerRange range, boolean changedBlocksOnly) {
        super(placements, range, changedBlocksOnly);
        this.maxCommandsPerTick = Configs.Generic.COMMAND_LIMIT.getIntegerValue();
        this.maxBoxVolume = Configs.Generic.COMMAND_FILL_MAX_VOLUME.getIntegerValue();
        this.cloneCommand = Configs.Generic.COMMAND_NAME_CLONE.getStringValue();
        this.fillCommand = Configs.Generic.COMMAND_NAME_FILL.getStringValue();
        this.setBlockCommand = Configs.Generic.COMMAND_NAME_SETBLOCK.getStringValue();
        this.summonCommand = Configs.Generic.COMMAND_NAME_SUMMON.getStringValue();
        this.useFillCommand = Configs.Generic.PASTE_USE_FILL_COMMAND.getBooleanValue();
        this.useWorldEdit = Configs.Generic.COMMAND_USE_WORLDEDIT.getBooleanValue();
        this.nbtBehavior = (PasteNbtBehavior)Configs.Generic.PASTE_NBT_BEHAVIOR.getOptionListValue();
        this.processBoxBlocksTask = this.useFillCommand ? this::processBlocksInCurrentBoxUsingFill : this::processBlocksInCurrentBoxUsingSetBlockOnly;
        this.processBoxEntitiesTask = this::processEntitiesInCurrentBox;
    }

    @Override
    public boolean execute() {
        if (this.ignoreBlocks && this.ignoreEntities) {
            return true;
        }
        return this.executeMultiPhase();
    }

    @Override
    public void init() {
        super.init();
        if (this.useWorldEdit && this.isInWorld()) {
            this.sendCommand("/perf neighbors off");
        }
    }

    @Override
    protected void onNextChunkFetched(ChunkPos pos) {
        this.startNextBox(pos);
    }

    @Override
    protected void onStartNextBox(IntBoundingBox box) {
        if (!this.ignoreBlocks) {
            this.prepareSettingBlocks(box);
        } else {
            this.prepareSummoningEntities(box);
        }
    }

    protected void prepareSettingBlocks(IntBoundingBox box) {
        if (this.useFillCommand) {
            this.generateFillVolumes(box);
        } else {
            this.positionIterator = BlockPos.m_121976_((int)box.minX, (int)box.minY, (int)box.minZ, (int)box.maxX, (int)box.maxY, (int)box.maxZ).iterator();
        }
        this.phase = TaskProcessChunkMultiPhase.TaskPhase.PROCESS_BOX_BLOCKS;
    }

    protected void prepareSummoningEntities(IntBoundingBox box) {
        AABB bb = new AABB((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
        this.entityIterator = this.schematicWorld.m_6249_(null, bb, e -> true).iterator();
        this.phase = TaskProcessChunkMultiPhase.TaskPhase.PROCESS_BOX_ENTITIES;
    }

    protected void sendQueuedCommands() {
        while (this.sentCommandsThisTick < this.maxCommandsPerTick && !this.queuedCommands.isEmpty()) {
            this.sendCommand(this.queuedCommands.poll());
        }
    }

    protected void processBlocksInCurrentBoxUsingSetBlockOnly() {
        ChunkPos chunkPos = this.currentChunkPos;
        ChunkSchematic schematicChunk = this.schematicWorld.getChunkProvider().getChunk(chunkPos.f_45578_, chunkPos.f_45579_);
        LevelChunk clientChunk = this.mc.f_91073_.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        boolean ignoreLimit = Configs.Generic.PASTE_IGNORE_CMD_LIMIT.getBooleanValue();
        while (this.positionIterator.hasNext() && this.queuedCommands.size() < this.maxCommandsPerTick && (!ignoreLimit || this.sentCommandsThisTick < this.maxCommandsPerTick)) {
            BlockPos pos = (BlockPos)this.positionIterator.next();
            this.pasteBlock(pos, schematicChunk, (ChunkAccess)clientChunk, ignoreLimit);
        }
        this.sendQueuedCommands();
        if (!this.positionIterator.hasNext() && this.queuedCommands.isEmpty()) {
            if (this.ignoreEntities) {
                this.onFinishedProcessingBox(this.currentChunkPos, this.currentBox);
            } else {
                this.prepareSummoningEntities(this.currentBox);
            }
        }
    }

    protected void processBlocksInCurrentBoxUsingFill() {
        ChunkPos chunkPos = this.currentChunkPos;
        int baseX = chunkPos.f_45578_ << 4;
        int baseZ = chunkPos.f_45579_ << 4;
        ChunkSchematic schematicChunk = this.schematicWorld.getChunkProvider().getChunk(chunkPos.f_45578_, chunkPos.f_45579_);
        LevelChunk clientChunk = this.mc.f_91073_.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        while (!this.fillVolumes.isEmpty() && this.queuedCommands.size() < this.maxCommandsPerTick) {
            int index = this.fillVolumes.size() - 1;
            long encodedValue = this.fillVolumes.removeLong(index);
            this.fillVolume(encodedValue, baseX, baseZ, schematicChunk, (ChunkAccess)clientChunk);
        }
        this.sendQueuedCommands();
        if (this.fillVolumes.isEmpty() && this.queuedCommands.isEmpty()) {
            if (this.ignoreEntities) {
                this.onFinishedProcessingBox(this.currentChunkPos, this.currentBox);
            } else {
                this.prepareSummoningEntities(this.currentBox);
            }
        }
    }

    protected void processEntitiesInCurrentBox() {
        while (this.entityIterator.hasNext() && this.queuedCommands.size() < this.maxCommandsPerTick) {
            this.summonEntity((Entity)this.entityIterator.next());
        }
        this.sendQueuedCommands();
        if (!this.entityIterator.hasNext() && this.queuedCommands.isEmpty()) {
            this.onFinishedProcessingBox(this.currentChunkPos, this.currentBox);
        }
    }

    protected void pasteBlock(BlockPos pos, LevelChunk schematicChunk, ChunkAccess clientChunk, boolean ignoreLimit) {
        BlockState stateClient;
        BlockState stateSchematic = schematicChunk.m_8055_(pos);
        if (this.shouldSetBlock(stateSchematic, stateClient = clientChunk.m_8055_(pos))) {
            PasteNbtBehavior nbtBehavior = this.nbtBehavior;
            BlockEntity be = schematicChunk.m_7702_(pos);
            if (be != null && nbtBehavior != PasteNbtBehavior.NONE) {
                Consumer<String> commandHandler = ignoreLimit ? this::sendCommand : this.queuedCommands::offer;
                Level schematicWorld = schematicChunk.m_62953_();
                if (nbtBehavior == PasteNbtBehavior.PLACE_MODIFY) {
                    this.setDataViaDataModify(pos, stateSchematic, be, schematicWorld, this.mc.f_91073_, commandHandler);
                } else if (nbtBehavior == PasteNbtBehavior.PLACE_CLONE) {
                    this.placeBlockViaClone(pos, stateSchematic, be, schematicWorld, this.mc.f_91073_, commandHandler);
                }
            } else {
                this.queueSetBlockCommand(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stateSchematic);
            }
        }
    }

    protected boolean shouldSetBlock(BlockState stateSchematic, BlockState stateClient) {
        if (stateSchematic.m_155947_() && Configs.Generic.PASTE_IGNORE_BE_ENTIRELY.getBooleanValue()) {
            return false;
        }
        if (stateSchematic.m_60795_() && stateClient.m_60795_() || this.changedBlockOnly && stateClient == stateSchematic) {
            return false;
        }
        return !(this.replace == ReplaceBehavior.NONE && !stateClient.m_60795_() || this.replace == ReplaceBehavior.WITH_NON_AIR && stateSchematic.m_60795_());
    }

    protected void summonEntity(Entity entity) {
        String id = EntityUtils.getEntityId(entity);
        if (id != null) {
            String command = String.format(Locale.ROOT, "%s %s %f %f %f", this.summonCommand, id, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (entity instanceof ItemFrame) {
                ItemFrame itemFrame = (ItemFrame)entity;
                command = this.getSummonCommandForItemFrame(itemFrame, command);
            }
            this.queuedCommands.offer(command);
        }
    }

    protected String getSummonCommandForItemFrame(ItemFrame itemFrame, String originalCommand) {
        ItemStack stack = itemFrame.m_31822_();
        if (!stack.m_41619_()) {
            ResourceLocation itemId = Registry.f_122827_.m_7981_((Object)stack.m_41720_());
            int facingId = itemFrame.m_6350_().m_122411_();
            String nbtStr = String.format(" {Facing:%db,Item:{id:\"%s\",Count:1b}}", facingId, itemId);
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                String itemNbt = tag.toString();
                String tmp = String.format(" {Facing:%db,Item:{id:\"%s\",Count:1b,tag:%s}}", facingId, itemId, itemNbt);
                if (originalCommand.length() + tmp.length() < 255) {
                    nbtStr = tmp;
                }
            }
            return originalCommand + nbtStr;
        }
        return originalCommand;
    }

    protected void queueSetBlockCommand(int x, int y, int z, BlockState state) {
        this.queueSetBlockCommand(x, y, z, state, this.queuedCommands::offer);
    }

    protected void queueSetBlockCommand(int x, int y, int z, BlockState state, Consumer<String> commandHandler) {
        String blockString = BlockStateParser.m_116769_((BlockState)state);
        if (this.useWorldEdit) {
            commandHandler.accept(String.format("/pos1 %d,%d,%d", x, y, z));
            commandHandler.accept(String.format("/pos2 %d,%d,%d", x, y, z));
            commandHandler.accept("/set " + blockString);
        } else {
            String cmdName = this.setBlockCommand;
            commandHandler.accept(String.format("%s %d %d %d %s", cmdName, x, y, z, blockString));
        }
        ++this.sentSetblockCommands;
    }

    protected void pasteVolume(int x1, int y1, int z1, int x2, int y2, int z2, BlockState state) {
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        int maxZ = Math.max(z1, z2);
        int singleLayerVolume = (maxX - minX + 1) * (maxZ - minZ + 1);
        int totalVolume = singleLayerVolume * (maxY - minY + 1);
        if (totalVolume <= this.maxBoxVolume || this.useWorldEdit) {
            this.queueFillCommandForBox(minX, minY, minZ, maxX, maxY, maxZ, state);
        } else {
            int singleBoxHeight = this.maxBoxVolume / singleLayerVolume;
            if (singleBoxHeight < 1) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"Error: Calculated single box height was less than 1 block", (Object[])new Object[0]);
                return;
            }
            for (int y = minY; y <= maxY; y += singleBoxHeight) {
                int boxMaxY = Math.min(y + singleBoxHeight - 1, maxY);
                this.queueFillCommandForBox(minX, y, minZ, maxX, boxMaxY, maxZ, state);
            }
        }
    }

    protected void queueFillCommandForBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState state) {
        String blockString = BlockStateParser.m_116769_((BlockState)state);
        if (this.useWorldEdit) {
            this.queuedCommands.offer(String.format("/pos1 %d,%d,%d", minX, minY, minZ));
            this.queuedCommands.offer(String.format("/pos2 %d,%d,%d", maxX, maxY, maxZ));
            this.queuedCommands.offer("/set " + blockString);
        } else {
            String cmdName = this.fillCommand;
            Object fillCommand = String.format("%s %d %d %d %d %d %d %s", cmdName, minX, minY, minZ, maxX, maxY, maxZ, blockString);
            if (this.replace == ReplaceBehavior.NONE || this.replace == ReplaceBehavior.WITH_NON_AIR && state.m_60795_()) {
                fillCommand = (String)fillCommand + " replace air";
            }
            this.queuedCommands.offer((String)fillCommand);
        }
        ++this.sentFillCommands;
    }

    protected void setDataViaDataModify(BlockPos pos, BlockState state, BlockEntity be, Level schematicWorld, ClientLevel clientWorld, Consumer<String> commandHandler) {
        BlockPos placementPos = this.placeNbtPickedBlock(pos, state, be, schematicWorld, clientWorld);
        if (placementPos != null) {
            this.queueSetBlockCommand(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), state, commandHandler);
            try {
                HashSet keys = new HashSet(be.m_187482_().m_128431_());
                keys.remove("id");
                keys.remove("x");
                keys.remove("y");
                keys.remove("z");
                for (String key : keys) {
                    String command = String.format("data modify block %d %d %d %s set from block %d %d %d %s", pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), key, placementPos.m_123341_(), placementPos.m_123342_(), placementPos.m_123343_(), key);
                    commandHandler.accept(command);
                }
            }
            catch (Exception keys) {
                // empty catch block
            }
            String cmdName = this.setBlockCommand;
            String command = String.format("%s %d %d %d air", cmdName, placementPos.m_123341_(), placementPos.m_123342_(), placementPos.m_123343_());
            commandHandler.accept(command);
        }
    }

    protected void placeBlockViaClone(BlockPos pos, BlockState state, BlockEntity be, Level schematicWorld, ClientLevel clientWorld, Consumer<String> commandHandler) {
        BlockPos placementPos = this.placeNbtPickedBlock(pos, state, be, schematicWorld, clientWorld);
        if (placementPos != null) {
            String command = String.format("%s %d %d %d %d %d %d %d %d %d", this.cloneCommand, placementPos.m_123341_(), placementPos.m_123342_(), placementPos.m_123343_(), placementPos.m_123341_(), placementPos.m_123342_(), placementPos.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            commandHandler.accept(command);
            String cmdName = this.setBlockCommand;
            command = String.format("%s %d %d %d air", cmdName, placementPos.m_123341_(), placementPos.m_123342_(), placementPos.m_123343_());
            commandHandler.accept(command);
        }
    }

    @Nullable
    protected BlockPos placeNbtPickedBlock(BlockPos pos, BlockState state, BlockEntity be, Level schematicWorld, ClientLevel clientWorld) {
        double reach = this.mc.f_91072_.m_105286_();
        BlockPos placementPos = this.findEmptyNearbyPosition((Level)clientWorld, this.mc.f_91074_.m_20182_(), 4, reach);
        if (placementPos != null && TaskPasteSchematicPerChunkCommand.preparePickedStack(pos, state, be, schematicWorld, this.mc)) {
            Vec3 posVec = new Vec3((double)placementPos.m_123341_() + 0.5, (double)placementPos.m_123342_() + 0.5, (double)placementPos.m_123343_() + 0.5);
            BlockHitResult hitResult = new BlockHitResult(posVec, Direction.UP, placementPos, true);
            this.mc.f_91072_.m_233732_(this.mc.f_91074_, InteractionHand.OFF_HAND, hitResult);
            this.placedPositionTimestamps.put(placementPos.m_121878_(), System.nanoTime());
            return placementPos;
        }
        return null;
    }

    protected void fillVolume(long encodedValue, int baseX, int baseZ, ChunkSchematic schematicChunk, ChunkAccess clientChunk) {
        int startPos = (int)encodedValue;
        int packedOffset = TaskPasteSchematicPerChunkCommand.getPackedSize(encodedValue);
        int startX = TaskPasteSchematicPerChunkCommand.unpackX(startPos) + baseX;
        int startY = TaskPasteSchematicPerChunkCommand.unpackY(startPos);
        int startZ = TaskPasteSchematicPerChunkCommand.unpackZ(startPos) + baseZ;
        int endOffsetX = TaskPasteSchematicPerChunkCommand.unpackX(packedOffset);
        int endOffsetY = TaskPasteSchematicPerChunkCommand.unpackY(packedOffset);
        int endOffsetZ = TaskPasteSchematicPerChunkCommand.unpackZ(packedOffset);
        this.mutablePos.m_122178_(startX, startY, startZ);
        if (endOffsetX > 0 || endOffsetY > 0 || endOffsetZ > 0 || Configs.Generic.PASTE_ALWAYS_USE_FILL.getBooleanValue()) {
            int endX = startX + endOffsetX;
            int endY = startY + endOffsetY;
            int endZ = startZ + endOffsetZ;
            BlockState state = schematicChunk.m_8055_((BlockPos)this.mutablePos);
            this.pasteVolume(startX, startY, startZ, endX, endY, endZ, state);
        } else {
            this.pasteBlock((BlockPos)this.mutablePos, schematicChunk, clientChunk, false);
        }
    }

    protected void generateFillVolumes(IntBoundingBox box) {
        ChunkSchematic chunk = this.schematicWorld.getChunkProvider().getChunk(box.minX >> 4, box.minZ >> 4);
        boolean ignoreBeFromFill = Configs.Generic.PASTE_IGNORE_BE_IN_FILL.getBooleanValue() && Configs.Generic.PASTE_NBT_BEHAVIOR.getOptionListValue() != PasteNbtBehavior.NONE;
        this.fillVolumes.clear();
        if (this.workArr == null) {
            int height = this.world.m_141928_();
            this.workArr = new int[16][height][16];
        }
        this.generateStrips(this.workArr, Direction.EAST, box, chunk, ignoreBeFromFill);
        this.combineStripsToLayers(this.workArr, Direction.EAST, Direction.SOUTH, Direction.UP, box, chunk, this.fillVolumes, ignoreBeFromFill);
        Collections.reverse(this.fillVolumes);
    }

    protected int getBlockStripLength(BlockPos.MutableBlockPos pos, Direction direction, int maxLength, BlockState firstState, ChunkAccess chunk) {
        int length;
        for (length = 1; length < maxLength; ++length) {
            pos.m_122173_(direction);
            BlockState state = chunk.m_8055_((BlockPos)pos);
            if (state != firstState) break;
        }
        return length;
    }

    protected void generateStrips(int[][][] workArr, Direction stripDirection, IntBoundingBox box, ChunkSchematic chunk, boolean ignoreBeFromFill) {
        boolean ignoreBeEntirely = Configs.Generic.PASTE_IGNORE_BE_ENTIRELY.getBooleanValue();
        BlockPos.MutableBlockPos mutablePos = this.mutablePos;
        ReplaceBehavior replace = this.replace;
        int startX = box.minX & 0xF;
        int startZ = box.minZ & 0xF;
        int endX = box.maxX & 0xF;
        int endZ = box.maxZ & 0xF;
        int worldMinY = chunk.m_141937_();
        for (int y = box.minY; y <= box.maxY; ++y) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int x = startX; x <= endX; ++x) {
                    int length;
                    mutablePos.m_122178_(x, y, z);
                    BlockState state = chunk.m_8055_((BlockPos)mutablePos);
                    if (state.m_60795_() && replace != ReplaceBehavior.ALL) continue;
                    if (state.m_155947_()) {
                        if (ignoreBeFromFill) {
                            workArr[x][y - worldMinY][z] = 1;
                            continue;
                        }
                        if (ignoreBeEntirely) continue;
                    }
                    workArr[x][y - worldMinY][z] = length = this.getBlockStripLength(mutablePos, stripDirection, endX - x + 1, state, (ChunkAccess)chunk);
                    x += length - 1;
                }
            }
        }
    }

    protected void combineStripsToLayers(int[][][] workArr, Direction stripDirection, Direction stripCombineDirection, Direction layerCombineDirection, IntBoundingBox box, ChunkSchematic chunk, LongArrayList volumesOut, boolean ignoreBe) {
        int nextZ;
        BlockState state;
        int nextY;
        int nextX;
        BlockPos.MutableBlockPos mutablePos = this.mutablePos;
        int sdOffX = stripDirection.m_122429_();
        int sdOffY = stripDirection.m_122430_();
        int sdOffZ = stripDirection.m_122431_();
        int scOffX = stripCombineDirection.m_122429_();
        int scOffY = stripCombineDirection.m_122430_();
        int scOffZ = stripCombineDirection.m_122431_();
        int lcOffX = layerCombineDirection.m_122429_();
        int lcOffY = layerCombineDirection.m_122430_();
        int lcOffZ = layerCombineDirection.m_122431_();
        int startX = box.minX & 0xF;
        int startZ = box.minZ & 0xF;
        int endX = box.maxX & 0xF;
        int endZ = box.maxZ & 0xF;
        int worldMinY = chunk.m_141937_();
        for (int y = box.minY; y <= box.maxY; ++y) {
            for (int x = startX; x <= endX; ++x) {
                for (int z = startZ; z <= endZ; ++z) {
                    int packedSize;
                    int length = workArr[x][y - worldMinY][z];
                    if (length <= 0) continue;
                    nextX = x + scOffX;
                    nextY = y + scOffY;
                    int stripCount = 1;
                    mutablePos.m_122178_(x, y, z);
                    state = chunk.m_8055_((BlockPos)mutablePos);
                    if (!ignoreBe || !state.m_155947_()) {
                        for (nextZ = z + scOffZ; nextX <= 15 && nextY <= box.maxY && nextZ <= 15 && workArr[nextX][nextY - worldMinY][nextZ] == length && chunk.m_8055_((BlockPos)mutablePos.m_122178_(nextX, nextY, nextZ)) == state; nextX += scOffX, nextY += scOffY, nextZ += scOffZ) {
                            ++stripCount;
                            workArr[nextX][nextY - worldMinY][nextZ] = 0;
                        }
                    }
                    int packedX = sdOffX * length + scOffX * stripCount;
                    int packedY = sdOffY * length + scOffY * stripCount;
                    int packedZ = sdOffZ * length + scOffZ * stripCount;
                    workArr[x][y - worldMinY][z] = packedSize = TaskPasteSchematicPerChunkCommand.packCoordinate5bit(packedX, packedY, packedZ);
                    if (stripCount <= 1) continue;
                    int extraStrips = stripCount - 1;
                    x += scOffX * extraStrips;
                    y += scOffY * extraStrips;
                    z += scOffZ * extraStrips;
                }
            }
        }
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int y = box.minY; y <= box.maxY; ++y) {
                    int packedSize = workArr[x][y - worldMinY][z];
                    if (packedSize == 0) continue;
                    nextX = x + lcOffX;
                    nextY = y + lcOffY;
                    int layerCount = 1;
                    mutablePos.m_122178_(x, y, z);
                    state = chunk.m_8055_((BlockPos)mutablePos);
                    if (!ignoreBe || !state.m_155947_()) {
                        for (nextZ = z + lcOffZ; nextX <= 15 && nextY <= box.maxY && nextZ <= 15 && workArr[nextX][nextY - worldMinY][nextZ] == packedSize && chunk.m_8055_((BlockPos)mutablePos.m_122178_(nextX, nextY, nextZ)) == state; nextX += lcOffX, nextY += lcOffY, nextZ += lcOffZ) {
                            ++layerCount;
                            workArr[nextX][nextY - worldMinY][nextZ] = 0;
                        }
                    }
                    int volumeEndOffsetX = lcOffX * layerCount + TaskPasteSchematicPerChunkCommand.unpackX5bit(packedSize) - 1;
                    int volumeEndOffsetY = lcOffY * layerCount + TaskPasteSchematicPerChunkCommand.unpackY5bit(packedSize) - 1;
                    int volumeEndOffsetZ = lcOffZ * layerCount + TaskPasteSchematicPerChunkCommand.unpackZ5bit(packedSize) - 1;
                    int packedVolumeEndOffset = TaskPasteSchematicPerChunkCommand.packCoordinate(volumeEndOffsetX, volumeEndOffsetY, volumeEndOffsetZ);
                    long encodedValue = (long)packedVolumeEndOffset << 32 | (long)TaskPasteSchematicPerChunkCommand.packCoordinate(x, y, z) & 0xFFFFFFFFL;
                    volumesOut.add(encodedValue);
                    workArr[x][y - worldMinY][z] = 0;
                    if (layerCount <= 1) continue;
                    int extraLayers = layerCount - 1;
                    x += lcOffX * extraLayers;
                    y += lcOffY * extraLayers;
                    z += lcOffZ * extraLayers;
                }
            }
        }
    }

    @Override
    protected void onStop() {
        if (this.finished) {
            if (this.printCompletionMessage) {
                if (this.useWorldEdit) {
                    InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.INFO, (String)"litematica.message.schematic_pasted_using_world_edit", (Object[])new Object[]{this.sentSetblockCommands + this.sentFillCommands});
                } else if (this.useFillCommand) {
                    InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.INFO, (String)"litematica.message.schematic_pasted_using_fill_and_setblock", (Object[])new Object[]{this.sentFillCommands, this.sentSetblockCommands});
                } else {
                    InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.INFO, (String)"litematica.message.schematic_pasted_using_setblock", (Object[])new Object[]{this.sentSetblockCommands});
                }
            }
        } else {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
        }
        this.sendTaskEndCommands();
        DataManager.removeChatListener(this.gameRuleListener);
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.onStop();
    }

    protected static int unpackX(int value) {
        return value & 0xF;
    }

    protected static int unpackY(int value) {
        return value >> 8;
    }

    protected static int unpackZ(int value) {
        return value >> 4 & 0xF;
    }

    protected static int packCoordinate(int x, int y, int z) {
        return y << 8 | (z & 0xF) << 4 | x & 0xF;
    }

    protected static int unpackX5bit(int value) {
        return value & 0x1F;
    }

    protected static int unpackY5bit(int value) {
        return value >> 10;
    }

    protected static int unpackZ5bit(int value) {
        return value >> 5 & 0x1F;
    }

    protected static int packCoordinate5bit(int x, int y, int z) {
        return y << 10 | (z & 0x1F) << 5 | x & 0x1F;
    }

    protected static int getPackedSize(long fullPackedValue) {
        return (int)(fullPackedValue >> 32);
    }

    @Nullable
    public BlockPos findEmptyNearbyPosition(Level world, Vec3 centerPos, int radius, double reachDistance) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos sidePos = new BlockPos.MutableBlockPos();
        long currentTime = System.nanoTime();
        long timeout = 2000000000L;
        double squaredReach = reachDistance * reachDistance;
        int radiusY = Math.min(radius, 2);
        for (double y = centerPos.m_7098_() - (double)radiusY; y <= centerPos.m_7098_() + (double)radiusY; y += 1.0) {
            for (double z = centerPos.m_7094_() - (double)radius; z <= centerPos.m_7094_() + (double)radius; z += 1.0) {
                for (double x = centerPos.m_7096_() - (double)radius; x <= centerPos.m_7096_() + (double)radius; x += 1.0) {
                    if (centerPos.m_82531_(x, y, z) > squaredReach || Mth.m_144939_((double)(centerPos.m_7096_() - x)) < 2 && Mth.m_144939_((double)(centerPos.m_7094_() - z)) < 2 && y >= centerPos.m_7098_() - 2.0 && y <= centerPos.m_7098_() + 2.0) continue;
                    pos.m_122169_(x, y, z);
                    long posLong = pos.m_121878_();
                    if (this.placedPositionTimestamps.containsKey(posLong) && currentTime - this.placedPositionTimestamps.get(posLong) < timeout || !TaskPasteSchematicPerChunkCommand.isPositionAndSidesEmpty(world, (BlockPos)pos, sidePos)) continue;
                    return pos.m_7949_();
                }
            }
        }
        return null;
    }

    public static boolean isPositionAndSidesEmpty(Level world, BlockPos centerPos, BlockPos.MutableBlockPos pos) {
        if (!world.m_46859_(centerPos)) {
            return false;
        }
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            if (world.m_46859_((BlockPos)pos.m_122159_((Vec3i)centerPos, side))) continue;
            return false;
        }
        return true;
    }

    protected static boolean preparePickedStack(BlockPos pos, BlockState state, BlockEntity be, Level world, Minecraft mc) {
        ItemStack stack = state.m_60734_().m_7397_((BlockGetter)world, pos, state);
        if (!stack.m_41619_()) {
            TaskPasteSchematicPerChunkCommand.addBlockEntityNbt(stack, be);
            mc.f_91074_.m_150109_().f_35976_.set(0, (Object)stack);
            mc.f_91072_.m_105241_(stack, 45);
            return true;
        }
        return false;
    }

    public static void addBlockEntityNbt(ItemStack stack, BlockEntity be) {
        CompoundTag tag = be.m_187482_();
        if (stack.m_41720_() instanceof PlayerHeadItem && tag.m_128441_("SkullOwner")) {
            CompoundTag ownerTag = tag.m_128469_("SkullOwner");
            stack.m_41784_().m_128365_("SkullOwner", (Tag)ownerTag);
        } else {
            stack.m_41700_("BlockEntityTag", (Tag)tag);
        }
    }
}

