/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.mojang.datafixers.DataFixer;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.mixin.IMixinSignBlockEntity;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.EasyPlaceProtocol;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.FileType;
import fi.dy.masa.litematica.util.IWorldUpdateSuppressor;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.litematica.util.PlacementHandler;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.MessageOutputType;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WorldUtils {
    private static final List<PositionCache> EASY_PLACE_POSITIONS = new ArrayList<PositionCache>();
    private static long easyPlaceLastPickBlockTime = System.nanoTime();

    public static boolean shouldPreventBlockUpdates(Level world) {
        return ((IWorldUpdateSuppressor)world).litematica_getShouldPreventBlockUpdates();
    }

    public static void setShouldPreventBlockUpdates(Level world, boolean preventUpdates) {
        ((IWorldUpdateSuppressor)world).litematica_setShouldPreventBlockUpdates(preventUpdates);
    }

    public static boolean convertSchematicaSchematicToLitematicaSchematic(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertSchematicaSchematicToLitematicaSchematic(inputDir, inputFileName, ignoreEntities, feedback);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    @Nullable
    public static LitematicaSchematic convertSchematicaSchematicToLitematicaSchematic(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        SchematicaSchematic schematic = SchematicaSchematic.createFromFile(new File(inputDir, inputFileName));
        if (schematic == null) {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_read_schematic");
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.createSchematicWorld(null);
        WorldUtils.loadChunksSchematicWorld(world, BlockPos.f_121853_, schematic.getSize());
        StructurePlaceSettings placementSettings = new StructurePlaceSettings();
        placementSettings.m_74392_(ignoreEntities);
        schematic.placeSchematicDirectlyToChunks(world, BlockPos.f_121853_, placementSettings);
        Object subRegionName = FileUtils.getNameWithoutExtension((String)inputFileName) + " (Converted Schematic)";
        AreaSelection area = new AreaSelection();
        area.setName((String)subRegionName);
        subRegionName = area.createNewSubRegionBox(BlockPos.f_121853_, (String)subRegionName);
        area.setSelectedSubRegionBox((String)subRegionName);
        Box box = area.getSelectedSubRegionBox();
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_1, BlockPos.f_121853_);
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_2, new BlockPos(schematic.getSize()).m_7918_(-1, -1, -1));
        LitematicaSchematic.SchematicSaveInfo info = new LitematicaSchematic.SchematicSaveInfo(false, false);
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromWorld(world, area, info, "?", feedback);
        if (litematicaSchematic != null && !ignoreEntities) {
            litematicaSchematic.takeEntityDataFromSchematicaSchematic(schematic, (String)subRegionName);
        } else {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_create_schematic");
        }
        return litematicaSchematic;
    }

    public static boolean convertStructureToLitematicaSchematic(File structureDir, String structureFileName, File outputDir, String outputFileName, boolean override) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertStructureToLitematicaSchematic(structureDir, structureFileName);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    @Nullable
    public static LitematicaSchematic convertSpongeSchematicToLitematicaSchematic(File dir, String fileName) {
        try {
            LitematicaSchematic schematic = LitematicaSchematic.createFromFile(dir, fileName, FileType.SPONGE_SCHEMATIC);
            if (schematic == null) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to read the Sponge schematic from '" + fileName + "\""), (Object[])new Object[0]);
            }
            return schematic;
        }
        catch (Exception e) {
            String msg = "Exception while trying to load the Sponge schematic: " + e.getMessage();
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)msg, (Object[])new Object[0]);
            Litematica.logger.error(msg);
            return null;
        }
    }

    @Nullable
    public static LitematicaSchematic convertStructureToLitematicaSchematic(File structureDir, String structureFileName) {
        try {
            LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(structureDir, structureFileName, FileType.VANILLA_STRUCTURE);
            if (litematicaSchematic == null) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to read the vanilla structure template from '" + structureFileName + "\""), (Object[])new Object[0]);
            }
            return litematicaSchematic;
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Exception while trying to load the vanilla structure: " + e.getMessage()), (Object[])new Object[0]);
            Litematica.logger.error("Exception while trying to load the vanilla structure: " + e.getMessage());
            return null;
        }
    }

    public static boolean convertLitematicaSchematicToSchematicaSchematic(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        return false;
    }

    public static boolean convertLitematicaSchematicToVanillaStructure(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        StructureTemplate template = WorldUtils.convertLitematicaSchematicToVanillaStructure(inputDir, inputFileName, ignoreEntities, feedback);
        return WorldUtils.writeVanillaStructureToFile(template, outputDir, outputFileName, override, feedback);
    }

    @Nullable
    public static StructureTemplate convertLitematicaSchematicToVanillaStructure(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(inputDir, inputFileName);
        if (litematicaSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_read_schematic");
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.createSchematicWorld(null);
        BlockPos size = new BlockPos(litematicaSchematic.getTotalSize());
        WorldUtils.loadChunksSchematicWorld(world, BlockPos.f_121853_, (Vec3i)size);
        SchematicPlacement schematicPlacement = SchematicPlacement.createForSchematicConversion(litematicaSchematic, BlockPos.f_121853_);
        litematicaSchematic.placeToWorld(world, schematicPlacement, false);
        StructureTemplate template = new StructureTemplate();
        template.m_163802_((Level)world, BlockPos.f_121853_, (Vec3i)size, !ignoreEntities, Blocks.f_50454_);
        return template;
    }

    private static boolean writeVanillaStructureToFile(StructureTemplate template, File dir, String fileNameIn, boolean override, IStringConsumer feedback) {
        Object fileName = fileNameIn;
        String extension = ".nbt";
        if (!((String)fileName).endsWith(extension)) {
            fileName = (String)fileName + extension;
        }
        File file = new File(dir, (String)fileName);
        FileOutputStream os = null;
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.schematic_write_to_file_failed.directory_creation_failed", (Object[])new Object[]{dir.getAbsolutePath()}));
                return false;
            }
            if (!override && file.exists()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exists", (Object[])new Object[]{file.getAbsolutePath()}));
                return false;
            }
            CompoundTag tag = template.m_74618_(new CompoundTag());
            os = new FileOutputStream(file);
            NbtIo.m_128947_((CompoundTag)tag, (OutputStream)os);
            os.close();
            return true;
        }
        catch (Exception e) {
            feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exception", (Object[])new Object[]{file.getAbsolutePath()}));
            return false;
        }
    }

    private static StructureTemplate readTemplateFromStream(InputStream stream, DataFixer fixer) throws IOException {
        CompoundTag nbt = NbtIo.m_128939_((InputStream)stream);
        StructureTemplate template = new StructureTemplate();
        template.m_74638_(nbt);
        return template;
    }

    public static boolean isClientChunkLoaded(ClientLevel world, int chunkX, int chunkZ) {
        return world.m_7726_().m_7587_(chunkX, chunkZ, ChunkStatus.f_62326_, false) != null;
    }

    public static void loadChunksSchematicWorld(WorldSchematic world, BlockPos origin, Vec3i areaSize) {
        BlockPos posEnd = origin.m_121955_((Vec3i)PositionUtils.getRelativeEndPositionFromAreaSize(areaSize));
        BlockPos posMin = PositionUtils.getMinCorner(origin, posEnd);
        BlockPos posMax = PositionUtils.getMaxCorner(origin, posEnd);
        int cxMin = posMin.m_123341_() >> 4;
        int czMin = posMin.m_123343_() >> 4;
        int cxMax = posMax.m_123341_() >> 4;
        int czMax = posMax.m_123343_() >> 4;
        for (int cz = czMin; cz <= czMax; ++cz) {
            for (int cx = cxMin; cx <= cxMax; ++cx) {
                world.getChunkProvider().loadChunk(cx, cz);
            }
        }
    }

    public static void setToolModeBlockState(ToolMode mode, boolean primary, Minecraft mc) {
        BlockHitResult trace;
        BlockState state = Blocks.f_50016_.m_49966_();
        Entity entity = fi.dy.masa.malilib.util.EntityUtils.getCameraEntity();
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getGenericTrace((Level)mc.f_91073_, entity, 6.0);
        if (wrapper != null && (trace = wrapper.getBlockHitResult()) != null && trace.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = trace.m_82425_();
            if (wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
                state = SchematicWorldHandler.getSchematicWorld().m_8055_(pos);
            } else if (wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA_BLOCK) {
                state = mc.f_91073_.m_8055_(pos);
            }
        }
        if (primary) {
            mode.setPrimaryBlock(state);
        } else {
            mode.setSecondaryBlock(state);
        }
    }

    public static boolean doSchematicWorldPickBlock(boolean closest, Minecraft mc) {
        BlockPos pos = closest ? RayTraceUtils.getSchematicWorldTraceIfClosest((Level)mc.f_91073_, (Entity)mc.f_91074_, 6.0) : RayTraceUtils.getFurthestSchematicWorldBlockBeforeVanilla((Level)mc.f_91073_, (Entity)mc.f_91074_, 6.0, true);
        if (pos != null) {
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            BlockState state = world.m_8055_(pos);
            ItemStack stack = MaterialCache.getInstance().getRequiredBuildItemForState(state, world, pos);
            InventoryUtils.schematicWorldPickBlock(stack, pos, world, mc);
            return true;
        }
        return false;
    }

    public static void insertSignTextFromSchematic(SignBlockEntity beClient, String[] screenTextArr) {
        Component[] textSchematic;
        BlockEntity beSchem;
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        if (worldSchematic != null && (beSchem = worldSchematic.m_7702_(beClient.m_58899_())) instanceof SignBlockEntity && (textSchematic = ((IMixinSignBlockEntity)beSchem).litematica_getText()) != null) {
            for (int i = 0; i < screenTextArr.length; ++i) {
                screenTextArr[i] = textSchematic[i].getString();
                beClient.m_59732_(i, textSchematic[i]);
            }
        }
    }

    public static void easyPlaceOnUseTick(Minecraft mc) {
        if (mc.f_91074_ != null && DataManager.getToolMode() != ToolMode.REBUILD && Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && Configs.Generic.EASY_PLACE_HOLD_ENABLED.getBooleanValue() && Hotkeys.EASY_PLACE_ACTIVATION.getKeybind().isKeybindHeld()) {
            WorldUtils.doEasyPlaceAction(mc);
        }
    }

    public static boolean handleEasyPlace(Minecraft mc) {
        if (Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && DataManager.getToolMode() != ToolMode.REBUILD) {
            InteractionResult result = WorldUtils.doEasyPlaceAction(mc);
            if (result == InteractionResult.FAIL) {
                MessageOutputType type = (MessageOutputType)Configs.Generic.PLACEMENT_RESTRICTION_WARN.getOptionListValue();
                if (type == MessageOutputType.MESSAGE) {
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.easy_place_fail", (Object[])new Object[0]);
                } else if (type == MessageOutputType.ACTIONBAR) {
                    InfoUtils.printActionbarMessage((String)"litematica.message.easy_place_fail", (Object[])new Object[0]);
                }
                return true;
            }
            return result != InteractionResult.PASS;
        }
        return false;
    }

    private static InteractionResult doEasyPlaceAction(Minecraft mc) {
        RayTraceUtils.RayTraceWrapper traceWrapper;
        double traceMaxRange;
        double d = traceMaxRange = Configs.Generic.EASY_PLACE_VANILLA_REACH.getBooleanValue() ? 4.5 : 6.0;
        if (Configs.Generic.EASY_PLACE_FIRST.getBooleanValue()) {
            boolean targetFluids = Configs.InfoOverlays.INFO_OVERLAYS_TARGET_FLUIDS.getBooleanValue();
            traceWrapper = RayTraceUtils.getGenericTrace((Level)mc.f_91073_, (Entity)mc.f_91074_, traceMaxRange, true, targetFluids, false);
        } else {
            traceWrapper = RayTraceUtils.getFurthestSchematicWorldTraceBeforeVanilla((Level)mc.f_91073_, (Entity)mc.f_91074_, traceMaxRange);
        }
        if (traceWrapper == null) {
            return InteractionResult.PASS;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockHitResult trace = traceWrapper.getBlockHitResult();
            HitResult traceVanilla = RayTraceUtils.getRayTraceFromEntity((Level)mc.f_91073_, (Entity)mc.f_91074_, false, traceMaxRange);
            BlockPos pos = trace.m_82425_();
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            BlockState stateSchematic = world.m_8055_(pos);
            ItemStack stack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
            if (WorldUtils.easyPlaceIsPositionCached(pos)) {
                return InteractionResult.FAIL;
            }
            if (WorldUtils.easyPlaceIsTooFast()) {
                return InteractionResult.FAIL;
            }
            if (!stack.m_41619_()) {
                BlockState stateClient = mc.f_91073_.m_8055_(pos);
                if (stateSchematic == stateClient) {
                    return InteractionResult.FAIL;
                }
                if (WorldUtils.easyPlaceBlockChecksCancel(stateSchematic, stateClient, (Player)mc.f_91074_, traceVanilla, stack)) {
                    return InteractionResult.FAIL;
                }
                InventoryUtils.schematicWorldPickBlock(stack, pos, world, mc);
                InteractionHand hand = EntityUtils.getUsedHandForItem((Player)mc.f_91074_, stack);
                if (hand == null) {
                    return InteractionResult.FAIL;
                }
                Vec3 hitPos = trace.m_82450_();
                Direction sideOrig = trace.m_82434_();
                if (traceVanilla != null && traceVanilla.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult hitResult = (BlockHitResult)traceVanilla;
                    BlockPos posVanilla = hitResult.m_82425_();
                    Direction sideVanilla = hitResult.m_82434_();
                    BlockState stateVanilla = mc.f_91073_.m_8055_(posVanilla);
                    Vec3 hit = traceVanilla.m_82450_();
                    BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)mc.f_91074_, hand, hitResult));
                    if (!stateVanilla.m_60629_(ctx) && pos.equals((Object)(posVanilla = posVanilla.m_121945_(sideVanilla)))) {
                        hitPos = hit;
                        sideOrig = sideVanilla;
                    }
                }
                Direction side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                EasyPlaceProtocol protocol = PlacementHandler.getEffectiveProtocolVersion();
                if (protocol == EasyPlaceProtocol.V3) {
                    hitPos = WorldUtils.applyPlacementProtocolV3(pos, stateSchematic, hitPos);
                } else if (protocol == EasyPlaceProtocol.V2) {
                    hitPos = WorldUtils.applyCarpetProtocolHitVec(pos, stateSchematic, hitPos);
                } else if (protocol == EasyPlaceProtocol.SLAB_ONLY) {
                    hitPos = WorldUtils.applyBlockSlabProtocol(pos, stateSchematic, hitPos);
                }
                WorldUtils.cacheEasyPlacePosition(pos);
                BlockHitResult hitResult = new BlockHitResult(hitPos, side, pos, false);
                mc.f_91072_.m_233732_(mc.f_91074_, hand, hitResult);
                if (stateSchematic.m_60734_() instanceof SlabBlock && stateSchematic.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE && (stateClient = mc.f_91073_.m_8055_(pos)).m_60734_() instanceof SlabBlock && stateClient.m_61143_((Property)SlabBlock.f_56353_) != SlabType.DOUBLE) {
                    side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                    hitResult = new BlockHitResult(hitPos, side, pos, false);
                    mc.f_91072_.m_233732_(mc.f_91074_, hand, hitResult);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA_BLOCK) {
            return WorldUtils.placementRestrictionInEffect(mc) ? InteractionResult.FAIL : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private static boolean easyPlaceBlockChecksCancel(BlockState stateSchematic, BlockState stateClient, Player player, HitResult trace, ItemStack stack) {
        Block blockClient;
        Block blockSchematic = stateSchematic.m_60734_();
        if (blockSchematic instanceof SlabBlock && stateSchematic.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE && (blockClient = stateClient.m_60734_()) instanceof SlabBlock && stateClient.m_61143_((Property)SlabBlock.f_56353_) != SlabType.DOUBLE) {
            return blockSchematic != blockClient;
        }
        if (trace.m_6662_() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockHitResult hitResult = (BlockHitResult)trace;
        BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, hitResult));
        return !stateClient.m_60629_(ctx);
    }

    public static Vec3 applyCarpetProtocolHitVec(BlockPos pos, BlockState state, Vec3 hitVecIn) {
        double x = hitVecIn.f_82479_;
        double y = hitVecIn.f_82480_;
        double z = hitVecIn.f_82481_;
        Block block = state.m_60734_();
        Direction facing = BlockUtils.getFirstPropertyFacingValue((BlockState)state);
        int propertyIncrement = 16;
        boolean hasData = false;
        int protocolValue = 0;
        if (facing != null) {
            protocolValue = facing.m_122411_();
            hasData = true;
        } else if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
            protocolValue = axis.ordinal();
            hasData = true;
        }
        if (block instanceof RepeaterBlock) {
            protocolValue += (Integer)state.m_61143_((Property)RepeaterBlock.f_55798_) * 16;
        } else if (block instanceof ComparatorBlock && state.m_61143_((Property)ComparatorBlock.f_51854_) == ComparatorMode.SUBTRACT) {
            protocolValue += 16;
        } else if (state.m_61138_((Property)BlockStateProperties.f_61402_) && state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP) {
            protocolValue += 16;
        } else if (state.m_61138_((Property)BlockStateProperties.f_61397_) && state.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.TOP) {
            protocolValue += 16;
        }
        y = WorldUtils.applySlabOrStairHitVecY(y, pos, state);
        if (protocolValue != 0 || hasData) {
            x += (double)(protocolValue * 2 + 2);
        }
        return new Vec3(x, y, z);
    }

    private static double applySlabOrStairHitVecY(double origY, BlockPos pos, BlockState state) {
        double y = origY;
        if (state.m_61138_((Property)BlockStateProperties.f_61397_)) {
            y = pos.m_123342_();
            if (state.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.TOP) {
                y += 0.99;
            }
        } else if (state.m_61138_((Property)BlockStateProperties.f_61402_)) {
            y = pos.m_123342_();
            if (state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP) {
                y += 0.99;
            }
        }
        return y;
    }

    private static Vec3 applyBlockSlabProtocol(BlockPos pos, BlockState state, Vec3 hitVecIn) {
        double newY = WorldUtils.applySlabOrStairHitVecY(hitVecIn.f_82480_, pos, state);
        return newY != hitVecIn.f_82480_ ? new Vec3(hitVecIn.f_82479_, newY, hitVecIn.f_82481_) : hitVecIn;
    }

    public static <T extends Comparable<T>> Vec3 applyPlacementProtocolV3(BlockPos pos, BlockState state, Vec3 hitVecIn) {
        Collection props = state.m_60734_().m_49965_().m_61092_();
        if (props.isEmpty()) {
            return hitVecIn;
        }
        double relX = hitVecIn.f_82479_ - (double)pos.m_123341_();
        int protocolValue = 0;
        int shiftAmount = 1;
        int propCount = 0;
        DirectionProperty property = BlockUtils.getFirstDirectionProperty((BlockState)state);
        if (property != null && property != BlockStateProperties.f_155997_) {
            Direction direction = (Direction)state.m_61143_((Property)property);
            protocolValue |= direction.m_122411_() << shiftAmount;
            shiftAmount += 3;
            ++propCount;
        }
        ArrayList<Property> propList = new ArrayList<Property>(props);
        propList.sort(Comparator.comparing(Property::m_61708_));
        try {
            for (Property p : propList) {
                if (p instanceof DirectionProperty || !PlacementHandler.WHITELISTED_PROPERTIES.contains((Object)p)) continue;
                Property prop = p;
                ArrayList list = new ArrayList(prop.m_6908_());
                list.sort(Comparable::compareTo);
                int requiredBits = Mth.m_14173_((int)Mth.m_14125_((int)list.size()));
                int valueIndex = list.indexOf(state.m_61143_(prop));
                if (valueIndex == -1) continue;
                protocolValue |= valueIndex << shiftAmount;
                shiftAmount += requiredBits;
                ++propCount;
            }
        }
        catch (Exception e) {
            Litematica.logger.warn("Exception trying to request placement protocol value", (Throwable)e);
        }
        if (propCount > 0) {
            double x = (double)pos.m_123341_() + relX + 2.0 + (double)protocolValue;
            return new Vec3(x, hitVecIn.f_82480_, hitVecIn.f_82481_);
        }
        return hitVecIn;
    }

    private static Direction applyPlacementFacing(BlockState stateSchematic, Direction side, BlockState stateClient) {
        Block blockSchematic = stateSchematic.m_60734_();
        Block blockClient = stateClient.m_60734_();
        if (blockSchematic instanceof SlabBlock) {
            if (stateSchematic.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE && blockClient instanceof SlabBlock && stateClient.m_61143_((Property)SlabBlock.f_56353_) != SlabType.DOUBLE) {
                if (stateClient.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP) {
                    return Direction.DOWN;
                }
                return Direction.UP;
            }
            return Direction.NORTH;
        }
        if (stateSchematic.m_61138_((Property)BlockStateProperties.f_61402_)) {
            side = stateSchematic.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP ? Direction.DOWN : Direction.UP;
        }
        return side;
    }

    public static boolean handlePlacementRestriction(Minecraft mc) {
        boolean cancel = WorldUtils.placementRestrictionInEffect(mc);
        if (cancel) {
            MessageOutputType type = (MessageOutputType)Configs.Generic.PLACEMENT_RESTRICTION_WARN.getOptionListValue();
            if (type == MessageOutputType.MESSAGE) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.placement_restriction_fail", (Object[])new Object[0]);
            } else if (type == MessageOutputType.ACTIONBAR) {
                InfoUtils.printActionbarMessage((String)"litematica.message.placement_restriction_fail", (Object[])new Object[0]);
            }
        }
        return cancel;
    }

    private static boolean placementRestrictionInEffect(Minecraft mc) {
        HitResult trace = mc.f_91077_;
        ItemStack stack = mc.f_91074_.m_21205_();
        if (stack.m_41619_()) {
            stack = mc.f_91074_.m_21206_();
        }
        if (stack.m_41619_()) {
            return false;
        }
        if (trace != null && trace.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)trace;
            BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)mc.f_91074_, InteractionHand.MAIN_HAND, blockHitResult));
            BlockPos pos = ctx.m_8083_();
            BlockState stateClient = mc.f_91073_.m_8055_(pos);
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            LayerRange range = DataManager.getRenderLayerRange();
            boolean schematicHasAir = worldSchematic.m_46859_(pos);
            if (!schematicHasAir && !range.isPositionWithinRange(pos)) {
                return true;
            }
            if (schematicHasAir && WorldUtils.isPositionWithinRangeOfSchematicRegions(pos, 2)) {
                return true;
            }
            ctx = new BlockPlaceContext(new UseOnContext((Player)mc.f_91074_, InteractionHand.MAIN_HAND, blockHitResult = new BlockHitResult(blockHitResult.m_82450_(), blockHitResult.m_82434_(), pos, false)));
            if (!stateClient.m_60629_(ctx)) {
                return true;
            }
            BlockState stateSchematic = worldSchematic.m_8055_(pos);
            stack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
            if (!stack.m_41619_() && EntityUtils.getUsedHandForItem((Player)mc.f_91074_, stack) == null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPositionWithinRangeOfSchematicRegions(BlockPos pos, int range) {
        SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int minCX = x - range >> 4;
        int minCZ = z - range >> 4;
        int maxCX = x + range >> 4;
        int maxCZ = z + range >> 4;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                List<SchematicPlacementManager.PlacementPart> parts = manager.getPlacementPartsInChunk(cx, cz);
                for (SchematicPlacementManager.PlacementPart part : parts) {
                    IntBoundingBox box = part.bb;
                    if (x < box.minX - range || x > box.maxX + range || y < box.minY - range || y > box.maxY + range || z < box.minZ - range || z > box.maxZ + range) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isSliceEmpty(Level world, Direction.Axis axis, BlockPos pos1, BlockPos pos2) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        switch (axis) {
            case Z: {
                int x1 = Math.min(pos1.m_123341_(), pos2.m_123341_());
                int x2 = Math.max(pos1.m_123341_(), pos2.m_123341_());
                int y1 = Math.min(pos1.m_123342_(), pos2.m_123342_());
                int y2 = Math.max(pos1.m_123342_(), pos2.m_123342_());
                int z = pos1.m_123343_();
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                for (int cx = cxMin; cx <= cxMax; ++cx) {
                    LevelChunk chunk = world.m_6325_(cx, z >> 4);
                    int xMin = Math.max(x1, cx << 4);
                    int xMax = Math.min(x2, (cx << 4) + 15);
                    int yMax = Math.min(y2, chunk.m_62098_() + 15);
                    for (int x = xMin; x <= xMax; ++x) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.m_8055_((BlockPos)posMutable.m_122178_(x, y, z)).m_60795_()) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case Y: {
                int x1 = Math.min(pos1.m_123341_(), pos2.m_123341_());
                int x2 = Math.max(pos1.m_123341_(), pos2.m_123341_());
                int y = pos1.m_123342_();
                int z1 = Math.min(pos1.m_123343_(), pos2.m_123343_());
                int z2 = Math.max(pos1.m_123343_(), pos2.m_123343_());
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    for (int cx = cxMin; cx <= cxMax; ++cx) {
                        LevelChunk chunk = world.m_6325_(cx, cz);
                        if (y > chunk.m_62098_() + 15) continue;
                        int xMin = Math.max(x1, cx << 4);
                        int xMax = Math.min(x2, (cx << 4) + 15);
                        int zMin = Math.max(z1, cz << 4);
                        int zMax = Math.min(z2, (cz << 4) + 15);
                        for (int z = zMin; z <= zMax; ++z) {
                            for (int x = xMin; x <= xMax; ++x) {
                                if (chunk.m_8055_((BlockPos)posMutable.m_122178_(x, y, z)).m_60795_()) continue;
                                return false;
                            }
                        }
                    }
                }
                break;
            }
            case X: {
                int x = pos1.m_123341_();
                int z1 = Math.min(pos1.m_123343_(), pos2.m_123343_());
                int z2 = Math.max(pos1.m_123343_(), pos2.m_123343_());
                int y1 = Math.min(pos1.m_123342_(), pos2.m_123342_());
                int y2 = Math.max(pos1.m_123342_(), pos2.m_123342_());
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    LevelChunk chunk = world.m_6325_(x >> 4, cz);
                    int zMin = Math.max(z1, cz << 4);
                    int zMax = Math.min(z2, (cz << 4) + 15);
                    int yMax = Math.min(y2, chunk.m_62098_() + 15);
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.m_8055_((BlockPos)posMutable.m_122178_(x, y, z)).m_60795_()) continue;
                            return false;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    public static boolean easyPlaceIsPositionCached(BlockPos pos) {
        long currentTime = System.nanoTime();
        boolean cached = false;
        for (int i = 0; i < EASY_PLACE_POSITIONS.size(); ++i) {
            PositionCache val = EASY_PLACE_POSITIONS.get(i);
            boolean expired = val.hasExpired(currentTime);
            if (expired) {
                EASY_PLACE_POSITIONS.remove(i);
                --i;
                continue;
            }
            if (!val.getPos().equals((Object)pos)) continue;
            cached = true;
            if (EASY_PLACE_POSITIONS.size() < 16) break;
        }
        return cached;
    }

    private static void cacheEasyPlacePosition(BlockPos pos) {
        EASY_PLACE_POSITIONS.add(new PositionCache(pos, System.nanoTime(), 2000000000L));
    }

    private static boolean easyPlaceIsTooFast() {
        return System.nanoTime() - easyPlaceLastPickBlockTime < 1000000L * (long)Configs.Generic.EASY_PLACE_SWAP_INTERVAL.getIntegerValue();
    }

    public static void setEasyPlaceLastPickBlockTime() {
        easyPlaceLastPickBlockTime = System.nanoTime();
    }

    public static class PositionCache {
        private final BlockPos pos;
        private final long time;
        private final long timeout;

        private PositionCache(BlockPos pos, long time, long timeout) {
            this.pos = pos;
            this.time = time;
            this.timeout = timeout;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public boolean hasExpired(long currentTime) {
            return currentTime - this.time > this.timeout;
        }
    }
}

