/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;

public class SchematicWorldHandler {
    public static final SchematicWorldHandler INSTANCE = new SchematicWorldHandler(LitematicaRenderer.getInstance()::getWorldRenderer);
    protected final Supplier<WorldRendererSchematic> rendererSupplier;
    @Nullable
    protected WorldSchematic world;

    public SchematicWorldHandler(Supplier<WorldRendererSchematic> rendererSupplier) {
        this.rendererSupplier = rendererSupplier;
    }

    @Nullable
    public static WorldSchematic getSchematicWorld() {
        return INSTANCE.getWorld();
    }

    @Nullable
    public WorldSchematic getWorld() {
        if (this.world == null) {
            this.world = SchematicWorldHandler.createSchematicWorld(this.rendererSupplier.get());
        }
        return this.world;
    }

    public static WorldSchematic createSchematicWorld(@Nullable WorldRendererSchematic worldRenderer) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return null;
        }
        ClientLevel.ClientLevelData levelInfo = new ClientLevel.ClientLevelData(Difficulty.PEACEFUL, false, true);
        Holder entry = BuiltinRegistries.f_235987_.m_206081_(BuiltinDimensionTypes.f_223538_);
        return new WorldSchematic((WritableLevelData)levelInfo, (Holder<DimensionType>)entry, () -> ((Minecraft)Minecraft.m_91087_()).m_91307_(), worldRenderer);
    }

    public void recreateSchematicWorld(boolean remove) {
        if (remove) {
            Litematica.debugLog("Removing the schematic world...", new Object[0]);
            this.world = null;
        } else {
            Litematica.debugLog("(Re-)creating the schematic world...", new Object[0]);
            WorldRendererSchematic worldRenderer = this.world != null ? this.world.worldRenderer : LitematicaRenderer.getInstance().getWorldRenderer();
            this.world = SchematicWorldHandler.createSchematicWorld(worldRenderer);
            Litematica.debugLog("Schematic world (re-)created: {}", new Object[]{this.world});
        }
        LitematicaRenderer.getInstance().onSchematicWorldChanged(this.world);
    }
}

