/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import superlord.goblinsanddungeons.compat.QuarkFlagRecipeCondition;
import superlord.goblinsanddungeons.compat.RegistryHelper;
import superlord.goblinsanddungeons.config.GDConfigHolder;
import superlord.goblinsanddungeons.config.GoblinsDungeonsConfig;
import superlord.goblinsanddungeons.entity.GarchEntity;
import superlord.goblinsanddungeons.entity.GobEntity;
import superlord.goblinsanddungeons.entity.GobKingEntity;
import superlord.goblinsanddungeons.entity.GobberEntity;
import superlord.goblinsanddungeons.entity.GobloEntity;
import superlord.goblinsanddungeons.entity.GoomEntity;
import superlord.goblinsanddungeons.entity.HobGobEntity;
import superlord.goblinsanddungeons.entity.MimicEntity;
import superlord.goblinsanddungeons.entity.OgreEntity;
import superlord.goblinsanddungeons.init.BlockInit;
import superlord.goblinsanddungeons.init.ConfiguredStructureInit;
import superlord.goblinsanddungeons.init.EffectInit;
import superlord.goblinsanddungeons.init.EntityInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.StructureInit;
import superlord.goblinsanddungeons.world.GoblinsAndDungeonsFeatures;

@Mod(value="goblinsanddungeons")
@Mod.EventBusSubscriber(modid="goblinsanddungeons")
public class GoblinsAndDungeons {
    public static final String MOD_ID = "goblinsanddungeons";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("goblinsanddungeons");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK_WRAPPER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("goblinsanddungeons", "main_channel")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();
    private static Method GETCODEC_METHOD;
    public static final ItemGroup GROUP;

    public GoblinsAndDungeons() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::registerCommon);
        bus.addListener(this::setup);
        CraftingHelper.register((IConditionSerializer)new QuarkFlagRecipeCondition.Serializer());
        REGISTRY_HELPER.getDeferredBlockRegister().register(bus);
        REGISTRY_HELPER.getDeferredItemRegister().register(bus);
        BlockInit.REGISTER.register(bus);
        ItemInit.REGISTER.register(bus);
        EntityInit.REGISTER.register(bus);
        StructureInit.REGISTER.register(bus);
        EffectInit.EFFECTS.register(bus);
        EffectInit.POTIONS.register(bus);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, GDConfigHolder.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, GDConfigHolder.SERVER_SPEC);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
    }

    private void registerCommon(FMLCommonSetupEvent event) {
        this.registerEntityAttributes();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.PLAINS || event.getCategory() == Biome.Category.SWAMP || event.getCategory() == Biome.Category.TAIGA || event.getCategory() == Biome.Category.FOREST) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)EntityInit.OGRE.get(), GoblinsDungeonsConfig.ogreSpawnWeight, 1, 1));
        }
    }

    public static ResourceLocation location(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            StructureInit.setupStructures();
            StructureInit.registerStructurePieces();
            ConfiguredStructureInit.registerConfiguredStructures();
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(structureMap);
                    tempMap.put(StructureInit.SMALL_GOBLIN_CAMP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.SMALL_GOBLIN_CAMP.get()));
                    tempMap.put(StructureInit.MEDIUM_GOBLIN_CAMP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.MEDIUM_GOBLIN_CAMP.get()));
                    tempMap.put(StructureInit.LARGE_GOBLIN_CAMP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.LARGE_GOBLIN_CAMP.get()));
                    tempMap.put(StructureInit.RUINED_KEEP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.RUINED_KEEP.get()));
                    ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
                } else {
                    structureMap.put(StructureInit.SMALL_GOBLIN_CAMP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.SMALL_GOBLIN_CAMP.get()));
                    structureMap.put(StructureInit.MEDIUM_GOBLIN_CAMP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.MEDIUM_GOBLIN_CAMP.get()));
                    structureMap.put(StructureInit.LARGE_GOBLIN_CAMP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.LARGE_GOBLIN_CAMP.get()));
                    structureMap.put(StructureInit.RUINED_KEEP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.RUINED_KEEP.get()));
                }
            });
        });
        EffectInit.brewingRecipes();
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityInit.OGRE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    private void registerEntityAttributes() {
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityInit.GOB.get()), (AttributeModifierMap)GobEntity.createAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityInit.HOBGOB.get()), (AttributeModifierMap)HobGobEntity.createAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityInit.GOBLO.get()), (AttributeModifierMap)GobloEntity.createAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityInit.GARCH.get()), (AttributeModifierMap)GarchEntity.createAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityInit.GOOM.get()), (AttributeModifierMap)GoomEntity.createAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityInit.GOBBER.get()), (AttributeModifierMap)GobberEntity.createAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityInit.OGRE.get()), (AttributeModifierMap)OgreEntity.createAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityInit.GOB_KING.get()), (AttributeModifierMap)GobKingEntity.createAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityInit.MIMIC.get()), (AttributeModifierMap)MimicEntity.createAttributes().func_233813_a_());
    }

    public void biomeModification(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.PLAINS || event.getCategory() == Biome.Category.FOREST || event.getCategory() == Biome.Category.TAIGA) {
            event.getGeneration().getStructures().add(() -> ConfiguredStructureInit.CONFIGURED_SMALL_GOBLIN_CAMP);
            event.getGeneration().getStructures().add(() -> ConfiguredStructureInit.CONFIGURED_MEDIUM_GOBLIN_CAMP);
            event.getGeneration().getStructures().add(() -> ConfiguredStructureInit.CONFIGURED_LARGE_GOBLIN_CAMP);
            event.getGeneration().getStructures().add(() -> ConfiguredStructureInit.CONFIGURED_RUINED_KEEP);
        }
        event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> GoblinsAndDungeonsFeatures.ORE_SCORIA);
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"getCodec", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(StructureInit.SMALL_GOBLIN_CAMP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.SMALL_GOBLIN_CAMP.get()));
            tempMap.putIfAbsent(StructureInit.MEDIUM_GOBLIN_CAMP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.MEDIUM_GOBLIN_CAMP.get()));
            tempMap.putIfAbsent(StructureInit.LARGE_GOBLIN_CAMP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.LARGE_GOBLIN_CAMP.get()));
            tempMap.putIfAbsent(StructureInit.RUINED_KEEP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.RUINED_KEEP.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    public static <MSG> void sendMSGToServer(MSG message) {
        NETWORK_WRAPPER.sendToServer(message);
    }

    public static <MSG> void sendMSGToAll(MSG message) {
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            GoblinsAndDungeons.sendNonLocal(message, player);
        }
    }

    public static <MSG> void sendNonLocal(MSG msg, ServerPlayerEntity player) {
        if (player.field_71133_b.func_71262_S() || !player.func_200200_C_().equals(player.field_71133_b.func_71214_G())) {
            NETWORK_WRAPPER.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    static {
        GROUP = new ItemGroup("goblinsanddungeons_item_group"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ItemInit.GOBLIN_CROWN.get());
            }
        };
    }
}

