/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class UrnBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty EXPLODING = BooleanProperty.func_177716_a((String)"exploding");
    public static final BooleanProperty HAS_WATER = BooleanProperty.func_177716_a((String)"water");
    public static final BooleanProperty HAS_LAVA = BooleanProperty.func_177716_a((String)"lava");
    public static final BooleanProperty HAS_POTION = BooleanProperty.func_177716_a((String)"potion");
    public static final IntegerProperty POTION_TYPE = IntegerProperty.func_177719_a((String)"type", (int)0, (int)199);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public UrnBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)EXPLODING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_WATER, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_LAVA, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_POTION, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)EXPLODING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_WATER, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_LAVA, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)HAS_POTION, (Comparable)Boolean.valueOf(false));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{EXPLODING, HAS_WATER, HAS_LAVA, WATERLOGGED, HAS_POTION, POTION_TYPE});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.hasTnT(state) || this.hasLava(state) || this.hasWater(state) || this.hasPotion(state)) {
            return ActionResultType.CONSUME;
        }
        ItemStack stack = player.func_184586_b(handIn);
        Item item = stack.func_77973_b();
        if (item == Blocks.field_150335_W.func_199767_j()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)EXPLODING, (Comparable)Boolean.valueOf(true)));
            this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)EXPLODING, (Comparable)Boolean.valueOf(true)));
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if (item == Items.field_151131_as) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HAS_WATER, (Comparable)Boolean.valueOf(true)));
            player.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                ItemStack bucket = new ItemStack((IItemProvider)Items.field_151133_ar);
                player.func_191521_c(bucket);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if (item == Items.field_151129_at) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HAS_LAVA, (Comparable)Boolean.valueOf(true)));
            player.func_184185_a(SoundEvents.field_187627_L, 1.0f, 1.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                ItemStack bucket = new ItemStack((IItemProvider)Items.field_151133_ar);
                player.func_191521_c(bucket);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if (item == Items.field_151068_bn) {
            worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)HAS_POTION, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)POTION_TYPE, (Comparable)Integer.valueOf(Effect.func_188409_a((Effect)((EffectInstance)PotionUtils.func_185189_a((ItemStack)stack).get(0)).func_188419_a()))));
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                ItemStack bucket = new ItemStack((IItemProvider)Items.field_151069_bo);
                player.func_191521_c(bucket);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return ActionResultType.CONSUME;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        player.func_71020_j(0.005f);
        if (this.hasTnT(state)) {
            UrnBlock.explode(worldIn, pos);
        }
        if (this.hasWater(state)) {
            worldIn.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
        }
        if (this.hasLava(state)) {
            worldIn.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
        }
        if (this.hasPotion(state)) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            areaeffectcloudentity.func_184483_a(2.5f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            areaeffectcloudentity.func_184496_a(new EffectInstance(Effect.func_188412_a((int)this.getPotionType(state)), 300));
            player.func_195064_c(new EffectInstance(Effect.func_188412_a((int)this.getPotionType(state))));
            worldIn.func_217376_c((Entity)areaeffectcloudentity);
        }
        UrnBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)te, (Entity)player, (ItemStack)stack);
    }

    public boolean hasTnT(BlockState state) {
        return (Boolean)state.func_177229_b((Property)EXPLODING);
    }

    public boolean hasWater(BlockState state) {
        return (Boolean)state.func_177229_b((Property)HAS_WATER);
    }

    public boolean hasLava(BlockState state) {
        return (Boolean)state.func_177229_b((Property)HAS_LAVA);
    }

    public boolean hasPotion(BlockState state) {
        return (Boolean)state.func_177229_b((Property)HAS_POTION);
    }

    public int getPotionType(BlockState state) {
        return (Integer)state.func_177229_b((Property)POTION_TYPE);
    }

    @Deprecated
    public static void explode(World world, BlockPos worldIn) {
        UrnBlock.explode(world, worldIn, null);
    }

    @Deprecated
    private static void explode(World worldIn, BlockPos pos, @Nullable LivingEntity entityIn) {
        if (!worldIn.field_72995_K) {
            TNTEntity tntentity = new TNTEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, entityIn);
            worldIn.func_217376_c((Entity)tntentity);
            worldIn.func_184148_a((PlayerEntity)null, tntentity.func_226277_ct_(), tntentity.func_226278_cu_(), tntentity.func_226281_cx_(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
}

