/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.goblinsanddungeons.entity.GobberEntity;

@OnlyIn(value=Dist.CLIENT)
public class GobberModel<T extends Entity>
extends EntityModel<GobberEntity>
implements IHasArm {
    public ModelRenderer Body;
    public ModelRenderer Head;
    public ModelRenderer RightPauldron;
    public ModelRenderer LeftPauldron;
    public ModelRenderer RightLeg;
    public ModelRenderer LeftLeg;
    public ModelRenderer LeftEar;
    public ModelRenderer RightEar;
    public ModelRenderer RightArm;
    public ModelRenderer LeftArm;

    public GobberModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.RightArm = new ModelRenderer((Model)this, 28, 13);
        this.RightArm.func_78793_a(-6.0f, 3.0f, 0.0f);
        this.RightArm.func_228302_a_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.RightPauldron = new ModelRenderer((Model)this, 36, 22);
        this.RightPauldron.func_78793_a(-5.0f, 2.0f, 0.0f);
        this.RightPauldron.func_228302_a_(-5.0f, -2.0f, -2.5f, 5.0f, 5.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.RightEar = new ModelRenderer((Model)this, 22, 3);
        this.RightEar.field_78809_i = true;
        this.RightEar.func_78793_a(-4.0f, -3.0f, 0.0f);
        this.RightEar.func_228302_a_(-4.0f, 0.0f, 0.0f, 4.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.LeftPauldron = new ModelRenderer((Model)this, 36, 22);
        this.LeftPauldron.field_78809_i = true;
        this.LeftPauldron.func_78793_a(5.0f, 2.0f, 0.0f);
        this.LeftPauldron.func_228302_a_(0.0f, -2.0f, -2.5f, 5.0f, 5.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.LeftEar = new ModelRenderer((Model)this, 22, 0);
        this.LeftEar.field_78809_i = true;
        this.LeftEar.func_78793_a(4.0f, -3.0f, 0.0f);
        this.LeftEar.func_228302_a_(0.0f, 0.0f, 0.0f, 4.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.Body = new ModelRenderer((Model)this, 0, 13);
        this.Body.func_78793_a(0.0f, 12.0f, 0.0f);
        this.Body.func_228302_a_(-5.0f, 0.0f, -4.0f, 10.0f, 9.0f, 8.0f, 0.0f, 0.0f, 0.0f);
        this.LeftArm = new ModelRenderer((Model)this, 28, 5);
        this.LeftArm.func_78793_a(6.0f, 3.0f, 0.0f);
        this.LeftArm.func_228302_a_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Head = new ModelRenderer((Model)this, 0, 0);
        this.Head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Head.func_228302_a_(-4.0f, -5.0f, -3.0f, 8.0f, 7.0f, 6.0f, 0.0f, 0.0f, 0.0f);
        this.RightLeg = new ModelRenderer((Model)this, 36, 9);
        this.RightLeg.field_78809_i = true;
        this.RightLeg.func_78793_a(-3.0f, 8.0f, 0.0f);
        this.RightLeg.func_228302_a_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.LeftLeg = new ModelRenderer((Model)this, 36, 9);
        this.LeftLeg.func_78793_a(3.0f, 8.0f, 0.0f);
        this.LeftLeg.func_228302_a_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Body.func_78792_a(this.RightPauldron);
        this.Body.func_78792_a(this.LeftArm);
        this.Head.func_78792_a(this.RightEar);
        this.Body.func_78792_a(this.LeftPauldron);
        this.Head.func_78792_a(this.LeftEar);
        this.Body.func_78792_a(this.Head);
        this.Body.func_78792_a(this.RightArm);
        this.Body.func_78792_a(this.RightLeg);
        this.Body.func_78792_a(this.LeftLeg);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.Body).forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setRotationAngles(GobberEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityIn.func_70608_bn()) {
            this.RightPauldron.field_78808_h = -0.225f * MathHelper.func_76126_a((float)(0.6f * ageInTicks / 10.0f));
            this.LeftPauldron.field_78808_h = -(-0.225f * MathHelper.func_76126_a((float)(0.6f * ageInTicks / 10.0f)));
            this.Head.field_78795_f = 0.25f;
            this.LeftArm.field_78795_f = 0.0f;
            this.RightArm.field_78795_f = 0.0f;
            this.RightLeg.field_78795_f = 0.0f;
            this.LeftLeg.field_78795_f = 0.0f;
        } else {
            this.RightPauldron.field_78808_h = 0.0f;
            this.LeftPauldron.field_78808_h = 0.0f;
            this.Head.field_78795_f = 0.0f;
            this.Head.field_78795_f = headPitch * ((float)Math.PI / 180);
            this.Head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LeftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void func_225599_a_(HandSide sideIn, MatrixStack matrixStackIn) {
        float f = sideIn == HandSide.RIGHT ? 1.0f : -1.0f;
        ModelRenderer modelrenderer = this.getArmForSide(sideIn);
        modelrenderer.field_78800_c += f;
        modelrenderer.func_228307_a_(matrixStackIn);
        modelrenderer.field_78800_c -= f;
        matrixStackIn.func_227861_a_(-0.0, 0.45, 0.0);
    }

    protected ModelRenderer getArmForSide(HandSide side) {
        return side == HandSide.LEFT ? this.LeftArm : this.RightArm;
    }
}

