/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.common;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.entity.ai.FollowOgreGoal;
import superlord.goblinsanddungeons.init.GDMapInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.StructureInit;

@Mod.EventBusSubscriber(modid="goblinsanddungeons", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    @SubscribeEvent
    public void onVillagerTrades(WandererTradesEvent event) {
        List list = event.getGenericTrades();
        list.add(new EmeraldForMapTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 12), new ItemStack((IItemProvider)Items.field_151111_aL, 1), 14, 10, 0.2f, (Structure)StructureInit.RUINED_KEEP.get(), GDMapInit.Type.RUINED_KEEP));
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof AbstractIllagerEntity || event.getEntity() instanceof GolemEntity) {
            ((MobEntity)event.getEntity()).field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)event.getEntity(), GoblinEntity.class, true));
        }
        if (event.getEntity() instanceof AbstractVillagerEntity) {
            ((MobEntity)event.getEntity()).field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)event.getEntity(), GoblinEntity.class, 10.0f, 1.0, 1.0));
        }
        if (event.getEntity() instanceof DonkeyEntity) {
            ((MobEntity)event.getEntity()).field_70714_bg.func_75776_a(4, (Goal)new FollowOgreGoal((AnimalEntity)event.getEntity(), 1.0));
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        if (source.func_76346_g() instanceof PlayerEntity) {
            MobEntity entity;
            PlayerEntity playerEntity = (PlayerEntity)source.func_76346_g();
            ItemStack stack = playerEntity.func_184582_a(EquipmentSlotType.OFFHAND);
            Item item = stack.func_77973_b();
            if (item == ItemInit.RING_OF_EXPERIENCE.get() && event.getEntity() instanceof LivingEntity) {
                entity = (MobEntity)event.getEntity();
                int xp = entity.field_70728_aV;
                entity.field_70728_aV = xp + 1;
            }
            if (item == ItemInit.RING_OF_GLORY.get() && !playerEntity.func_184812_l_() && event.getEntity() instanceof LivingEntity) {
                entity = (LivingEntity)event.getEntity();
                if ((double)entity.func_110138_aP() <= 15.0) {
                    playerEntity.func_70691_i(1.0f);
                } else if ((double)entity.func_110138_aP() > 15.0 && (double)entity.func_110138_aP() <= 30.0) {
                    playerEntity.func_70691_i(2.0f);
                } else if ((double)entity.func_110138_aP() > 30.0 && (double)entity.func_110138_aP() <= 45.0) {
                    playerEntity.func_70691_i(3.0f);
                } else if ((double)entity.func_110138_aP() > 45.0 && (double)entity.func_110138_aP() <= 60.0) {
                    playerEntity.func_70691_i(4.0f);
                } else if ((double)entity.func_110138_aP() > 75.0 && (double)entity.func_110138_aP() <= 90.0) {
                    playerEntity.func_70691_i(5.0f);
                } else if ((double)entity.func_110138_aP() > 90.0 && (double)entity.func_110138_aP() <= 105.0) {
                    playerEntity.func_70691_i(6.0f);
                } else if ((double)entity.func_110138_aP() > 105.0 && (double)entity.func_110138_aP() <= 120.0) {
                    playerEntity.func_70691_i(7.0f);
                } else if ((double)entity.func_110138_aP() > 120.0 && (double)entity.func_110138_aP() <= 135.0) {
                    playerEntity.func_70691_i(8.0f);
                } else if ((double)entity.func_110138_aP() > 135.0 && (double)entity.func_110138_aP() <= 150.0) {
                    playerEntity.func_70691_i(9.0f);
                } else if ((double)entity.func_110138_aP() > 150.0 && (double)entity.func_110138_aP() <= 165.0) {
                    playerEntity.func_70691_i(10.0f);
                } else if ((double)entity.func_110138_aP() > 165.0 && (double)entity.func_110138_aP() <= 180.0) {
                    playerEntity.func_70691_i(11.0f);
                } else if ((double)entity.func_110138_aP() > 180.0 && (double)entity.func_110138_aP() <= 195.0) {
                    playerEntity.func_70691_i(12.0f);
                } else if ((double)entity.func_110138_aP() > 195.0 && (double)entity.func_110138_aP() <= 210.0) {
                    playerEntity.func_70691_i(13.0f);
                } else if ((double)entity.func_110138_aP() > 210.0 && (double)entity.func_110138_aP() <= 225.0) {
                    playerEntity.func_70691_i(14.0f);
                } else if ((double)entity.func_110138_aP() > 225.0 && (double)entity.func_110138_aP() <= 240.0) {
                    playerEntity.func_70691_i(15.0f);
                } else if ((double)entity.func_110138_aP() > 240.0 && (double)entity.func_110138_aP() <= 255.0) {
                    playerEntity.func_70691_i(16.0f);
                } else if ((double)entity.func_110138_aP() > 255.0 && (double)entity.func_110138_aP() <= 270.0) {
                    playerEntity.func_70691_i(17.0f);
                } else if ((double)entity.func_110138_aP() > 270.0 && (double)entity.func_110138_aP() <= 285.0) {
                    playerEntity.func_70691_i(18.0f);
                } else if ((double)entity.func_110138_aP() > 285.0 && (double)entity.func_110138_aP() <= 300.0) {
                    playerEntity.func_70691_i(19.0f);
                } else if ((double)entity.func_110138_aP() > 300.0) {
                    playerEntity.func_70691_i(20.0f);
                }
                item.damageItem(stack, 1, (LivingEntity)playerEntity, player -> player.func_213361_c(EquipmentSlotType.OFFHAND));
            }
        }
    }

    static class EmeraldForMapTrade
    implements VillagerTrades.ITrade {
        private final ItemStack buying1;
        private final ItemStack buying2;
        private final int maxUses;
        private final int xp;
        private final float priceMultiplier;
        private final Structure<?> structureName;
        private final GDMapInit.Type type;

        public EmeraldForMapTrade(ItemStack buying1, ItemStack buying2, int maxUses, int xp, float priceMultiplier, Structure<?> structureName, GDMapInit.Type type) {
            this.buying1 = buying1;
            this.buying2 = buying2;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMultiplier = priceMultiplier;
            this.structureName = structureName;
            this.type = type;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            if (!(trader.field_70170_p instanceof ServerWorld)) {
                return null;
            }
            ServerWorld serverworld = (ServerWorld)trader.field_70170_p;
            BlockPos blockpos = serverworld.func_241117_a_(this.structureName, trader.func_233580_cy_(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = FilledMapItem.func_195952_a((World)serverworld, (int)blockpos.func_177958_n(), (int)blockpos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_226642_a_((ServerWorld)serverworld, (ItemStack)itemstack);
                GDMapInit.addTargetDecoration(itemstack, blockpos, "+", this.type);
                itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("filled_map." + this.structureName.func_143025_a().toLowerCase(Locale.ROOT)));
                return new MerchantOffer(this.buying1, this.buying2, itemstack, this.maxUses, this.xp, this.priceMultiplier);
            }
            return null;
        }
    }
}

