/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class GarchEntity
extends GoblinEntity
implements IRangedAttackMob {
    private final RangedBowAttackGoal<GarchEntity> aiArrowAttack = new RangedBowAttackGoal((MonsterEntity)this, 1.0, 20, 15.0f);
    private static final DataParameter<Boolean> HAS_RIDER = EntityDataManager.func_187226_a(GarchEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public boolean hasRider() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_RIDER);
    }

    private void setHasRider(boolean hasRider) {
        this.field_70180_af.func_187227_b(HAS_RIDER, (Object)hasRider);
    }

    public GarchEntity(EntityType<? extends GarchEntity> type, World worldIn) {
        super(type, worldIn);
        this.setCombatTask();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_213392_I() {
        return super.func_213392_I();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 5.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractRaiderEntity.class, 5.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractVillagerEntity.class, 5.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, IronGolemEntity.class, 5.0f, 2.2, 2.2));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractRaiderEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected SoundEvent func_184639_G() {
        return SoundInit.GARCH_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.GARCH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.GARCH_DEATH;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233819_b_, 35.0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_180481_a(difficultyIn);
        this.setCombatTask();
        return spawnDataIn;
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a(this.aiArrowAttack);
            ItemStack itemstack = this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f));
            if (itemstack.func_77973_b() instanceof BowItem) {
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != Difficulty.HARD) {
                    i = 40;
                }
                this.aiArrowAttack.func_189428_b(i);
                this.field_70714_bg.func_75776_a(4, this.aiArrowAttack);
            }
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        AbstractArrowEntity abstractarrowentity = this.fireArrow(itemstack, distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
        }
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226283_e_(0.3333333333333333) - abstractarrowentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    protected AbstractArrowEntity fireArrow(ItemStack arrowStack, float distanceFactor) {
        return ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
    }

    public boolean func_230280_a_(ShootableItem p_230280_1_) {
        return p_230280_1_ == Items.field_151031_f;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
        this.setHasRider(compound.func_74767_n("HasRider"));
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K) {
            this.setCombatTask();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_RIDER, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsSleeping", this.func_70608_bn());
        compound.func_74757_a("HasRider", this.hasRider());
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemInit.GARCH_SPAWN_EGG.get());
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttributeInit.GOBLIN) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }
}

