/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import superlord.goblinsanddungeons.entity.GarchEntity;
import superlord.goblinsanddungeons.entity.GobEntity;
import superlord.goblinsanddungeons.entity.GobberEntity;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.entity.GoblinSoulBulletEntity;
import superlord.goblinsanddungeons.entity.GobloEntity;
import superlord.goblinsanddungeons.entity.GoomEntity;
import superlord.goblinsanddungeons.entity.HobGobEntity;
import superlord.goblinsanddungeons.entity.event.GobKingTeleportEvent;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.EntityInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.ParticleInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class GobKingEntity
extends GoblinEntity
implements IRangedAttackMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS).func_186741_a(false);

    public GobKingEntity(EntityType<? extends GobKingEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    protected SoundEvent func_184639_G() {
        int laugh = this.field_70146_Z.nextInt(5);
        if (laugh == 0) {
            return SoundInit.GOBLIN_KING_LAUGH;
        }
        return SoundInit.GOBLIN_KING_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.GOBLIN_KING_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.GOBLIN_KING_DEATH;
    }

    public void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ItemInit.STAFF_AMETHYST.get()));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.25, 20, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractRaiderEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 5.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractRaiderEntity.class, 5.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractVillagerEntity.class, 5.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, IronGolemEntity.class, 5.0f, 2.2, 2.2));
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_213392_I() {
        return super.func_213392_I();
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int i = this.field_70146_Z.nextInt(999);
        if (this.func_70638_az() != null && i == 0) {
            int goblin = this.field_70146_Z.nextInt(5);
            if (goblin == 0) {
                GobEntity gob = new GobEntity((EntityType<? extends GobEntity>)((EntityType)EntityInit.GOB.get()), this.field_70170_p);
                gob.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                gob.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(gob.func_233580_cy_()), SpawnReason.REINFORCEMENT, null, null);
                this.field_70170_p.func_217376_c((Entity)gob);
            }
            if (goblin == 1) {
                GarchEntity garch = new GarchEntity((EntityType<? extends GarchEntity>)((EntityType)EntityInit.GARCH.get()), this.field_70170_p);
                garch.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                garch.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(garch.func_233580_cy_()), SpawnReason.REINFORCEMENT, null, null);
                this.field_70170_p.func_217376_c((Entity)garch);
            }
            if (goblin == 2) {
                GobloEntity goblo = new GobloEntity((EntityType<? extends GobloEntity>)((EntityType)EntityInit.GOBLO.get()), this.field_70170_p);
                goblo.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                goblo.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(goblo.func_233580_cy_()), SpawnReason.REINFORCEMENT, null, null);
                this.field_70170_p.func_217376_c((Entity)goblo);
            }
            if (goblin == 3) {
                GoomEntity goom = new GoomEntity((EntityType<? extends GoomEntity>)((EntityType)EntityInit.GOOM.get()), this.field_70170_p);
                goom.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                goom.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(goom.func_233580_cy_()), SpawnReason.REINFORCEMENT, null, null);
                this.field_70170_p.func_217376_c((Entity)goom);
            }
            if (goblin == 4) {
                HobGobEntity hobgob = new HobGobEntity((EntityType<? extends HobGobEntity>)((EntityType)EntityInit.HOBGOB.get()), this.field_70170_p);
                hobgob.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)hobgob);
            }
            if (goblin == 5) {
                GobberEntity gobber = new GobberEntity((EntityType<? extends GobberEntity>)((EntityType)EntityInit.GOBBER.get()), this.field_70170_p);
                GobberEntity gobber2 = new GobberEntity((EntityType<? extends GobberEntity>)((EntityType)EntityInit.GOBBER.get()), this.field_70170_p);
                GobberEntity gobber3 = new GobberEntity((EntityType<? extends GobberEntity>)((EntityType)EntityInit.GOBBER.get()), this.field_70170_p);
                GobberEntity gobber4 = new GobberEntity((EntityType<? extends GobberEntity>)((EntityType)EntityInit.GOBBER.get()), this.field_70170_p);
                gobber.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                gobber2.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                gobber3.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                gobber4.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                gobber.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(gobber.func_233580_cy_()), SpawnReason.REINFORCEMENT, null, null);
                gobber2.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(gobber2.func_233580_cy_()), SpawnReason.REINFORCEMENT, null, null);
                gobber3.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(gobber3.func_233580_cy_()), SpawnReason.REINFORCEMENT, null, null);
                gobber4.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(gobber4.func_233580_cy_()), SpawnReason.REINFORCEMENT, null, null);
                this.field_70170_p.func_217376_c((Entity)gobber);
                this.field_70170_p.func_217376_c((Entity)gobber2);
                this.field_70170_p.func_217376_c((Entity)gobber3);
                this.field_70170_p.func_217376_c((Entity)gobber4);
            }
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233819_b_, 35.0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_180481_a(difficultyIn);
        return spawnDataIn;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(this.func_233580_cy_()).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemInit.GOB_SPAWN_EGG.get());
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        GoblinSoulBulletEntity soulBullet = new GoblinSoulBulletEntity(this.field_70170_p, (LivingEntity)this);
        double d0 = target.func_226280_cw_() - (double)1.1f;
        double d1 = target.func_226277_ct_() - this.func_226277_ct_();
        double d2 = d0 - soulBullet.func_226278_cu_();
        double d3 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        soulBullet.func_70186_c(d1, d2 + (double)f, d3, 1.0f, 12.0f);
        this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), SoundInit.SOUL_BULLET_LAUNCH, SoundCategory.HOSTILE, 1.0f, 1.0f);
        this.func_184185_a(SoundInit.SOUL_BULLET_LAUNCH, 1.0f, 1.0f);
        this.field_70170_p.func_217376_c((Entity)soulBullet);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttributeInit.GOBLIN) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    protected boolean teleportRandomly() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
            return this.teleportTo(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTo(double x, double y, double z) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            GobKingTeleportEvent event = new GobKingTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundInit.SPELL_CASTING, this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a(SoundInit.SPELL_CASTING, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    public boolean func_213373_a(double x, double y, double z, boolean p_213373_7_) {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        double d3 = y;
        boolean flag = false;
        World world = this.field_70170_p;
        BlockPos blockpos = new BlockPos(x, y, z);
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                BlockState blockstate = world.func_180495_p(blockpos1);
                if (blockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(x, d3, z);
                if (world.func_226669_j_((Entity)this) && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d4 = (double)j / 127.0;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d5 = MathHelper.func_219803_d((double)d4, (double)this.field_70169_q, (double)this.func_226277_ct_()) + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
            double d6 = MathHelper.func_219803_d((double)d4, (double)this.field_70167_r, (double)this.func_226278_cu_()) + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg();
            double d7 = MathHelper.func_219803_d((double)d4, (double)this.field_70166_s, (double)this.func_226281_cx_()) + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.gobSoulBullet, d5, d6, d7, (double)f, (double)f1, (double)f2);
        }
        if (this instanceof CreatureEntity) {
            this.func_70661_as().func_75499_g();
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        if (source.func_76346_g() instanceof LivingEntity && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
            this.teleportRandomly();
        }
        return flag;
    }
}

