/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class GobberEntity
extends GoblinEntity
implements ICrossbowUser {
    private static final DataParameter<Boolean> HAS_CROSSBOW = EntityDataManager.func_187226_a(GobberEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(GobberEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_CHARGING_STATE = EntityDataManager.func_187226_a(GobberEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public GobberEntity(EntityType<? extends GobberEntity> type, World worldIn) {
        super(type, worldIn);
        this.setCombatTask();
    }

    public boolean hasCrossbow() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_CROSSBOW);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllagerEntity.ArmPose getArmPose() {
        if (this.isCharging()) {
            return AbstractIllagerEntity.ArmPose.CROSSBOW_CHARGE;
        }
        if (this.func_233631_a_(Items.field_222114_py)) {
            return AbstractIllagerEntity.ArmPose.CROSSBOW_HOLD;
        }
        return this.func_213398_dR() ? AbstractIllagerEntity.ArmPose.ATTACKING : AbstractIllagerEntity.ArmPose.NEUTRAL;
    }

    private void setHasCrossbow(boolean hasCrossbow) {
        this.field_70180_af.func_187227_b(HAS_CROSSBOW, (Object)hasCrossbow);
    }

    public boolean func_70608_bn() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    private void setSleeping(boolean isSleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)isSleeping);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new SleepGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractRaiderEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_CHARGING_STATE, (Object)false);
        this.field_70180_af.func_187214_a(HAS_CROSSBOW, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 25.0).func_233815_a_(Attributes.field_233821_d_, (double)0.15f).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233826_i_, 5.0).func_233815_a_(Attributes.field_233820_c_, 7.5).func_233815_a_(Attributes.field_233819_b_, 25.0);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_213392_I() {
        return super.func_213392_I();
    }

    protected void func_70619_bc() {
        if (this.func_70608_bn()) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.15f);
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_180481_a(difficultyIn);
        this.setCombatTask();
        return spawnDataIn;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        int i = this.field_70146_Z.nextInt(3);
        if (i == 0) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_222114_py));
            this.setHasCrossbow(true);
        } else {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(this.func_233580_cy_()).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (itemstack.func_77973_b() == Items.field_222114_py) {
                this.field_70714_bg.func_75776_a(0, (Goal)new RangedCrossbowAttackGoal((MonsterEntity)this, 1.0, 8.0f));
            }
            if (itemstack.func_77973_b() != Items.field_222114_py) {
                this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
            }
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.func_234281_b_((LivingEntity)this, 1.6f);
    }

    protected AbstractArrowEntity fireArrow(ItemStack arrowStack, float distanceFactor) {
        return ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
    }

    public boolean func_230280_a_(ShootableItem p_230280_1_) {
        return p_230280_1_ == Items.field_222114_py;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemInit.GOBBER_SPAWN_EGG.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_CHARGING_STATE);
    }

    public void func_213671_a(boolean isCharging) {
        this.field_70180_af.func_187227_b(DATA_CHARGING_STATE, (Object)isCharging);
    }

    public void func_230283_U__() {
        this.field_70708_bq = 0;
    }

    protected SoundEvent func_184639_G() {
        if (this.func_70608_bn()) {
            return SoundInit.GOBBER_SNORING;
        }
        return SoundInit.GOBBER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.GOBBER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.GOBBER_DEATH;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsSleeping", this.func_70608_bn());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
        this.setSleeping(compound.func_74767_n("IsSleeping"));
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K) {
            this.setCombatTask();
        }
    }

    public void func_230284_a_(LivingEntity p_230284_1_, ItemStack p_230284_2_, ProjectileEntity p_230284_3_, float p_230284_4_) {
        this.func_234279_a_((LivingEntity)this, p_230284_1_, p_230284_3_, p_230284_4_, 1.6f);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttributeInit.GOBLIN) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    class SleepGoal
    extends Goal {
        GobberEntity gobber;

        public SleepGoal(GobberEntity gobber) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.gobber = gobber;
        }

        public boolean func_75250_a() {
            List players = GobberEntity.this.field_70170_p.func_217357_a(PlayerEntity.class, GobberEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            List illagers = GobberEntity.this.field_70170_p.func_217357_a(AbstractIllagerEntity.class, GobberEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            List villagers = GobberEntity.this.field_70170_p.func_217357_a(AbstractVillagerEntity.class, GobberEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            List golems = GobberEntity.this.field_70170_p.func_217357_a(GolemEntity.class, GobberEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            return players.isEmpty() && illagers.isEmpty() && villagers.isEmpty() && golems.isEmpty();
        }

        public boolean func_75253_b() {
            List players = GobberEntity.this.field_70170_p.func_217357_a(PlayerEntity.class, GobberEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            List illagers = GobberEntity.this.field_70170_p.func_217357_a(AbstractIllagerEntity.class, GobberEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            List villagers = GobberEntity.this.field_70170_p.func_217357_a(AbstractVillagerEntity.class, GobberEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            List golems = GobberEntity.this.field_70170_p.func_217357_a(GolemEntity.class, GobberEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            return players.isEmpty() && illagers.isEmpty() && villagers.isEmpty() && golems.isEmpty();
        }

        public void func_75249_e() {
            this.gobber.func_70624_b(null);
            this.gobber.func_70604_c(null);
            this.gobber.setSleeping(true);
            this.gobber.func_70661_as().func_75499_g();
            this.gobber.func_213293_j(0.0, 0.0, 0.0);
            this.gobber.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.gobber.setSleeping(false);
            this.gobber.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.2f);
        }
    }
}

