/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class GobloEntity
extends GoblinEntity
implements IInventoryChangedListener {
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(GobloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_CHICKEN = EntityDataManager.func_187226_a(GobloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(GobloEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public int eatTicks;
    private Inventory inventory;
    private LazyOptional<?> itemHandler = null;

    public GobloEntity(EntityType<? extends GobloEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_98053_h(true);
        this.initInventory();
    }

    public boolean func_70608_bn() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    private void setSleeping(boolean isSleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)isSleeping);
    }

    public boolean hasChicken() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_CHICKEN);
    }

    private void setHasChicken(boolean hasChicken) {
        this.field_70180_af.func_187227_b(HAS_CHICKEN, (Object)hasChicken);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_213392_I() {
        return super.func_213392_I();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new SleepGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PickUpChickenGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FindItemsGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractRaiderEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected SoundEvent func_184639_G() {
        if (this.func_70608_bn()) {
            return SoundInit.GOBLO_SNORING;
        }
        return SoundInit.GOBLO_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.GOBLO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.GOBLO_DEATH;
    }

    protected void initInventory() {
        Inventory inventory = this.inventory;
        this.inventory = new Inventory(this.getInventorySize());
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.inventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.func_230275_fc_();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.inventory));
    }

    protected void func_230275_fc_() {
        if (!this.field_70170_p.field_72995_K) {
            this.setWatchableBoolean(4, !this.inventory.func_70301_a(0).func_190926_b());
        }
    }

    protected boolean getWatchableBoolean(int p_110233_1_) {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & p_110233_1_) != 0;
    }

    protected void setWatchableBoolean(int p_110208_1_, boolean p_110208_2_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        if (p_110208_2_) {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 | p_110208_1_)));
        } else {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 & ~p_110208_1_)));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 14.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233819_b_, 25.0);
    }

    private void spawnItem(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stackIn);
        this.field_70170_p.func_217376_c((Entity)itementity);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (this.func_175448_a(itemstack)) {
            int i = itemstack.func_190916_E();
            if (i > 1) {
                this.spawnItem(itemstack.func_77979_a(i - 1));
            }
            this.func_233630_a_(itemEntity);
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
            this.eatTicks = 0;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(this.func_233580_cy_()).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(HAS_CHICKEN, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsSleeping", this.func_70608_bn());
        compound.func_74757_a("HasChicken", this.hasChicken());
        ListNBT listnbt = new ListNBT();
        for (int i = 2; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        compound.func_218657_a("Items", (INBT)listnbt);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSleeping(compound.func_74767_n("IsSleeping"));
        this.setHasChicken(compound.func_74767_n("HasChicken"));
        ListNBT listnbt = compound.func_150295_c("Items", 10);
        this.initInventory();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            int j = compoundnbt.func_74771_c("Slot") & 0xFF;
            if (j < 2 || j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        }
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        this.inventory.func_233543_f_().forEach(arg_0 -> ((GobloEntity)this).func_199701_a_(arg_0));
    }

    protected ItemStack func_234436_k_(ItemStack p_234436_1_) {
        return this.inventory.func_174894_a(p_234436_1_);
    }

    protected boolean func_234437_l_(ItemStack p_234437_1_) {
        return this.inventory.func_233541_b_(p_234437_1_);
    }

    @Override
    protected void func_234416_a_(ServerWorld p_234416_1_) {
        GoblinEntity.func_234496_c_(this);
        this.inventory.func_233543_f_().forEach(arg_0 -> ((GobloEntity)this).func_199701_a_(arg_0));
        super.func_234416_a_(p_234416_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vector3d vector3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemstack), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 2.0, this.func_226278_cu_(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 2.0, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected int getInventorySize() {
        return 256;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
    }

    public SoundEvent func_213353_d(ItemStack itemStackIn) {
        return SoundInit.GOBLO_EATING;
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW()) {
            ++this.eatTicks;
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            ItemStack air = Items.field_190931_a.func_190903_i();
            if (this.canEatItem(itemstack)) {
                if (this.eatTicks > 100 && itemstack.func_77973_b().func_219971_r()) {
                    if (itemstack.func_77973_b() == Items.field_185164_cV) {
                        ItemStack itemstack1 = itemstack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                        if (!itemstack1.func_190926_b()) {
                            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack1);
                        }
                        this.setSleeping(true);
                    }
                    this.eatTicks = 0;
                    itemstack.func_190918_g(1);
                } else if (this.eatTicks > 100) {
                    ItemStack itemstack1 = itemstack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                    if (!itemstack1.func_190926_b()) {
                        this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack1);
                    }
                    this.inventory.func_174894_a(itemstack);
                    this.func_184201_a(EquipmentSlotType.MAINHAND, air);
                    this.eatTicks = 0;
                } else if (this.eatTicks > 60 && this.field_70146_Z.nextFloat() < 0.1f && this.func_190630_a(EquipmentSlotType.MAINHAND)) {
                    this.func_184185_a(this.func_213353_d(itemstack), 1.0f, 1.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                }
            }
        }
        if (!this.func_184207_aI()) {
            this.setHasChicken(false);
        }
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0 && this.hasChicken()) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
        if (this.func_70608_bn()) {
            this.func_213317_d(vector3d.func_216372_d(0.0, 0.0, 0.0));
        }
        super.func_70636_d();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (this.hasChicken()) {
            return false;
        }
        return super.func_225503_b_(distance, damageMultiplier);
    }

    private boolean canEatItem(ItemStack itemStackIn) {
        return itemStackIn.func_77973_b() != Items.field_151045_i && itemStackIn.func_77973_b() != Items.field_151056_x && itemStackIn.func_77973_b() != Items.field_221732_cb && itemStackIn.func_77973_b() != Items.field_151175_af && itemStackIn.func_77973_b() != Items.field_151163_ad && itemStackIn.func_77973_b() != Items.field_151161_ac && itemStackIn.func_77973_b() != Items.field_151125_bZ && itemStackIn.func_77973_b() != Items.field_151173_ae && itemStackIn.func_77973_b() != Items.field_221730_ca && itemStackIn.func_77973_b() != Items.field_151046_w && itemStackIn.func_77973_b() != Items.field_151047_v && itemStackIn.func_77973_b() != Items.field_151048_u && itemStackIn.func_77973_b() != Items.field_221690_bg && itemStackIn.func_77973_b() != Items.field_196183_dw && itemStackIn.func_77973_b() != Items.field_151156_bN && itemStackIn.func_77973_b() != Items.field_221749_dK && itemStackIn.func_77973_b() != Items.field_196151_dA && itemStackIn.func_77973_b() != Items.field_221832_dz && itemStackIn.func_77973_b() != Items.field_196185_dy && itemStackIn.func_77973_b() != Items.field_196184_dx && itemStackIn.func_77973_b() != Items.field_196186_dz && itemStackIn.func_77973_b() != Items.field_196182_dv && itemStackIn.func_77973_b() != Items.field_151166_bC && itemStackIn.func_77973_b() != Items.field_221739_dF && itemStackIn.func_77973_b() != Items.field_221733_dC && itemStackIn.func_77973_b() != Items.field_234795_rx_ && itemStackIn.func_77973_b() != Items.field_234757_kL_ && itemStackIn.func_77973_b() != Items.field_234766_lv_ && itemStackIn.func_77973_b() != Items.field_234794_rw_ && itemStackIn.func_77973_b() != Items.field_234764_lt_ && itemStackIn.func_77973_b() != Items.field_234763_ls_ && itemStackIn.func_77973_b() != Items.field_234758_kU_ && itemStackIn.func_77973_b() != Items.field_234759_km_ && itemStackIn.func_77973_b() != Items.field_234765_lu_ && itemStackIn.func_77973_b() != Items.field_234756_kK_ && itemStackIn.func_77973_b() != Items.field_234760_kn_ && itemStackIn.func_77973_b() != Items.field_234755_kJ_ && itemStackIn.func_77973_b() != Items.field_234754_kI_ && itemStackIn.func_77973_b() != Items.field_185158_cP && itemStackIn.func_77973_b() != Items.field_221826_dw && itemStackIn.func_77973_b() != Items.field_221897_gG && itemStackIn.func_77973_b() != Items.field_221889_gC && itemStackIn.func_77973_b() != Items.field_221891_gD && itemStackIn.func_77973_b() != Items.field_221885_gA && itemStackIn.func_77973_b() != Items.field_221986_gy && itemStackIn.func_77973_b() != Items.field_221893_gE && itemStackIn.func_77973_b() != Items.field_221978_gu && itemStackIn.func_77973_b() != Items.field_221988_gz && itemStackIn.func_77973_b() != Items.field_221982_gw && itemStackIn.func_77973_b() != Items.field_221976_gt && itemStackIn.func_77973_b() != Items.field_221974_gs && itemStackIn.func_77973_b() != Items.field_221984_gx && itemStackIn.func_77973_b() != Items.field_221887_gB && itemStackIn.func_77973_b() != Items.field_221895_gF && itemStackIn.func_77973_b() != Items.field_221970_gq && itemStackIn.func_77973_b() != Items.field_221972_gr && itemStackIn.func_77973_b() != Items.field_221980_gv && itemStackIn.func_77973_b() != Items.field_185160_cR && itemStackIn.func_77973_b() != Items.field_205158_fa && itemStackIn.func_77973_b() != Items.field_190929_cY && this.field_70122_E && !this.func_70608_bn();
    }

    public boolean func_175448_a(ItemStack stack) {
        Item item = stack.func_77973_b();
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        return itemstack.func_190926_b() && !this.hasChicken() && !this.func_70608_bn() || this.eatTicks > 0 && item.func_219971_r() && !itemstack.func_77973_b().func_219971_r();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemInit.GOBLO_SPAWN_EGG.get());
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttributeInit.GOBLIN) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void func_76316_a(IInventory invBasic) {
    }

    class SleepGoal
    extends Goal {
        GobloEntity goblo;
        int sleepTicks = 0;

        public SleepGoal(GobloEntity goblo) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.goblo = goblo;
        }

        public boolean func_75250_a() {
            return this.goblo.func_70608_bn();
        }

        public boolean func_75253_b() {
            return this.sleepTicks < 6000 && this.goblo.func_70643_av() == null;
        }

        public void func_75246_d() {
            ++this.sleepTicks;
        }

        public void func_75249_e() {
            this.goblo.func_70624_b(null);
            this.goblo.func_70604_c(null);
            GobloEntity.this.func_70661_as().func_75499_g();
            GobloEntity.this.func_213293_j(0.0, 0.0, 0.0);
            GobloEntity.this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.sleepTicks = 0;
            this.goblo.setSleeping(false);
            this.goblo.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.2f);
        }
    }

    class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!GobloEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() || GobloEntity.this.hasChicken()) {
                return false;
            }
            if (GobloEntity.this.func_70638_az() == null && GobloEntity.this.func_70643_av() == null) {
                if (GobloEntity.this.func_70681_au().nextInt(10) != 0) {
                    return false;
                }
                List list = GobloEntity.this.field_70170_p.func_217357_a(ItemEntity.class, GobloEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
                return !list.isEmpty() && GobloEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
            }
            return false;
        }

        public void func_75246_d() {
            List list = GobloEntity.this.field_70170_p.func_217357_a(ItemEntity.class, GobloEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            ItemStack itemstack = GobloEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (itemstack.func_190926_b() && !list.isEmpty()) {
                GobloEntity.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }

        public void func_75249_e() {
            List list = GobloEntity.this.field_70170_p.func_217357_a(ItemEntity.class, GobloEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            if (!list.isEmpty()) {
                GobloEntity.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    class PickUpChickenGoal
    extends Goal {
        GobloEntity goblo;
        ChickenEntity chicken;
        int ticks = 0;

        public PickUpChickenGoal(GobloEntity goblo) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.goblo = goblo;
        }

        public boolean func_75250_a() {
            return this.goblo.func_70643_av() == null && this.goblo.func_70638_az() == null && !this.goblo.hasChicken();
        }

        public void func_75246_d() {
            List list = this.goblo.field_70170_p.func_217357_a(ChickenEntity.class, this.goblo.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            if (!list.isEmpty() && !this.goblo.hasChicken()) {
                this.goblo.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }

        public void func_75249_e() {
            List list2;
            List list = this.goblo.field_70170_p.func_217357_a(ChickenEntity.class, this.goblo.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            if (!list.isEmpty() && !this.goblo.hasChicken()) {
                this.goblo.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
            if (!(list2 = this.goblo.field_70170_p.func_217357_a(ChickenEntity.class, this.goblo.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0))).isEmpty() && !this.goblo.hasChicken()) {
                this.chicken = (ChickenEntity)list2.get(0);
                this.chicken.func_184220_m((Entity)this.goblo);
                this.goblo.setHasChicken(true);
            }
            if (this.goblo.func_70643_av() != null) {
                this.chicken.func_233575_bb_();
                this.goblo.setHasChicken(false);
            }
        }

        public boolean func_75253_b() {
            return this.goblo.func_70643_av() == null;
        }
    }
}

