/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class MimicEntity
extends GoblinEntity {
    private static final DataParameter<Boolean> HIDING = EntityDataManager.func_187226_a(MimicEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private BlockPos currentAttachmentPosition = null;
    private int clientSideTeleportInterpolation;

    public MimicEntity(EntityType<? extends MimicEntity> p_i50196_1_, World p_i50196_2_) {
        super(p_i50196_1_, p_i50196_2_);
    }

    public boolean isHiding() {
        return (Boolean)this.field_70180_af.func_187225_a(HIDING);
    }

    private void setHiding(boolean isHiding) {
        this.field_70180_af.func_187227_b(HIDING, (Object)isHiding);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new HidingLookGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackNearestGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new HideGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new DefendGoal((CreatureEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HIDING, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHiding(compound.func_74767_n("IsHiding"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsHiding", this.isHiding());
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_213392_I() {
        return super.func_213392_I();
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        if (!this.field_70170_p.field_72995_K) {
            this.setHiding(false);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttributeInit.GOBLIN) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_180481_a(difficultyIn);
        this.setHiding(true);
        return spawnDataIn;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isHiding()) {
            this.func_213317_d(Vector3d.field_186680_a);
            if (!this.func_175446_cd()) {
                this.field_70760_ar = 0.0f;
                this.field_70761_aq = 0.0f;
            }
        }
    }

    protected SoundEvent func_184639_G() {
        if (!this.isHiding()) {
            return SoundInit.MIMIC_IDLE;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.MIMIC_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.MIMIC_DEATH;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            this.setHiding(false);
            return true;
        }
        return false;
    }

    public boolean func_241845_aY() {
        return this.func_70089_S();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getClientTeleportInterp() {
        return this.clientSideTeleportInterpolation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getOldAttachPos() {
        return this.currentAttachmentPosition;
    }

    public void func_70108_f(Entity entityIn) {
        if (!this.isHiding()) {
            super.func_70108_f(entityIn);
        }
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241842_k(float p_241842_1_) {
        return super.func_241842_k(p_241842_1_);
    }

    class HideGoal
    extends Goal {
        HideGoal() {
        }

        public boolean func_75250_a() {
            return MimicEntity.this.func_70638_az() == null && MimicEntity.this.func_70643_av() == null;
        }

        public void func_75249_e() {
            MimicEntity.this.setHiding(true);
        }
    }

    class HidingLookGoal
    extends LookAtGoal {
        public HidingLookGoal(MobEntity entityIn, Class<? extends LivingEntity> watchTargetClass, float maxDistance) {
            super(entityIn, watchTargetClass, maxDistance);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !MimicEntity.this.isHiding();
        }
    }

    class AttackNearestGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackNearestGoal(MimicEntity shulker) {
            super((MobEntity)shulker, PlayerEntity.class, true);
        }

        public boolean func_75250_a() {
            return !MimicEntity.this.isHiding() && super.func_75250_a();
        }

        public void func_75249_e() {
            super.func_75249_e();
            MimicEntity.this.setHiding(false);
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    class DefendGoal
    extends HurtByTargetGoal {
        public DefendGoal(CreatureEntity creatureIn) {
            super(creatureIn, new Class[0]);
        }

        public void startExecutign() {
            super.func_75249_e();
            MimicEntity.this.setHiding(false);
        }
    }
}

