/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.goblinsanddungeons.entity.GDFallingBlockEntity;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.EntityInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class OgreEntity
extends GoblinEntity {
    private static final RangedInteger field_234196_bu_ = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int field_234197_bv_;
    private UUID field_234198_bw_;
    private int attackTimer;
    private static final DataParameter<Boolean> ROARING = EntityDataManager.func_187226_a(OgreEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BUTT_SMASH = EntityDataManager.func_187226_a(OgreEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CAN_BUTT_SMASH = EntityDataManager.func_187226_a(OgreEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CAN_ROAR = EntityDataManager.func_187226_a(OgreEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int roarTicks = 1800;
    private int buttSmashTicks = 900;

    public OgreEntity(EntityType<? extends OgreEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractRaiderEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(1, (Goal)new RoarGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new ButtSmashGoal(this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233821_d_, (double)0.15f).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233819_b_, 25.0).func_233815_a_(Attributes.field_233820_c_, 25.0);
    }

    protected SoundEvent func_184639_G() {
        return SoundInit.OGRE_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.OGRE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.OGRE_DEATH;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isRoaring() {
        return (Boolean)this.field_70180_af.func_187225_a(ROARING);
    }

    private void setRoaring(boolean isRoaring) {
        this.field_70180_af.func_187227_b(ROARING, (Object)isRoaring);
    }

    public boolean isFallingOnButt() {
        return (Boolean)this.field_70180_af.func_187225_a(BUTT_SMASH);
    }

    private void setFallingOnButt(boolean buttSmash) {
        this.field_70180_af.func_187227_b(BUTT_SMASH, (Object)buttSmash);
    }

    public boolean canRoar() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_ROAR);
    }

    private void setCanRoar(boolean canRoar) {
        this.field_70180_af.func_187227_b(CAN_ROAR, (Object)canRoar);
    }

    public boolean canButtSmash() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_BUTT_SMASH);
    }

    private void setCanButtSmash(boolean canButtSmash) {
        this.field_70180_af.func_187227_b(CAN_BUTT_SMASH, (Object)canButtSmash);
    }

    public boolean func_213392_I() {
        return super.func_213392_I();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ROARING, (Object)false);
        this.field_70180_af.func_187214_a(BUTT_SMASH, (Object)false);
        this.field_70180_af.func_187214_a(CAN_ROAR, (Object)false);
        this.field_70180_af.func_187214_a(CAN_BUTT_SMASH, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsRoaring", this.isRoaring());
        compound.func_74757_a("ButtSmash", this.isFallingOnButt());
        compound.func_74757_a("CanRoar", this.canRoar());
        compound.func_74757_a("CanButtSmash", this.canButtSmash());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setRoaring(compound.func_74767_n("IsRoaring"));
        this.setFallingOnButt(compound.func_74767_n("ButtSmash"));
        this.setCanButtSmash(compound.func_74767_n("CanButtSmash"));
        this.setCanRoar(compound.func_74767_n("CanRoar"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            ++this.attackTimer;
        }
        if (this.attackTimer > 200 || this.func_70638_az() == null) {
            this.attackTimer = 0;
        }
        if (this.buttSmashTicks > 0) {
            --this.buttSmashTicks;
        }
        if (this.roarTicks > 0) {
            --this.roarTicks;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public void func_230258_H__() {
        this.setAngerTime(field_234196_bu_.func_233018_a_(this.field_70146_Z));
    }

    public void setAngerTime(int time) {
        this.field_234197_bv_ = time;
    }

    public int getAngerTime() {
        return this.field_234197_bv_;
    }

    public void setAngerTarget(@Nullable UUID target) {
        this.field_234198_bw_ = target;
    }

    public UUID getAngerTarget() {
        return this.field_234198_bw_;
    }

    private float func_226511_et_() {
        return (float)this.func_233637_b_(Attributes.field_233823_f_);
    }

    public boolean func_70652_k(Entity entityIn) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float f = this.func_226511_et_();
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.field_70146_Z.nextInt((int)f) : f;
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f1);
        if (flag) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, (double)0.4f, 0.0));
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        return flag;
    }

    public IronGolemEntity.Cracks func_226512_l_() {
        return IronGolemEntity.Cracks.func_226515_a_((float)(this.func_110143_aJ() / this.func_110138_aP()));
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.875f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.4f));
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttributeInit.GOBLIN) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.roarTicks == 0) {
            this.setCanRoar(true);
        }
        if (this.buttSmashTicks == 0) {
            this.setCanButtSmash(true);
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemInit.OGRE_SPAWN_EGG.get());
    }

    class ButtSmashGoal
    extends Goal {
        Boolean hasJumped = false;
        OgreEntity ogre;
        int timer;

        public ButtSmashGoal(OgreEntity ogre) {
            this.ogre = ogre;
        }

        public boolean func_75250_a() {
            return this.ogre.func_70638_az() != null && this.ogre.canButtSmash();
        }

        public boolean func_75253_b() {
            return this.ogre.func_70638_az() != null && this.ogre.canButtSmash();
        }

        public void func_75246_d() {
            ++this.timer;
            if (this.ogre.func_233570_aj_() && !this.hasJumped.booleanValue()) {
                this.ogre.func_213293_j(0.0, 0.5, 0.0);
                this.hasJumped = true;
            }
            double perpFacing = (double)this.ogre.field_70761_aq * (Math.PI / 180);
            double facingAngle = perpFacing + 1.5707963267948966;
            int hitY = MathHelper.func_76128_c((double)(this.ogre.func_174813_aQ().field_72338_b - 0.5));
            int tick = this.timer;
            int maxDistance = 6;
            ServerWorld world = (ServerWorld)this.ogre.field_70170_p;
            if (tick > 0) {
                int distance = tick / 2 - 2;
                double spread = Math.PI * 2;
                int arcLen = MathHelper.func_76143_f((double)((double)distance * spread));
                double minY = this.ogre.func_174813_aQ().field_72338_b;
                double maxY = this.ogre.func_174813_aQ().field_72337_e;
                for (int i = 0; i < arcLen; ++i) {
                    double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
                    double vx = Math.cos(theta);
                    double vz = Math.sin(theta);
                    double px = this.ogre.func_226277_ct_() + vx * (double)distance;
                    double pz = this.ogre.func_226281_cx_() + vz * (double)distance;
                    float factor = 1.0f - (float)distance / 6.0f;
                    AxisAlignedBB selection = new AxisAlignedBB(px - 1.5, minY, pz - 1.5, px + 1.5, maxY, pz + 1.5);
                    List hit = world.func_217357_a(Entity.class, selection);
                    for (Entity entity : hit) {
                        if (entity == this.ogre || entity instanceof GDFallingBlockEntity) continue;
                        float applyKnockbackResistance = 0.0f;
                        if (entity instanceof LivingEntity) {
                            entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.ogre), (float)((double)(factor * 5.0f + 1.0f) * this.ogre.func_233637_b_(Attributes.field_233823_f_)));
                            applyKnockbackResistance = (float)((LivingEntity)entity).func_110148_a(Attributes.field_233820_c_).func_111126_e();
                        }
                        double magnitude = world.field_73012_v.nextDouble() * 0.15 + 0.1;
                        float x = 0.0f;
                        float y = 0.0f;
                        float z = 0.0f;
                        x = (float)((double)x + vx * (double)factor * magnitude * (double)(1.0f - applyKnockbackResistance));
                        if (entity.func_233570_aj_()) {
                            y = (float)((double)y + (0.1 * (double)(1.0f - applyKnockbackResistance) + (double)factor * 0.15 * (double)(1.0f - applyKnockbackResistance)));
                        }
                        z = (float)((double)z + vz * (double)factor * magnitude * (double)(1.0f - applyKnockbackResistance));
                        entity.func_213317_d(entity.func_213322_ci().func_72441_c((double)x, (double)y, (double)z));
                        if (entity instanceof ServerPlayerEntity) {
                            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
                        }
                        if (!world.field_73012_v.nextBoolean()) continue;
                        int hitX = MathHelper.func_76128_c((double)px);
                        int hitZ = MathHelper.func_76128_c((double)pz);
                        BlockPos pos = new BlockPos(hitX, hitY, hitZ);
                        BlockPos abovePos = new BlockPos((Vector3i)pos).func_177984_a();
                        BlockState block = world.func_180495_p(pos);
                        BlockState blockAbove = world.func_180495_p(abovePos);
                        if (block.func_185904_a() == Material.field_151579_a || !block.func_215686_e((IBlockReader)world, pos) || block.func_177230_c().hasTileEntity(block) || blockAbove.func_185904_a().func_76230_c()) continue;
                        GDFallingBlockEntity fallingBlock = new GDFallingBlockEntity((EntityType)EntityInit.FALLING_BLOCK.get(), (World)world, block, (float)(0.4 + (double)factor * 0.2));
                        fallingBlock.func_70107_b((double)hitX + 0.5, hitY + 1, (double)hitZ + 0.5);
                        world.func_217376_c((Entity)fallingBlock);
                    }
                }
            }
            if (this.ogre.field_70160_al) {
                this.ogre.setFallingOnButt(true);
            } else {
                this.ogre.setFallingOnButt(false);
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.ogre.buttSmashTicks = 900;
            this.ogre.setCanButtSmash(false);
        }
    }

    class RoarGoal
    extends Goal {
        int timer = 0;

        RoarGoal() {
        }

        public boolean func_75250_a() {
            return OgreEntity.this.func_70638_az() != null && OgreEntity.this.canRoar();
        }

        public void func_75246_d() {
            ++this.timer;
            if (this.timer == 50) {
                this.func_75251_c();
            }
        }

        public void func_75249_e() {
            OgreEntity.this.setRoaring(true);
            LivingEntity entity = OgreEntity.this.func_70638_az();
            OgreEntity.this.field_70170_p.func_184133_a((PlayerEntity)null, OgreEntity.this.func_233580_cy_(), SoundInit.OGRE_ROAR, SoundCategory.HOSTILE, 2.0f, 1.0f);
            OgreEntity.this.func_184185_a(SoundInit.OGRE_ROAR, 1.0f, 1.0f);
            entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 300, 1));
        }

        public boolean func_75253_b() {
            return OgreEntity.this.func_70638_az() != null && OgreEntity.this.canRoar();
        }

        public void func_75251_c() {
            super.func_75251_c();
            OgreEntity.this.setRoaring(false);
            OgreEntity.this.roarTicks = 1800;
            this.timer = 0;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(CreatureEntity creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public boolean func_75250_a() {
            return OgreEntity.this.func_70638_az() != null;
        }

        public boolean func_75253_b() {
            return OgreEntity.this.func_70638_az() != null && !OgreEntity.this.canButtSmash() && !OgreEntity.this.canRoar();
        }
    }
}

