/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.init;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GDMapInit
extends MapDecoration {
    public GDMapInit(MapDecoration.Type type, byte x, byte y, byte rotation, ITextComponent customName) {
        super(type, x, y, rotation, customName);
    }

    public static void addTargetDecoration(ItemStack map, BlockPos target, String decorationName, Type type) {
        ListNBT listnbt;
        if (map.func_77942_o() && map.func_77978_p().func_150297_b("Decorations", 9)) {
            listnbt = map.func_77978_p().func_150295_c("Decorations", 10);
        } else {
            listnbt = new ListNBT();
            map.func_77983_a("Decorations", (INBT)listnbt);
        }
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74774_a("type", type.getIcon());
        compoundnbt.func_74778_a("id", decorationName);
        compoundnbt.func_74780_a("x", (double)target.func_177958_n());
        compoundnbt.func_74780_a("z", (double)target.func_177952_p());
        compoundnbt.func_74780_a("rot", 180.0);
        listnbt.add((Object)compoundnbt);
        if (type.hasMapColor()) {
            CompoundNBT compoundnbt1 = map.func_190925_c("display");
            compoundnbt1.func_74768_a("MapColor", type.getMapColor());
        }
    }

    public static enum Type {
        RUINED_KEEP(true);

        private final byte icon = (byte)this.ordinal();
        private final boolean renderedOnFrame;
        private final int mapColor;

        private Type(boolean renderedOnFrame) {
            this(renderedOnFrame, -1);
        }

        private Type(boolean renderedOnFrame, int mapColor) {
            this.renderedOnFrame = renderedOnFrame;
            this.mapColor = mapColor;
        }

        public byte getIcon() {
            return this.icon;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean isRenderedOnFrame() {
            return this.renderedOnFrame;
        }

        public boolean hasMapColor() {
            return this.mapColor >= 0;
        }

        public int getMapColor() {
            return this.mapColor;
        }

        public static Type byIcon(byte iconByte) {
            return Type.values()[MathHelper.func_76125_a((int)iconByte, (int)0, (int)(Type.values().length - 1))];
        }
    }
}

