/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.init;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import superlord.goblinsanddungeons.particle.GoblinSoulBulletParticle;

@Mod.EventBusSubscriber(modid="goblinsanddungeons", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ParticleInit {
    public static final List<ParticleType<?>> PARTICLE_TYPES = Lists.newArrayList();
    public static final BasicParticleType gobSoulBullet = ParticleInit.registerBasicParticle("goblin_soul_bullet");

    private static BasicParticleType registerBasicParticle(String name) {
        return ParticleInit.registerParticle(name, new BasicParticleType(false));
    }

    public static <T extends ParticleType<?>> T registerParticle(String name, T particle) {
        particle.setRegistryName(new ResourceLocation("goblinsanddungeons", name));
        PARTICLE_TYPES.add(particle);
        return particle;
    }

    @SubscribeEvent
    public static void registerParticles(RegistryEvent.Register<ParticleType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        for (ParticleType<?> particle : PARTICLE_TYPES) {
            registry.register(particle);
        }
    }

    @SubscribeEvent
    public static void registerFactories(ParticleFactoryRegisterEvent e) {
        ParticleManager particles = Minecraft.func_71410_x().field_71452_i;
        particles.func_215234_a((ParticleType)gobSoulBullet, GoblinSoulBulletParticle.Factory::new);
    }
}

