/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import superlord.goblinsanddungeons.config.GoblinsDungeonsConfig;
import superlord.goblinsanddungeons.world.structures.LargeGoblinCampStructure;
import superlord.goblinsanddungeons.world.structures.MediumGoblinCampStructure;
import superlord.goblinsanddungeons.world.structures.RuinedKeepStructure;
import superlord.goblinsanddungeons.world.structures.SmallGoblinCampStructure;

@Mod.EventBusSubscriber(modid="goblinsanddungeons", bus=Mod.EventBusSubscriber.Bus.MOD)
public class StructureInit {
    public static IStructurePieceType SMALL_GOBLIN_CAMP_PIECE_TYPE = SmallGoblinCampStructure.Piece::new;
    public static IStructurePieceType MEDIUM_GOBLIN_CAMP_PIECE_TYPE = MediumGoblinCampStructure.Piece::new;
    public static IStructurePieceType LARGE_GOBLIN_CAMP_PIECE_TYPE = LargeGoblinCampStructure.Piece::new;
    public static IStructurePieceType RUINED_KEEP_PIECE_TYPE = RuinedKeepStructure.Piece::new;
    public static final DeferredRegister<Structure<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"goblinsanddungeons");
    public static final RegistryObject<Structure<NoFeatureConfig>> SMALL_GOBLIN_CAMP = REGISTER.register("small_goblin_camp", () -> new SmallGoblinCampStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> MEDIUM_GOBLIN_CAMP = REGISTER.register("medium_goblin_camp", () -> new MediumGoblinCampStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> LARGE_GOBLIN_CAMP = REGISTER.register("large_goblin_camp", () -> new LargeGoblinCampStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> RUINED_KEEP = REGISTER.register("ruined_keep", () -> new RuinedKeepStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void setupStructures() {
        StructureInit.setupMapSpacingAndLand((Structure)SMALL_GOBLIN_CAMP.get(), new StructureSeparationSettings(GoblinsDungeonsConfig.smallGoblinCampMaxDistance, GoblinsDungeonsConfig.smallGoblinCampMinDistance, 2538959), true);
        StructureInit.setupMapSpacingAndLand((Structure)MEDIUM_GOBLIN_CAMP.get(), new StructureSeparationSettings(GoblinsDungeonsConfig.mediumGoblinCampMaxDistance, GoblinsDungeonsConfig.mediumGoblinCampMinDistance, 2895726), true);
        StructureInit.setupMapSpacingAndLand((Structure)LARGE_GOBLIN_CAMP.get(), new StructureSeparationSettings(GoblinsDungeonsConfig.largeGoblinCampMaxDistance, GoblinsDungeonsConfig.largeGoblinCampMinDistance, 2716364), true);
        StructureInit.setupMapSpacingAndLand((Structure)RUINED_KEEP.get(), new StructureSeparationSettings(GoblinsDungeonsConfig.ruinedKeepMaxDistance, GoblinsDungeonsConfig.ruinedKeepMinDistance, 2827153), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
    }

    public static void registerStructurePieces() {
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("goblinsanddungeons", "small_goblin_camp"), (Object)SMALL_GOBLIN_CAMP_PIECE_TYPE);
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("goblinsanddungeons", "medium_goblin_camp"), (Object)MEDIUM_GOBLIN_CAMP_PIECE_TYPE);
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("goblinsanddungeons", "large_goblin_camp"), (Object)LARGE_GOBLIN_CAMP_PIECE_TYPE);
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("goblinsanddungeons", "ruined_keep"), (Object)RUINED_KEEP_PIECE_TYPE);
    }
}

