/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.goblinsanddungeons.entity.GarchEntity;

@OnlyIn(value=Dist.CLIENT)
public class GarchModel<T extends Mob>
extends EntityModel<GarchEntity>
implements ArmedModel {
    private final ModelPart RightArm;
    private final ModelPart Leftleg;
    private final ModelPart LeftArm;
    private final ModelPart Rightleg;
    private final ModelPart Headlayer;
    private final ModelPart Body;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;

    public GarchModel(ModelPart root) {
        this.RightArm = root.m_171324_("RightArm");
        this.Leftleg = root.m_171324_("Leftleg");
        this.LeftArm = root.m_171324_("LeftArm");
        this.Rightleg = root.m_171324_("Rightleg");
        this.Headlayer = root.m_171324_("Headlayer");
        this.Body = root.m_171324_("Body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(12, 14).m_171480_().m_171488_(0.0f, -1.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)13.0f, (float)0.0f, (float)-1.5708f, (float)0.1f, (float)0.0f));
        PartDefinition Leftleg = partdefinition.m_171599_("Leftleg", CubeListBuilder.m_171558_().m_171514_(8, 23).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)18.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(12, 14).m_171488_(-2.0f, -1.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)13.0f, (float)0.0f, (float)-1.5708f, (float)-0.5f, (float)0.0f));
        PartDefinition Rightleg = partdefinition.m_171599_("Rightleg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)18.0f, (float)0.0f));
        PartDefinition Headlayer = partdefinition.m_171599_("Headlayer", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-3.0f, -8.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition Hat = Headlayer.m_171599_("Hat", CubeListBuilder.m_171558_().m_171514_(24, 21).m_171488_(-5.0f, 0.0f, -5.0f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition Head = Headlayer.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -8.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Rightear = Head.m_171599_("Rightear", CubeListBuilder.m_171558_().m_171514_(18, 2).m_171488_(0.0f, 0.0f, 0.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-5.0f, (float)1.0f));
        PartDefinition Leftear = Head.m_171599_("Leftear", CubeListBuilder.m_171558_().m_171514_(18, 2).m_171480_().m_171488_(-4.0f, 0.0f, 0.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)-5.0f, (float)1.0f));
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-2.0f, 0.0f, -1.0f, 4.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(GarchEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Headlayer.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.Headlayer.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.Rightleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.Leftleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.RightArm.f_104204_ = 0.6f;
        this.LeftArm.f_104204_ = -0.1f;
        this.RightArm.f_104203_ = -1.5707964f + this.Headlayer.f_104203_;
        this.LeftArm.f_104203_ = -1.5707964f + this.Headlayer.f_104203_;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.RightArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.Leftleg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.LeftArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.Rightleg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.Headlayer.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.Body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public void m_6002_(HumanoidArm sideIn, PoseStack matrixStackIn) {
        float f = sideIn == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelrenderer = this.getArmForSide(sideIn);
        modelrenderer.f_104200_ += f;
        modelrenderer.m_104299_(matrixStackIn);
        modelrenderer.f_104200_ -= f;
        matrixStackIn.m_85837_(-0.15, -0.225, 0.0);
        matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
    }

    protected ModelPart getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.RightArm : this.LeftArm;
    }
}

