/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.goblinsanddungeons.entity.GobEntity;

@OnlyIn(value=Dist.CLIENT)
public class GobModel
extends EntityModel<GobEntity>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("modid", "custom_model"), "main");
    private final ModelPart Body;
    private final ModelPart RightLeg;
    private final ModelPart Head;
    private final ModelPart RightArm;
    private final ModelPart LeftLeg;
    private final ModelPart LeftArm;

    public GobModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.RightLeg = root.m_171324_("RightLeg");
        this.RightArm = root.m_171324_("RightArm");
        this.LeftLeg = root.m_171324_("LeftLeg");
        this.LeftArm = root.m_171324_("LeftArm");
        this.Head = this.Body.m_171324_("Head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-2.0f, 0.0f, -1.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition GobHat = Head.m_171599_("GobHat", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)1.0f));
        PartDefinition RightEar = Head.m_171599_("RightEar", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-3.0f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-4.0f, (float)0.0f));
        PartDefinition LeftEar = Head.m_171599_("LeftEar", CubeListBuilder.m_171558_().m_171514_(22, 3).m_171488_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-4.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(8, 19).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)20.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(20, 12).m_171488_(0.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)16.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)20.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(12, 12).m_171488_(-2.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)16.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(GobEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.RightLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.RightArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.LeftLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.LeftArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public void m_6002_(HumanoidArm sideIn, PoseStack matrixStackIn) {
        float f = sideIn == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelrenderer = this.getArmForSide(sideIn);
        modelrenderer.f_104200_ += f;
        modelrenderer.m_104299_(matrixStackIn);
        modelrenderer.f_104200_ -= f;
        matrixStackIn.m_85837_(-0.075, -0.225, 0.0);
        matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
    }

    protected ModelPart getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.RightArm : this.LeftArm;
    }
}

