/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GoblinKingModel<T extends LivingEntity>
extends EntityModel<T>
implements ArmedModel {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;

    public GoblinKingModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.LeftArm = this.Body.m_171324_("LeftArm");
        this.RightLeg = this.Body.m_171324_("RightLeg");
        this.LeftLeg = this.Body.m_171324_("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -6.0f, -5.0f, 10.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftEar = Head.m_171599_("LeftEar", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171488_(-4.0f, 0.0f, 0.0f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-4.0f, (float)0.0f));
        PartDefinition RightEar = Head.m_171599_("RightEar", CubeListBuilder.m_171558_().m_171514_(30, 3).m_171488_(0.0f, 0.0f, 0.0f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-4.0f, (float)0.0f));
        PartDefinition Crown = Head.m_171599_("Crown", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(28, 16).m_171480_().m_171488_(0.0f, -1.0f, -2.0f, 2.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(40, 11).m_171480_().m_171488_(-2.0f, -1.0f, -2.0f, 2.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightLeg = Body.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(52, 11).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)9.0f, (float)0.0f));
        PartDefinition LeftLeg = Body.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(52, 11).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)9.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)48);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public void m_6002_(HumanoidArm sideIn, PoseStack matrixStackIn) {
        float f = sideIn == HumanoidArm.RIGHT ? 0.0f : -1.0f;
        float f1 = sideIn == HumanoidArm.RIGHT ? 7.0f : -1.0f;
        float f2 = sideIn == HumanoidArm.RIGHT ? 2.0f : -1.0f;
        ModelPart modelrenderer = this.getArmForSide(sideIn);
        modelrenderer.f_104200_ += f;
        modelrenderer.f_104201_ += f1;
        modelrenderer.f_104202_ += f2;
        modelrenderer.m_104299_(matrixStackIn);
        modelrenderer.f_104200_ -= f;
        modelrenderer.f_104201_ -= f1;
        modelrenderer.f_104202_ -= f2;
    }

    protected ModelPart getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.RIGHT ? this.LeftArm : this.RightArm;
    }
}

