/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class GDFallingBlockEntity
extends Entity {
    public static float GRAVITY = 0.1f;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    private static final EntityDataAccessor<Optional<BlockState>> BLOCK_STATE = SynchedEntityData.m_135353_(GDFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(GDFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICKS_EXISTED = SynchedEntityData.m_135353_(GDFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> MODE = SynchedEntityData.m_135353_(GDFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> ANIM = SynchedEntityData.m_135353_(GDFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float animY = 0.0f;
    public float prevAnimY = 0.0f;

    public GDFallingBlockEntity(EntityType<?> entityType, Level world) {
        super(entityType, world);
        this.setBlock(Blocks.f_50493_.m_49966_());
        this.setDuration(70);
    }

    public GDFallingBlockEntity(EntityType<?> type, Level world, int duration, BlockState state) {
        super(type, world);
        this.setBlock(state);
        this.setDuration(duration);
    }

    public GDFallingBlockEntity(EntityType<?> type, Level world, BlockState state, float vy) {
        super(type, world);
        this.setBlock(state);
        this.setMode(EnumFallingState.POP_UP);
        this.setAnimVY(vy);
    }

    public void onAddedToWorld() {
        if (this.m_20184_().m_7096_() > 0.0 || this.m_20184_().m_7094_() > 0.0) {
            this.animY = (float)(57.29577951308232 * Math.atan2(this.m_20184_().m_7096_(), this.m_20184_().m_7094_()));
        }
        this.f_19859_ += this.f_19796_.nextFloat() * 360.0f;
        super.onAddedToWorld();
    }

    public void m_8119_() {
        if (this.getMode() == EnumFallingState.POP_UP) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        this.prevMotionX = this.m_20184_().f_82479_;
        this.prevMotionY = this.m_20184_().f_82480_;
        this.prevMotionZ = this.m_20184_().f_82481_;
        super.m_8119_();
        if (this.getMode() == EnumFallingState.MOBILE) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, (double)GRAVITY, 0.0));
            if (this.f_19861_) {
                this.m_20256_(this.m_20184_().m_82490_(0.7));
            } else {
                this.f_19859_ += 15.0f;
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.f_19797_ > this.getDuration()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else {
            float animVY = this.getAnimVY();
            this.prevAnimY = this.animY;
            this.animY += animVY;
            this.setAnimVY(animVY - GRAVITY);
            if ((double)this.animY < -0.5) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BLOCK_STATE, Optional.of(Blocks.f_50493_.m_49966_()));
        this.f_19804_.m_135372_(DURATION, (Object)70);
        this.f_19804_.m_135372_(TICKS_EXISTED, (Object)0);
        this.f_19804_.m_135372_(MODE, (Object)EnumFallingState.MOBILE.toString());
        this.f_19804_.m_135372_(ANIM, (Object)Float.valueOf(1.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        Tag blockStateCompound = compound.m_128423_("block");
        if (blockStateCompound != null) {
            BlockState blockState = NbtUtils.m_129241_((CompoundTag)((CompoundTag)blockStateCompound));
            this.setBlock(blockState);
        }
        this.setDuration(compound.m_128451_("duration"));
        this.f_19797_ = compound.m_128451_("ticksExisted");
        this.f_19804_.m_135381_(MODE, (Object)compound.m_128461_("mode"));
        this.setAnimVY(compound.m_128457_("vy"));
    }

    protected void m_7380_(CompoundTag compound) {
        BlockState blockState = this.getBlock();
        if (blockState != null) {
            compound.m_128365_("block", (Tag)NbtUtils.m_129202_((BlockState)blockState));
        }
        compound.m_128405_("duration", this.getDuration());
        compound.m_128405_("ticksExisted", this.f_19797_);
        compound.m_128359_("mode", (String)this.f_19804_.m_135370_(MODE));
        compound.m_128350_("vy", ((Float)this.f_19804_.m_135370_(ANIM)).floatValue());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public BlockState getBlock() {
        Optional bsOp = (Optional)this.f_19804_.m_135370_(BLOCK_STATE);
        return bsOp.orElse(null);
    }

    public void setBlock(BlockState state) {
        this.f_19804_.m_135381_(BLOCK_STATE, Optional.of(state));
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(DURATION);
    }

    public void setDuration(int duration) {
        this.f_19804_.m_135381_(DURATION, (Object)duration);
    }

    public int getTicksExisted() {
        return (Integer)this.f_19804_.m_135370_(TICKS_EXISTED);
    }

    public void setTicksExisted(int ticksExisted) {
        this.f_19804_.m_135381_(TICKS_EXISTED, (Object)ticksExisted);
    }

    public EnumFallingState getMode() {
        String mode = (String)this.f_19804_.m_135370_(MODE);
        if (mode.isEmpty()) {
            return EnumFallingState.MOBILE;
        }
        return EnumFallingState.valueOf((String)this.f_19804_.m_135370_(MODE));
    }

    private void setMode(EnumFallingState mode) {
        this.f_19804_.m_135381_(MODE, (Object)mode.toString());
    }

    public float getAnimVY() {
        return ((Float)this.f_19804_.m_135370_(ANIM)).floatValue();
    }

    private void setAnimVY(float vy) {
        this.f_19804_.m_135381_(ANIM, (Object)Float.valueOf(vy));
    }

    public static enum EnumFallingState {
        MOBILE,
        POP_UP;

    }
}

