/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import java.util.function.Supplier;
import net.mehvahdjukaar.heartstone.Heartstone;
import net.mehvahdjukaar.heartstone.HeartstoneParticle;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    public static SimpleChannel INSTANCE;
    private static final String PROTOCOL_VERSION = "1";

    public static void registerMessages(FMLCommonSetupEvent event) {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)Heartstone.res("network"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        INSTANCE.registerMessage(0, ClientBoundSpawnHeartstoneParticlePacket.class, ClientBoundSpawnHeartstoneParticlePacket::buffer, ClientBoundSpawnHeartstoneParticlePacket::new, ClientBoundSpawnHeartstoneParticlePacket::handler);
    }

    public static void sendHeartstoneParticles(PlayerEntity player, PlayerEntity other) {
        Vector3d pos = player.func_174824_e(1.0f);
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new ClientBoundSpawnHeartstoneParticlePacket(pos, other.func_174824_e(1.0f).func_178788_d(pos)));
    }

    public static class ClientBoundSpawnHeartstoneParticlePacket
    implements Message {
        public final Vector3d pos;
        public final Vector3d dist;

        public ClientBoundSpawnHeartstoneParticlePacket(PacketBuffer buf) {
            this.pos = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
            this.dist = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public ClientBoundSpawnHeartstoneParticlePacket(Vector3d pos, Vector3d dist) {
            this.pos = pos;
            this.dist = dist;
        }

        public static void buffer(ClientBoundSpawnHeartstoneParticlePacket message, PacketBuffer buf) {
            buf.writeDouble(message.pos.field_72450_a);
            buf.writeDouble(message.pos.field_72448_b);
            buf.writeDouble(message.pos.field_72449_c);
            buf.writeDouble(message.dist.field_72450_a);
            buf.writeDouble(message.dist.field_72448_b);
            buf.writeDouble(message.dist.field_72449_c);
        }

        public static void handler(ClientBoundSpawnHeartstoneParticlePacket message, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            context.enqueueWork(() -> {
                if (context.getDirection().getReceptionSide().isClient()) {
                    HeartstoneParticle.spawnParticle(message);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static interface Message {
    }
}

