/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import java.util.function.Supplier;
import net.mehvahdjukaar.heartstone.Heartstone;
import net.mehvahdjukaar.heartstone.HeartstoneParticle;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    public static SimpleChannel INSTANCE;
    private static final String PROTOCOL_VERSION = "1";

    public static void registerMessages(FMLCommonSetupEvent event) {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)Heartstone.res("network"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        INSTANCE.registerMessage(0, ClientBoundSpawnHeartstoneParticlePacket.class, ClientBoundSpawnHeartstoneParticlePacket::buffer, ClientBoundSpawnHeartstoneParticlePacket::new, ClientBoundSpawnHeartstoneParticlePacket::handler);
    }

    public static void sendHeartstoneParticles(ServerLevel serverLevel, Player player, Vec3 otherPos) {
        Vec3 pos = player.m_146892_();
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new ClientBoundSpawnHeartstoneParticlePacket(pos, otherPos.m_82546_(pos)));
    }

    public static class ClientBoundSpawnHeartstoneParticlePacket
    implements Message {
        public final Vec3 pos;
        public final Vec3 dist;

        public ClientBoundSpawnHeartstoneParticlePacket(FriendlyByteBuf buf) {
            this.pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            this.dist = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public ClientBoundSpawnHeartstoneParticlePacket(Vec3 pos, Vec3 dist) {
            this.pos = pos;
            this.dist = dist;
        }

        public static void buffer(ClientBoundSpawnHeartstoneParticlePacket message, FriendlyByteBuf buf) {
            buf.writeDouble(message.pos.f_82479_);
            buf.writeDouble(message.pos.f_82480_);
            buf.writeDouble(message.pos.f_82481_);
            buf.writeDouble(message.dist.f_82479_);
            buf.writeDouble(message.dist.f_82480_);
            buf.writeDouble(message.dist.f_82481_);
        }

        public static void handler(ClientBoundSpawnHeartstoneParticlePacket message, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            context.enqueueWork(() -> {
                if (context.getDirection().getReceptionSide().isClient()) {
                    HeartstoneParticle.spawnParticle(message);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static interface Message {
    }
}

