/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import java.util.List;
import net.mehvahdjukaar.heartstone.HeartstoneData;
import net.mehvahdjukaar.heartstone.NetworkHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class HeartstoneItem
extends Item {
    public HeartstoneItem() {
        super(new Item.Properties().m_41497_(Rarity.RARE).m_41487_(2));
    }

    public boolean m_5812_(ItemStack pStack) {
        return HeartstoneItem.getHeartstoneId(pStack) != null;
    }

    @Nullable
    public static Long getHeartstoneId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("Id")) {
            return tag.m_128454_("Id");
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pHand) {
        ItemStack itemstack = player.m_21120_(pHand);
        if (pLevel.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        Long id = HeartstoneItem.getHeartstoneId(itemstack);
        boolean success = false;
        if (id != null && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            PlayerList players = serverLevel.m_7654_().m_6846_();
            for (Player targetPlayer : players.m_11314_()) {
                if (!this.arePlayersBound(player, id, targetPlayer)) continue;
                NetworkHandler.sendHeartstoneParticles(player, targetPlayer);
                success = true;
                break;
            }
        }
        if (!success) {
            pLevel.m_6269_(null, (Entity)player, SoundEvents.f_144244_, player.m_5720_(), 0.6f, 0.7f);
        }
        player.m_36335_().m_41524_((Item)this, 60);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public static boolean arePlayersBound(Player pPlayer, ItemStack stack, Player target) {
        Item item = stack.m_41720_();
        if (item instanceof HeartstoneItem) {
            HeartstoneItem hs = (HeartstoneItem)item;
            Long id = HeartstoneItem.getHeartstoneId(stack);
            if (id != null) {
                return hs.arePlayersBound(pPlayer, id, target);
            }
        }
        return false;
    }

    private boolean arePlayersBound(Player pPlayer, Long id, Player target) {
        if (target.m_9236_().m_46472_() == pPlayer.m_9236_().m_46472_() && target != pPlayer) {
            Inventory inv = target.m_150109_();
            for (int i = 0; i < inv.m_6643_(); ++i) {
                CompoundTag t;
                ItemStack s = inv.m_8020_(i);
                if (s.m_41720_() != this || (t = s.m_41783_()) == null || t.m_128454_("Id") != id.longValue()) continue;
                return true;
            }
        }
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        Long id = HeartstoneItem.getHeartstoneId(pStack);
        if (id != null) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"message.heartstone.id", (Object[])new Object[]{id}));
        }
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        super.m_7836_(pStack, pLevel, pPlayer);
        CompoundTag tag = pStack.m_41784_();
        if (!tag.m_128441_("Id") && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            tag.m_128356_("Id", HeartstoneData.getNewId(serverLevel));
        }
    }
}

