/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.block;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.block.BlockRadiation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BlockRadiationManager
extends SimpleJsonResourceReloadListener {
    public static final Map<ResourceLocation, BlockRadiation> RADIATION_BLOCKS = new HashMap<ResourceLocation, BlockRadiation>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockRadiation.class, (Object)new BlockRadiation.Serializer()).create();
    private static BlockRadiationManager INSTANCE;

    public BlockRadiationManager() {
        super(GSON, "environment/block_radiation");
    }

    public static JsonElement parseBlockRadiation(BlockRadiation blockRadiation) {
        return GSON.toJsonTree((Object)blockRadiation);
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        RADIATION_BLOCKS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            try {
                BlockRadiation blockRadiation = (BlockRadiation)GSON.fromJson(entry.getValue(), BlockRadiation.class);
                RADIATION_BLOCKS.put(blockRadiation.getLocation(), blockRadiation);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse block radiation %s %s", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded %d radiation blocks", (Object)RADIATION_BLOCKS.size());
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        INSTANCE = new BlockRadiationManager();
        event.addListener((PreparableReloadListener)INSTANCE);
    }
}

