/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import homeostatic.Homeostatic;
import homeostatic.common.block.HomeostaticBlocks;
import homeostatic.common.item.HomeostaticItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class HomeostaticFluids {
    public static IForgeRegistry<Fluid> FLUID_REGISTRY;
    public static FlowingFluid PURIFIED_WATER;
    public static FlowingFluid PURIFIED_WATER_FLOWING;
    public static final ResourceLocation STILL_FLUID_TEXTURE;
    public static final ResourceLocation FLOWING_FLUID_TEXTURE;

    public static void init(IForgeRegistry<Fluid> registry) {
        FLUID_REGISTRY = registry;
        ForgeFlowingFluid.Properties PURIFIED_WATER_PROPS = new ForgeFlowingFluid.Properties(() -> PURIFIED_WATER, () -> PURIFIED_WATER_FLOWING, FluidAttributes.builder((ResourceLocation)STILL_FLUID_TEXTURE, (ResourceLocation)FLOWING_FLUID_TEXTURE).color(-868565505).viscosity(1000)).bucket(() -> HomeostaticItems.PURIFIED_WATER_BUCKET).block(() -> HomeostaticBlocks.PURIFIED_WATER_FLUID).slopeFindDistance(3).explosionResistance(100.0f);
        PURIFIED_WATER = HomeostaticFluids.registerFluid("purified_water", (FlowingFluid)new ForgeFlowingFluid.Source(PURIFIED_WATER_PROPS));
        PURIFIED_WATER_FLOWING = HomeostaticFluids.registerFluid("purified_water_flowing", (FlowingFluid)new ForgeFlowingFluid.Flowing(PURIFIED_WATER_PROPS));
    }

    public static FlowingFluid registerFluid(String name, FlowingFluid fluid) {
        Fluid fluidConfigured = (Fluid)fluid.setRegistryName(Homeostatic.loc(name));
        FLUID_REGISTRY.register((IForgeRegistryEntry)fluidConfigured);
        return fluid;
    }

    static {
        STILL_FLUID_TEXTURE = Homeostatic.loc("block/fluid/still_water");
        FLOWING_FLUID_TEXTURE = Homeostatic.loc("block/fluid/flowing_water");
    }
}

