/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.item.FluidHandlerItem;
import homeostatic.util.WaterHelper;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.ItemFluidContainer;

public class WaterContainerItem
extends ItemFluidContainer {
    public WaterContainerItem(Item.Properties properties, int capacity) {
        super(properties.m_41503_(capacity), capacity);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hitResult = WaterContainerItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos pos = hitResult.m_82425_();
        BlockState blockState = level.m_8055_(pos);
        Fluid targetFluid = blockState.m_60819_().m_76152_();
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityRegistry.FLUID_ITEM_CAPABILITY).orElse(null);
        FluidStack fluidStack = fluidHandlerItem.getFluidInTank(0);
        boolean isEmpty = fluidStack.isEmpty();
        if ((isEmpty || fluidStack.getFluid().m_6212_(targetFluid)) && fluidStack.getAmount() != this.capacity) {
            BucketPickup bucketPickup;
            Block block;
            if (targetFluid == Fluids.f_76193_) {
                return InteractionResultHolder.m_19090_((Object)this.getFilledItem(stack, player, targetFluid, this.capacity));
            }
            if (WaterHelper.getFluidHydration(targetFluid) != null && (block = blockState.m_60734_()) instanceof BucketPickup && !(bucketPickup = (BucketPickup)block).m_142598_((LevelAccessor)level, pos, blockState).m_41619_()) {
                return InteractionResultHolder.m_19090_((Object)this.getFilledItem(stack, player, targetFluid, 1000));
            }
        }
        if (!isEmpty && this.canDrink(player, fluidStack)) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    @Nonnull
    public ItemStack m_5922_(ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entity) {
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityRegistry.FLUID_ITEM_CAPABILITY).orElse(null);
        fluidHandlerItem.drain(250, IFluidHandler.FluidAction.EXECUTE);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (fluidHandlerItem.getFluidInTank(0).isEmpty()) {
                return this.getContainerItem(stack);
            }
            WaterHelper.updateDamage(stack);
        }
        return stack;
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag tag) {
        return new FluidHandlerItem(stack, this.capacity);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> components, @Nonnull TooltipFlag tooltipFlag) {
        TextComponent textComponent = new TextComponent(new TranslatableComponent("tooltip.water_container.empty").getString());
        int amount = 0;
        super.m_7373_(stack, level, components, tooltipFlag);
        if (stack.m_41737_("Fluid") != null) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
            textComponent = new TextComponent(fluidHandlerItem.getFluidInTank(0).getDisplayName().getString());
            amount = fluidHandlerItem.getFluidInTank(0).getAmount();
        }
        components.add((Component)textComponent.m_130946_(String.format(": %d uses.", amount / 250)).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 32;
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public ItemStack getFilledItem(ItemStack stack, Player player, Fluid fluid, int amount) {
        ItemStack copy = WaterHelper.getFilledItem(stack, fluid, amount);
        player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return copy;
    }

    public boolean canDrink(Player player, FluidStack fluidStack) {
        AtomicBoolean canDrink = new AtomicBoolean(WaterHelper.getFluidHydration(fluidStack.getFluid()) != null && fluidStack.getAmount() >= 250);
        player.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> canDrink.set(canDrink.get() && data.getWaterLevel() < 20));
        return canDrink.get();
    }
}

