/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.temperature;

import homeostatic.Homeostatic;
import homeostatic.common.capabilities.Temperature;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.util.InsulationHelper;
import homeostatic.util.TempHelper;
import homeostatic.util.WaterHelper;
import homeostatic.util.WetnessHelper;
import net.minecraft.server.level.ServerPlayer;

public class BodyTemperature {
    public static final float LOW = 1.5542169f;
    public static final float WARNING_LOW = 1.5898795f;
    public static final float NORMAL = 1.6344578f;
    public static final float HIGH = 1.7993976f;
    public static final float WARNING_HIGH = 1.7659639f;
    public static final float SCALDING_WARNING = 2.2228916f;
    public static final float SCALDING = 2.5572288f;
    private final EnvironmentData environmentData;
    private final TempHelper.TemperatureDirection skinTemperatureDirection;
    private final int wetness;
    private float coreTemperature;
    private float skinTemperature;
    private float lastSkinTemperature;

    public BodyTemperature(ServerPlayer sp, EnvironmentData environmentData, Temperature tempData) {
        this(sp, environmentData, tempData, false, false);
    }

    public BodyTemperature(ServerPlayer sp, EnvironmentData environmentData, Temperature tempData, boolean updateCore, boolean updateSkin) {
        this.environmentData = environmentData;
        this.wetness = WetnessHelper.getWetness(sp);
        this.setCoreTemperature(tempData.getCoreTemperature());
        this.skinTemperatureDirection = TempHelper.getSkinTemperatureDirection(environmentData.getLocalTemperature(), tempData.getSkinTemperature());
        this.setSkinTemperature(sp, tempData.getSkinTemperature(), updateSkin);
        if (updateCore) {
            this.updateCoreTemperature();
        }
    }

    public float getCoreTemperature() {
        return this.coreTemperature;
    }

    public float getSkinTemperature() {
        return this.skinTemperature;
    }

    public float getLastSkinTemperature() {
        return this.lastSkinTemperature;
    }

    public void updateCoreTemperature() {
        TempHelper.TemperatureDirection coreTemperatureDirection = TempHelper.getCoreTemperatureDirection(this.lastSkinTemperature, this.coreTemperature, this.skinTemperature);
        float diff = Math.abs(this.skinTemperature - this.coreTemperature);
        float change = coreTemperatureDirection.coreRate > 0.0f ? diff * coreTemperatureDirection.coreRate : diff * 0.1f;
        if (this.skinTemperature < this.coreTemperature) {
            this.coreTemperature -= change;
            if (coreTemperatureDirection == TempHelper.TemperatureDirection.COOLING_RAPIDLY) {
                this.coreTemperature = Math.max(this.coreTemperature, 1.6344578f);
            }
        } else {
            this.coreTemperature += change;
            if (coreTemperatureDirection == TempHelper.TemperatureDirection.WARMING_RAPIDLY) {
                this.coreTemperature = Math.min(this.coreTemperature, 1.6344578f);
            }
        }
    }

    private void setCoreTemperature(float coreTemperature) {
        this.coreTemperature = coreTemperature;
    }

    private void setSkinTemperature(ServerPlayer sp, float skinTemperature, boolean updateSkin) {
        float localTemperature = this.environmentData.getLocalTemperature();
        boolean canSweat = skinTemperature >= 1.6344578f && this.wetness == 0;
        boolean inWater = this.environmentData.isSubmerged() || this.environmentData.isPartialSubmersion();
        this.lastSkinTemperature = skinTemperature;
        this.skinTemperature = skinTemperature;
        if (!updateSkin) {
            return;
        }
        double insulationModifier = InsulationHelper.getInsulationModifier(sp, this.wetness, this.skinTemperatureDirection, localTemperature);
        float tempChange = inWater ? this.getWaterTemperatureSkinChange(insulationModifier) : this.getAirTemperatureSkinChange(sp, insulationModifier);
        if (tempChange > 0.0f) {
            switch (this.skinTemperatureDirection) {
                case COOLING: {
                    tempChange = Math.max(-tempChange * 70.0f, -0.06686747f);
                    if (this.wetness <= 0) break;
                    tempChange *= (float)(1.0 + (double)this.wetness / 20.0);
                    break;
                }
                case COOLING_RAPIDLY: {
                    tempChange = Math.max(-tempChange * 100.0f, -0.08915663f);
                    if (this.wetness <= 0) break;
                    tempChange *= (float)(2.0 + (double)this.wetness / 20.0);
                    break;
                }
                case COOLING_NORMALLY: {
                    tempChange = -tempChange;
                    if (canSweat) break;
                    float exhaustion = Math.abs(Math.min(tempChange * 200.0f, 0.2f));
                    sp.m_36324_().m_38703_(exhaustion);
                    break;
                }
                case WARMING: {
                    if (canSweat) {
                        WaterHelper.updateWaterInfo(sp, Math.min(tempChange * 150.0f, 0.3f));
                        break;
                    }
                    tempChange = Math.min(tempChange * 70.0f, 0.06686747f);
                    break;
                }
                case WARMING_RAPIDLY: {
                    tempChange = Math.min(tempChange * 100.0f, 0.08915663f);
                    break;
                }
                case WARMING_NORMALLY: {
                    if (!canSweat) break;
                    WaterHelper.updateWaterInfo(sp, Math.min(tempChange * 100.0f, 0.1f));
                }
            }
        }
        if (localTemperature < 1.22f && !canSweat && Homeostatic.RANDOM.nextFloat() < 0.17f) {
            WaterHelper.updateWaterInfo(sp, 0.05f);
        }
        if (sp.f_146808_ && this.skinTemperature >= 1.6344578f) {
            tempChange = -((this.skinTemperature - 1.6344578f) / 10.0f);
        }
        if (tempChange == 0.0f) {
            if (this.skinTemperature < 1.6344578f) {
                tempChange = (1.6344578f - this.skinTemperature) / 20.0f;
            } else if (this.skinTemperature > 1.6344578f) {
                tempChange = -((this.skinTemperature - 1.6344578f) / 40.0f);
            }
        }
        this.skinTemperature += tempChange;
        if (this.skinTemperature > 1.6344578f && this.skinTemperature > this.lastSkinTemperature && localTemperature < this.skinTemperature) {
            float coolingRate = Math.max((this.skinTemperature - 1.6344578f) / 20.0f, 0.022289157f);
            if (canSweat) {
                WaterHelper.updateWaterInfo(sp, Math.min(tempChange * 150.0f, 0.2f));
                this.skinTemperature = Math.max(this.skinTemperature - coolingRate, 1.6344578f);
            } else {
                this.skinTemperature = Math.max(this.skinTemperature - coolingRate * 2.0f, 1.6344578f);
            }
        }
    }

    public float getWaterTemperatureSkinChange(double insulationModifier) {
        float change = 0.0f;
        float localTemperature = this.environmentData.getLocalTemperature();
        double localTempF = TempHelper.convertMcTemp(localTemperature, true);
        double parityTempF = TempHelper.convertMcTemp(1.108f, true);
        if (this.skinTemperatureDirection == TempHelper.TemperatureDirection.NONE) {
            return change;
        }
        if (localTemperature < 1.108f) {
            double temp = Math.min(localTempF + insulationModifier, parityTempF);
            double minutes = 8.845477E-7 * Math.pow(temp, 4.75641);
            change = 0.080240965f / (float)minutes;
        } else {
            double temp = Math.max(localTempF - insulationModifier, parityTempF);
            double minutes = 2.981948 + 601.889152 / (1.0 + Math.pow(temp / 109.9434, 50.72627));
            change = 0.16493976f / (float)minutes;
        }
        if (change != 0.0f && this.environmentData.isPartialSubmersion()) {
            change /= 2.0f;
        }
        return change;
    }

    public float getAirTemperatureSkinChange(ServerPlayer sp, double insulationModifier) {
        float localTemperature = this.environmentData.getLocalTemperature();
        float change = 0.0f;
        double localTempF = TempHelper.convertMcTemp(localTemperature, true);
        double parityTempF = TempHelper.convertMcTemp(1.108f, true);
        double extremeTempF = TempHelper.convertMcTemp(2.557f, true);
        float radiationModifier = (float)(this.environmentData.getEnvRadiation() / 5000.0) + 1.0f;
        float moisture = 0.0f;
        if (!sp.m_20071_()) {
            moisture = 0.2f * (3.0f + radiationModifier);
        }
        if (moisture > 0.0f) {
            WetnessHelper.updateWetnessInfo(sp, moisture, false);
        }
        if (this.skinTemperatureDirection == TempHelper.TemperatureDirection.NONE) {
            return change;
        }
        if (localTemperature < 1.108f) {
            double temp = Math.min(localTempF + insulationModifier, parityTempF);
            if (Math.abs(parityTempF - temp) > 5.0) {
                double minutes = 383.4897 + -371.10186000000004 / (1.0 + Math.pow(temp / 43.26779, 8.271186));
                change = 0.080240965f / (float)minutes;
            }
        } else {
            double temp = Math.max(localTempF - insulationModifier, parityTempF);
            if (Math.abs(parityTempF - temp) > 5.0) {
                if (temp > extremeTempF) {
                    change = (float)((temp - extremeTempF) / 50.0) * 0.0067f;
                } else {
                    double minutes = 24.45765 + 574.8975499999999 / (1.0 + Math.pow(temp / 109.1499, 27.47623));
                    change = 0.16493976f / (float)minutes;
                }
            }
        }
        if (this.coreTemperature < 1.6344578f && this.environmentData.getEnvRadiation() > 0.0 || radiationModifier > 5.0f) {
            change *= radiationModifier;
        }
        return change;
    }
}

