/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.temperature;

import com.mojang.math.Vector3d;
import homeostatic.common.block.BlockRadiation;
import homeostatic.common.block.BlockRadiationManager;
import homeostatic.common.temperature.EnvironmentInfo;
import homeostatic.util.VecMath;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;

public class Environment {
    public static final float PARITY = 1.108f;
    public static final float PARITY_LOW = 0.997f;
    public static final float PARITY_HIGH = 1.22f;
    public static final float HOT = 1.888f;
    public static final float EXTREME_HEAT = 2.557f;
    public static final float EXTREME_COLD = -0.34036145f;

    public static EnvironmentInfo get(ServerLevel world, ServerPlayer sp) {
        double radiation = 0.0;
        double waterVolume = 0.0;
        double waterBlocks = 0.0;
        double totalBlocks = 0.0;
        AtomicReference<Double> radiationReduction = new AtomicReference<Double>(1.0);
        HashMap<ChunkPos, LevelChunk> chunkMap = new HashMap<ChunkPos, LevelChunk>();
        BlockPos pos = sp.m_142538_();
        BlockPos eyePos = sp.m_146901_();
        ResourceKey worldKey = world.m_46472_();
        MobEffectInstance effectInstance = sp.m_21124_(MobEffects.f_19607_);
        boolean inOverworld = worldKey.m_135782_().toString().contains(DimensionType.f_63840_.toString());
        boolean isSubmerged = sp.m_5842_() && sp.m_20069_() && sp.m_20071_();
        boolean isSheltered = true;
        boolean isUnderground = true;
        if (!inOverworld) {
            isUnderground = false;
            isSheltered = false;
        }
        if (isSubmerged) {
            isSheltered = false;
        }
        sp.m_6168_().forEach(armorItem -> {
            CompoundTag tags = armorItem.m_41783_();
            if (tags != null && tags.m_128441_("radiation_protection")) {
                radiationReduction.updateAndGet(v -> v - 0.2);
            }
        });
        for (int x = -12; x <= 12; ++x) {
            for (int z = -12; z <= 12; ++z) {
                if (isSheltered && x <= 2 && x >= -2 && z <= 2 && z >= -2) {
                    isSheltered = !world.m_45527_(eyePos.m_142082_(x, 0, z).m_7494_());
                }
                for (int y = -3; y <= 11; ++y) {
                    BlockRadiation blockRadiation;
                    PalettedContainer palette;
                    ChunkPos chunkPos = new ChunkPos(pos.m_123341_() + x >> 4, pos.m_123343_() + z >> 4);
                    LevelChunk chunk = Environment.getChunk((Level)world, chunkPos, chunkMap);
                    if (chunk == null) continue;
                    BlockPos blockpos = pos.m_142082_(x, y, z);
                    try {
                        palette = chunk.m_183278_((blockpos.m_123342_() >> 4) - chunk.m_151560_()).m_63019_();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    BlockState state = (BlockState)palette.m_63087_(blockpos.m_123341_() & 0xF, blockpos.m_123342_() & 0xF, blockpos.m_123343_() & 0xF);
                    boolean isWater = state.m_60767_().equals(Material.f_76305_);
                    if (isUnderground && y >= 0 && !isWater) {
                        boolean bl = isUnderground = !world.m_45527_(eyePos.m_142082_(x, y, z).m_7494_());
                    }
                    if (x <= 5 && x >= -5 && y <= 5 && z <= 5 && z >= -5) {
                        totalBlocks += 1.0;
                        if (isWater) {
                            waterBlocks += 1.0;
                        }
                    }
                    if (state.m_60795_() || y > 3 || effectInstance != null || (blockRadiation = BlockRadiationManager.RADIATION_BLOCKS.get(state.m_60734_().getRegistryName())) == null) continue;
                    boolean hasRadiation = true;
                    if (state.m_61138_((Property)BlockStateProperties.f_61443_)) {
                        hasRadiation = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_);
                    }
                    if (!hasRadiation) continue;
                    Vec3 vPos = new Vec3((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5);
                    double distance = VecMath.getDistance(sp, new Vector3d(vPos.f_82479_, vPos.f_82480_, vPos.f_82481_));
                    boolean obscured = VecMath.isBlockObscured(sp, vPos);
                    if (!state.m_60819_().m_76178_()) {
                        double amount = state.m_60819_().m_76186_() / 8;
                        radiation += blockRadiation.getBlockRadiation(distance, obscured, amount, y);
                        continue;
                    }
                    radiation += blockRadiation.getBlockRadiation(distance, obscured, y);
                }
            }
        }
        waterVolume = waterBlocks == 0.0 ? 0.0 : waterBlocks / totalBlocks;
        return new EnvironmentInfo(isUnderground, isSheltered, radiation *= radiationReduction.get().doubleValue(), waterVolume);
    }

    private static LevelChunk getChunk(Level world, ChunkPos pos, Map<ChunkPos, LevelChunk> chunks) {
        LevelChunk chunk;
        ChunkPos chunkPos = new ChunkPos(pos.f_45578_, pos.f_45579_);
        if (chunks.containsKey(chunkPos)) {
            chunk = chunks.get(chunkPos);
        } else {
            chunk = world.m_7726_().m_7131_(chunkPos.f_45578_, chunkPos.f_45579_);
            chunks.put(chunkPos, chunk);
        }
        return chunk;
    }
}

