/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.config;

import homeostatic.util.ColorHelper;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="homeostatic", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ConfigHandler {
    private ConfigHandler() {
    }

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Client.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Common.CONFIG_SPEC);
    }

    public static final class Client {
        public static final ForgeConfigSpec CONFIG_SPEC;
        private static final Client CONFIG;
        private static final List<String> positions;
        private static final List<String> temperatureHudOptions;
        private static Color temperatureColorCold;
        private static Color temperatureColorHot;
        private static final Predicate<Object> hexRangeValidator;
        public final ForgeConfigSpec.BooleanValue useFahrenheit;
        public final ForgeConfigSpec.BooleanValue showDegreeSymbol;
        public final ForgeConfigSpec.ConfigValue<String> debugPosition;
        public final ForgeConfigSpec.IntValue debugOffsetX;
        public final ForgeConfigSpec.IntValue debugOffsetY;
        public final ForgeConfigSpec.DoubleValue scale;
        public final ForgeConfigSpec.ConfigValue<String> temperatureColorRange;
        public final ForgeConfigSpec.ConfigValue<String> temperatureHudOption;
        public final ForgeConfigSpec.ConfigValue<String> thermometerPosition;
        public final ForgeConfigSpec.IntValue thermometerOffsetX;
        public final ForgeConfigSpec.IntValue thermometerOffsetY;
        public final ForgeConfigSpec.IntValue thermometerTextOffsetY;
        public final ForgeConfigSpec.BooleanValue showThermometerRateChangeSymbols;
        public final ForgeConfigSpec.ConfigValue<String> globePosition;
        public final ForgeConfigSpec.IntValue globeOffsetX;
        public final ForgeConfigSpec.IntValue globeOffsetY;
        public final ForgeConfigSpec.IntValue globeTextOffsetY;
        public final ForgeConfigSpec.BooleanValue forceWaterBarPosition;
        public final ForgeConfigSpec.ConfigValue<String> waterBarPosition;
        public final ForgeConfigSpec.IntValue waterBarOffsetX;
        public final ForgeConfigSpec.IntValue waterBarOffsetY;

        Client(ForgeConfigSpec.Builder builder) {
            this.useFahrenheit = builder.comment("Use Fahrenheit, otherwise use Celcius.").define("useFahrenheit", true);
            this.showDegreeSymbol = builder.comment("Show degree symbol next to temperature value.").define("showDegreeSymbol", true);
            this.debugPosition = builder.comment("Position of debug info, one of: " + positions).defineInList("position", (Object)"TOPRIGHT", positions);
            this.debugOffsetX = builder.comment("Debug text X offset").defineInRange("debugOffsetX", 3, -100, 100);
            this.debugOffsetY = builder.comment("Debug text Y offset").defineInRange("debugOffsetY", 3, -100, 100);
            this.scale = builder.comment("The size of the text info (multiplier)").defineInRange("scale", 0.5, 0.5, 2.0);
            this.temperatureColorRange = builder.comment("Temperature color range (Format (cold->hot): #3ab3da->#f9801d)").define("temperatureColorRange", (Object)"#3ab3da->#f9801d", hexRangeValidator);
            this.temperatureHudOption = builder.comment("Select which hud element to display for body and area temperature. One of: " + temperatureHudOptions).defineInList("temperatureHudOption", (Object)"CENTER_GLOBE", temperatureHudOptions);
            this.thermometerPosition = builder.comment("Position of the RIGHT_THERMOMETER HUD if enabled, one of: " + positions).defineInList("thermometerPosition", (Object)"BOTTOMRIGHT", positions);
            this.thermometerOffsetX = builder.comment("RIGHT_THERMOMETER HUD X offset").defineInRange("thermometerOffsetX", 133, -500, 500);
            this.thermometerOffsetY = builder.comment("RIGHT_THERMOMETER HUD Y offset").defineInRange("thermometerOffsetY", 27, -500, 500);
            this.thermometerTextOffsetY = builder.comment("RIGHT_THERMOMETER HUD Y offset").defineInRange("thermometerTextOffsetY", 15, -500, 500);
            this.showThermometerRateChangeSymbols = builder.comment("Show rate change symbols to left/right of thermometer. Left is core temp, right is skin temperature.").define("showThermometerRateChangeSymbols", true);
            this.globePosition = builder.comment("Position of the CENTER_GLOBE HUD if enabled, one of: " + positions).defineInList("globePosition", (Object)"BOTTOMCENTER", positions);
            this.globeOffsetX = builder.comment("CENTER_GLOBE HUD X offset").defineInRange("globeOffsetX", 0, -500, 500);
            this.globeOffsetY = builder.comment("CENTER_GLOBE HUD Y offset").defineInRange("globeOffsetY", 50, -500, 500);
            this.globeTextOffsetY = builder.comment("CENTER_GLOBE HUD Y offset").defineInRange("globeTextOffsetY", 90, -500, 500);
            this.forceWaterBarPosition = builder.comment("Set to true to force position of the water bar.").define("forceWaterBarPosition", false);
            this.waterBarPosition = builder.comment("Position of the Water Bar HUD if forceWaterBarPosition is true, one of: " + positions).defineInList("waterBarPosition", (Object)"BOTTOMCENTER", positions);
            this.waterBarOffsetX = builder.comment("Water Bar HUD X offset").defineInRange("waterBarOffsetX", 96, -500, 500);
            this.waterBarOffsetY = builder.comment("Water Bar HUD Y offset").defineInRange("waterBarOffsetY", 50, -500, 500);
        }

        public static boolean useFahrenheit() {
            return (Boolean)Client.CONFIG.useFahrenheit.get();
        }

        public static boolean showDegreeSymbol() {
            return (Boolean)Client.CONFIG.showDegreeSymbol.get();
        }

        public static String debugPosition() {
            return (String)Client.CONFIG.debugPosition.get();
        }

        public static int debugOffsetX() {
            return (Integer)Client.CONFIG.debugOffsetX.get();
        }

        public static int debugOffsetY() {
            return (Integer)Client.CONFIG.debugOffsetY.get();
        }

        public static double scale() {
            return (Double)Client.CONFIG.scale.get();
        }

        public static Color temperatureColorCold() {
            return temperatureColorCold;
        }

        public static Color temperatureColorHot() {
            return temperatureColorHot;
        }

        public static String temperatureHudOption() {
            return (String)Client.CONFIG.temperatureHudOption.get();
        }

        public static String thermometerPosition() {
            return (String)Client.CONFIG.thermometerPosition.get();
        }

        public static int thermometerOffsetX() {
            return (Integer)Client.CONFIG.thermometerOffsetX.get();
        }

        public static int thermometerOffsetY() {
            return (Integer)Client.CONFIG.thermometerOffsetY.get();
        }

        public static int thermometerTextOffsetY() {
            return (Integer)Client.CONFIG.thermometerTextOffsetY.get();
        }

        public static boolean showThermometerRateChangeSymbols() {
            return (Boolean)Client.CONFIG.showThermometerRateChangeSymbols.get();
        }

        public static String globePosition() {
            return (String)Client.CONFIG.globePosition.get();
        }

        public static int globeOffsetX() {
            return (Integer)Client.CONFIG.globeOffsetX.get();
        }

        public static int globeOffsetY() {
            return (Integer)Client.CONFIG.globeOffsetY.get();
        }

        public static int globeTextOffsetY() {
            return (Integer)Client.CONFIG.globeTextOffsetY.get();
        }

        public static boolean forceWaterBarPosition() {
            return (Boolean)Client.CONFIG.forceWaterBarPosition.get();
        }

        public static String waterBarPosition() {
            return (String)Client.CONFIG.waterBarPosition.get();
        }

        public static int waterBarOffsetX() {
            return (Integer)Client.CONFIG.waterBarOffsetX.get();
        }

        public static int waterBarOffsetY() {
            return (Integer)Client.CONFIG.waterBarOffsetY.get();
        }

        public static void init() {
            String[] temperatureColors = ((String)Client.CONFIG.temperatureColorRange.get()).split("->");
            temperatureColorCold = ColorHelper.decode(temperatureColors[0]);
            temperatureColorHot = ColorHelper.decode(temperatureColors[1]);
        }

        static {
            positions = Arrays.asList("TOPLEFT", "TOPCENTER", "TOPRIGHT", "BOTTOMLEFT", "BOTTOMCENTER", "BOTTOMRIGHT");
            temperatureHudOptions = Arrays.asList("CENTER_GLOBE", "RIGHT_THERMOMETER");
            temperatureColorCold = ColorHelper.decode("#3ab3da");
            temperatureColorHot = ColorHelper.decode("#f9801d");
            hexRangeValidator = s -> s instanceof String && ((String)s).matches("#[a-zA-Z\\d]{6}->#[a-zA-Z\\d]{6}");
            Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
            CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
            CONFIG = (Client)specPair.getLeft();
        }
    }

    public static final class Common {
        public static final ForgeConfigSpec CONFIG_SPEC;
        private static final Common CONFIG;
        public final ForgeConfigSpec.BooleanValue debugEnabled;
        public final ForgeConfigSpec.BooleanValue showTemperatureValues;
        public final ForgeConfigSpec.BooleanValue requireThermometer;

        Common(ForgeConfigSpec.Builder builder) {
            this.debugEnabled = builder.comment("Show temperature debug info.").define("debugEnabled", false);
            this.showTemperatureValues = builder.comment("Show temperature values in HUD.").define("showTemperatureValues", true);
            this.requireThermometer = builder.comment("Require thermometer helmet enhancement to display temperature values.").define("requireThermometer", false);
        }

        public static boolean debugEnabled() {
            return (Boolean)Common.CONFIG.debugEnabled.get();
        }

        public static boolean showTemperatureValues() {
            return (Boolean)Common.CONFIG.showTemperatureValues.get();
        }

        public static boolean requireThermometer() {
            return (Boolean)Common.CONFIG.requireThermometer.get();
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
            CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
            CONFIG = (Common)specPair.getLeft();
        }
    }
}

