/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.fluid.DrinkingFluid;
import homeostatic.common.fluid.DrinkingFluidManager;
import homeostatic.data.integration.ModIntegration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;

public class DrinkingFluidsProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<ResourceLocation, DrinkingFluid> DRINKING_FLUIDS = new HashMap<ResourceLocation, DrinkingFluid>();
    private final DataGenerator dataGenerator;
    private final String modid;

    public DrinkingFluidsProvider(DataGenerator dataGenerator, String modid) {
        this.dataGenerator = dataGenerator;
        this.modid = modid;
    }

    protected void addDrinkingFluids() {
        this.add(ModIntegration.mcLoc("water"), 1, 0.0f, 45, 200, 0.2f);
        this.add(Homeostatic.loc("purified_water"), 3, 0.7f, 0, 0, 0.0f);
    }

    protected void add(ResourceLocation loc, int amount, float saturation, int potency, int duration, float chance) {
        this.DRINKING_FLUIDS.put(loc, new DrinkingFluid(loc, amount, saturation, potency, duration, chance));
    }

    public String m_6055_() {
        return "Homeostatic - Drinking Fluids";
    }

    public void m_6865_(HashCache pCache) throws IOException {
        this.addDrinkingFluids();
        Path output = this.dataGenerator.m_123916_();
        for (Map.Entry<ResourceLocation, DrinkingFluid> entry : this.DRINKING_FLUIDS.entrySet()) {
            Path drinkingFluidsPath = DrinkingFluidsProvider.getPath(output, entry.getKey());
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)pCache, (JsonElement)DrinkingFluidManager.parseDrinkingFluid(entry.getValue()), (Path)drinkingFluidsPath);
            }
            catch (IOException e) {
                Homeostatic.LOGGER.error("Couldn't save homeostatic drinking fluids %s %s", (Object)drinkingFluidsPath, (Object)e);
            }
        }
    }

    private static Path getPath(Path output, ResourceLocation loc) {
        return output.resolve("data/" + loc.m_135827_() + "/environment/fluids/" + loc.m_135815_() + ".json");
    }
}

