/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data.integration.create;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.foundation.data.recipe.ProcessingRecipeGen;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import homeostatic.Homeostatic;
import homeostatic.common.TagManager;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.util.WaterHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class FillingRecipeProvider
extends ProcessingRecipeGen {
    public FillingRecipeProvider(DataGenerator generator) {
        super(generator);
        this.createRecipes();
    }

    private void createRecipes() {
        this.createFlaskRecipe("purified_water", TagManager.Fluids.PURIFIED_WATER, Homeostatic.loc("purified_water"));
        this.createFlaskRecipe("water", (TagKey<Fluid>)FluidTags.f_13131_, new ResourceLocation("minecraft", "water"));
    }

    private void createFlaskRecipe(String id, TagKey<Fluid> key, ResourceLocation fluid) {
        this.create(Homeostatic.loc(id), b -> b.require(key, 1000).require((ItemLike)HomeostaticItems.LEATHER_FLASK).output(WaterHelper.getFilledItem(new ItemStack((ItemLike)HomeostaticItems.LEATHER_FLASK), fluid, 5000)).whenModLoaded("create"));
    }

    public String m_6055_() {
        return "Homeostatic - Create Filling Recipes";
    }

    protected IRecipeTypeInfo getRecipeType() {
        return AllRecipeTypes.FILLING;
    }
}

