/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data.recipe;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import homeostatic.Homeostatic;
import homeostatic.mixin.RecipeProviderAccessor;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;

public abstract class RecipeProviderBase
implements DataProvider {
    private final DataGenerator generator;

    protected RecipeProviderBase(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@Nonnull HashCache cache) throws IllegalStateException {
        Path path = this.generator.m_123916_();
        HashSet recipes = Sets.newHashSet();
        this.registerRecipes(provider -> {
            if (recipes.add(provider.m_6445_())) {
                RecipeProviderAccessor.callSaveRecipe(cache, provider.m_125966_(), path.resolve("data/" + provider.m_6445_().m_135827_() + "/recipes/" + provider.m_6445_().m_135815_() + ".json"));
                JsonObject json = provider.m_5860_();
                if (json != null) {
                    RecipeProviderBase.saveRecipeAdvancement(this.generator, cache, json, path.resolve("data/" + provider.m_6445_().m_135827_() + "/advancements/" + provider.m_6448_().m_135815_() + ".json"));
                }
            } else {
                throw new IllegalStateException("Duplicate recipe " + provider.m_6445_());
            }
        });
    }

    protected abstract void registerRecipes(Consumer<FinishedRecipe> var1);

    public static void saveRecipeAdvancement(DataGenerator gen, HashCache cache, JsonObject json, Path path) {
        ((RecipeProviderAccessor)new RecipeProvider(gen)).callSaveRecipeAdvancement(cache, json, path);
    }

    protected static void specialRecipe(Consumer<FinishedRecipe> consumer, SimpleRecipeSerializer<?> serializer) {
        ResourceLocation name = Registry.f_122865_.m_7981_(serializer);
        SpecialRecipeBuilder.m_126357_(serializer).m_126359_(consumer, Homeostatic.loc("dynamic/" + Objects.requireNonNull(name).m_135815_()).toString());
    }
}

