/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.event;

import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.OverlayManager;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="homeostatic", value={Dist.CLIENT})
public class GameOverlayEventHandler {
    private final OverlayManager overlayManager = OverlayManager.INSTANCE;
    public static final GameOverlayEventHandler INSTANCE = new GameOverlayEventHandler();
    private static boolean enabled = false;
    private final IIngameOverlay OVERLAY = OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.HUD_TEXT_ELEMENT, (String)"homeostatic:overlay", (matrix, partialTicks, width, height, height2) -> this.callRenderOverlay(partialTicks));
    private final IIngameOverlay WATER_LEVEL_OVERLAY = OverlayRegistry.registerOverlayTop((String)"Water Level", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            this.overlayManager.renderWaterOverlay(poseStack, gui.right_height);
        }
    });
    private final IIngameOverlay TEMPERATURE_OVERLAY = OverlayRegistry.registerOverlayTop((String)"Temperature", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            this.overlayManager.renderTemperatureOverlay(poseStack);
        }
    });
    private final IIngameOverlay ENHANCED_VISUALS_OVERLAY = OverlayRegistry.registerOverlayBottom((String)"Enhanced Visuals", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            this.overlayManager.renderEnhancedVisualsOverlay(poseStack);
        }
    });
    private final IIngameOverlay HYDRATION_OVERLAY = OverlayRegistry.registerOverlayTop((String)"Hydration", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            this.overlayManager.renderHydrationOverlay(poseStack, gui.right_height);
        }
    });

    public void callRenderOverlay(PoseStack matrix) {
        if (enabled && ConfigHandler.Common.debugEnabled() && !Minecraft.m_91087_().f_91066_.f_92063_) {
            this.overlayManager.renderOverlay(matrix);
        }
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        ConfigHandler.Client.init();
        enabled = true;
    }

    public void onModConfigReloading(ModConfigEvent.Reloading event) {
        if (enabled && event.getConfig().getSpec() == ConfigHandler.Client.CONFIG_SPEC) {
            ConfigHandler.Client.init();
            OverlayRegistry.enableOverlay((IIngameOverlay)this.OVERLAY, (boolean)ConfigHandler.Common.debugEnabled());
            OverlayRegistry.enableOverlay((IIngameOverlay)this.WATER_LEVEL_OVERLAY, (boolean)true);
            OverlayRegistry.enableOverlay((IIngameOverlay)this.TEMPERATURE_OVERLAY, (boolean)true);
            OverlayRegistry.enableOverlay((IIngameOverlay)this.ENHANCED_VISUALS_OVERLAY, (boolean)true);
            OverlayRegistry.enableOverlay((IIngameOverlay)this.HYDRATION_OVERLAY, (boolean)true);
        }
    }

    static {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(INSTANCE::onLoadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(INSTANCE::onModConfigReloading);
    }
}

