/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.event;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.capabilities.Temperature;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.common.temperature.ThermometerInfo;
import homeostatic.common.water.WaterInfo;
import homeostatic.config.ConfigHandler;
import homeostatic.network.DrinkWater;
import homeostatic.network.NetworkHandler;
import homeostatic.network.TemperatureData;
import homeostatic.network.ThermometerData;
import homeostatic.network.WaterData;
import homeostatic.util.WaterHelper;
import homeostatic.util.WetnessHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="homeostatic")
public class PlayerEventHandler {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Player player;
        Player player2 = player = event.getEntity() instanceof Player ? (Player)event.getEntity() : null;
        if (player != null && !player.f_19853_.f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            ServerLevel world = sp.m_183503_();
            if (sp.f_8941_.m_9290_() != GameType.SURVIVAL) {
                return;
            }
            WaterHelper.updateWaterInfo(sp, 0.0f);
            WetnessHelper.updateWetnessInfo(sp, 0.0f, true);
            sp.getCapability(CapabilityRegistry.TEMPERATURE_CAPABILITY).ifPresent(data -> {
                BlockPos pos = sp.m_146901_();
                Holder biome = world.m_204166_(pos);
                EnvironmentData environmentData = new EnvironmentData(sp, pos, (Holder<Biome>)biome, world);
                BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (Temperature)data);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new TemperatureData(environmentData.getLocalTemperature(), bodyTemperature));
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof FakePlayer) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!event.player.m_183503_().m_5776_()) {
            ServerPlayer sp = (ServerPlayer)event.player;
            if (sp.f_8941_.m_9290_() != GameType.SURVIVAL) {
                return;
            }
            ServerLevel world = sp.m_183503_();
            ProfilerFiller profilerfiller = world.m_46473_();
            sp.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> data.checkWaterLevel(sp));
            profilerfiller.m_6180_("tempCalc");
            sp.getCapability(CapabilityRegistry.TEMPERATURE_CAPABILITY).ifPresent(data -> {
                if (sp.f_19797_ % 2 == 0) {
                    data.checkTemperatureLevel((Player)sp);
                }
                if (sp.f_19797_ % 16 == 0 || sp.f_19797_ % 60 == 0) {
                    BlockPos pos = sp.m_146901_();
                    Holder biome = world.m_204166_(pos);
                    EnvironmentData environmentData = new EnvironmentData(sp, pos, (Holder<Biome>)biome, world);
                    boolean updateCore = sp.f_19797_ % 60 == 0;
                    BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (Temperature)data, updateCore, true);
                    data.setTemperatureData(environmentData.getLocalTemperature(), bodyTemperature);
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new TemperatureData(environmentData.getLocalTemperature(), bodyTemperature));
                }
            });
            profilerfiller.m_7238_();
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.Clone event) {
        Player player;
        if (!event.isWasDeath()) {
            return;
        }
        Player player2 = player = event.getEntity() != null ? (Player)event.getEntity() : null;
        if (player != null && !player.f_19853_.f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            ServerLevel world = sp.m_183503_();
            if (sp.f_8941_.m_9290_() != GameType.SURVIVAL) {
                return;
            }
            sp.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> {
                WaterInfo waterInfo = new WaterInfo(10, 2.5f, 0.0f);
                data.setWaterData(waterInfo);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new WaterData(waterInfo));
            });
            sp.getCapability(CapabilityRegistry.TEMPERATURE_CAPABILITY).ifPresent(data -> {
                BlockPos pos = sp.m_146901_();
                Holder biome = world.m_204166_(pos);
                EnvironmentData environmentData = new EnvironmentData(sp, pos, (Holder<Biome>)biome, world);
                BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (Temperature)data);
                data.setTemperatureData(environmentData.getLocalTemperature(), bodyTemperature);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new TemperatureData(environmentData.getLocalTemperature(), bodyTemperature));
            });
        }
    }

    @SubscribeEvent
    public static void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        Player player = event.getPlayer();
        if (player != null && player.f_19853_.f_46443_) {
            PlayerEventHandler.drinkWater(player, (PlayerInteractEvent)event);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        if (player != null && player.f_19853_.f_46443_) {
            PlayerEventHandler.drinkWater(player, (PlayerInteractEvent)event);
        }
    }

    @SubscribeEvent
    public static void onFinishUsingItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.f_46443_) {
                ItemStack stack = event.getItem();
                ServerPlayer sp = (ServerPlayer)player;
                WaterHelper.drink(sp, stack, true);
            }
        }
    }

    private static void drinkWater(Player player, PlayerInteractEvent event) {
        InteractionHand hand = event.getHand();
        if (hand != InteractionHand.OFF_HAND || player.m_20089_() != Pose.CROUCHING || !player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            return;
        }
        Level level = event.getWorld();
        HitResult hitresult = player.m_19907_(2.0, 0.0f, true);
        BlockPos pos = ((BlockHitResult)hitresult).m_82425_();
        if (hitresult.m_6662_() == HitResult.Type.BLOCK && level.m_6425_(pos).m_76152_() == Fluids.f_76193_) {
            player.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> {
                if (data.getWaterLevel() < 20) {
                    player.m_183503_().m_5594_(player, pos, SoundEvents.f_11911_, SoundSource.PLAYERS, 0.4f, 1.0f);
                    NetworkHandler.INSTANCE.sendToServer((Object)new DrinkWater());
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        Entity entity;
        if (ConfigHandler.Common.showTemperatureValues() && ConfigHandler.Common.requireThermometer() && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (!player.f_19853_.f_46443_ && event.getSlot() == EquipmentSlot.HEAD) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.getCapability(CapabilityRegistry.THERMOMETER_CAPABILITY).ifPresent(data -> {
                    ItemStack equippedHelmet = event.getTo();
                    boolean equippedHasThermometer = PlayerEventHandler.hasThermometer(equippedHelmet);
                    ThermometerInfo info = new ThermometerInfo(equippedHasThermometer);
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new ThermometerData(info));
                });
            }
        }
    }

    private static boolean hasThermometer(ItemStack helmet) {
        CompoundTag tag = helmet.m_41784_();
        return tag.m_128441_("thermometer");
    }
}

