/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.integrations.patchouli;

import homeostatic.Homeostatic;
import homeostatic.common.TagManager;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.util.WaterHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.page.PageCrafting;

public class PageCustomCrafting
extends PageCrafting {
    public static void init() {
        ClientBookRegistry registry = ClientBookRegistry.INSTANCE;
        registry.pageTypes.put(Homeostatic.loc("custom_crafting"), PageCustomCrafting.class);
    }

    public Recipe<?> loadRecipe(BookContentsBuilder builder, BookEntry entry, ResourceLocation loc) {
        Ingredient ingredient = null;
        ItemStack armorStackBase = null;
        ItemStack armorStack = null;
        ItemStack leatherFlaskBase = null;
        ItemStack leatherFlask = null;
        ShapelessRecipe customRecipe = null;
        boolean removalRecipe = false;
        if (loc != null) {
            String recipe;
            switch (recipe = loc.m_135815_()) {
                case "insulation": {
                    ingredient = Ingredient.m_204132_(TagManager.Items.INSULATION);
                    armorStackBase = new ItemStack((ItemLike)Items.f_42463_);
                    armorStack = armorStackBase.m_41777_();
                    CompoundTag armorStackTag = armorStack.m_41784_();
                    armorStackTag.m_128379_("insulation", true);
                    break;
                }
                case "remove_insulation": {
                    ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42574_});
                    armorStackBase = new ItemStack((ItemLike)Items.f_42463_);
                    armorStack = armorStackBase.m_41777_();
                    CompoundTag armorStackTag = armorStackBase.m_41784_();
                    armorStackTag.m_128379_("insulation", true);
                    removalRecipe = true;
                    break;
                }
                case "waterproof": {
                    ingredient = Ingredient.m_204132_(TagManager.Items.WATERPROOF);
                    armorStackBase = new ItemStack((ItemLike)Items.f_42407_);
                    armorStack = armorStackBase.m_41777_();
                    CompoundTag armorStackTag = armorStack.m_41784_();
                    armorStackTag.m_128379_("waterproof", true);
                    break;
                }
                case "remove_waterproof": {
                    ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42448_});
                    armorStackBase = new ItemStack((ItemLike)Items.f_42407_);
                    armorStack = armorStackBase.m_41777_();
                    CompoundTag armorStackTag = armorStackBase.m_41784_();
                    armorStackTag.m_128379_("waterproof", true);
                    removalRecipe = true;
                    break;
                }
                case "radiation_protection": {
                    ingredient = Ingredient.m_204132_(TagManager.Items.RADIATION_PROTECTION);
                    armorStackBase = new ItemStack((ItemLike)Items.f_42408_);
                    armorStack = armorStackBase.m_41777_();
                    CompoundTag armorStackTag = armorStack.m_41784_();
                    armorStackTag.m_128379_("radiation_protection", true);
                    break;
                }
                case "remove_radiation_protection": {
                    ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_});
                    armorStackBase = new ItemStack((ItemLike)Items.f_42408_);
                    armorStack = armorStackBase.m_41777_();
                    CompoundTag armorStackTag = armorStackBase.m_41784_();
                    armorStackTag.m_128379_("radiation_protection", true);
                    removalRecipe = true;
                    break;
                }
                case "filtered_water_flask": {
                    ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{HomeostaticItems.WATER_FILTER});
                    leatherFlaskBase = new ItemStack((ItemLike)HomeostaticItems.LEATHER_FLASK);
                    leatherFlask = WaterHelper.getFilledItem(leatherFlaskBase, (Fluid)HomeostaticFluids.PURIFIED_WATER, 5000);
                }
            }
            if (armorStackBase != null) {
                Ingredient baseArmorIngredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{armorStackBase});
                NonNullList armorInputs = removalRecipe ? NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseArmorIngredient, ingredient}) : NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseArmorIngredient, ingredient, Ingredient.f_43901_, ingredient, ingredient});
                customRecipe = new ShapelessRecipe(new ResourceLocation("homeostatic", recipe), "armor.enhancement", armorStack, armorInputs);
            } else if (leatherFlask != null) {
                Ingredient baseFlaskIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{leatherFlaskBase.m_41720_()});
                NonNullList recipeInputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseFlaskIngredient, ingredient});
                customRecipe = new ShapelessRecipe(new ResourceLocation("homeostatic", recipe), "flask.filter", leatherFlask, recipeInputs);
            }
        }
        return customRecipe;
    }
}

