/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.common.Hydration;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.overlay.Overlay;
import homeostatic.overlay.WaterHud;
import homeostatic.util.WaterHelper;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="homeostatic")
public class HydrationOverlay
extends Overlay {
    private static float unclampedAlpha = 0.0f;
    private static float alpha = 0.0f;
    private static byte alphaDirection = 1;
    protected static int tickCount = 0;

    @Override
    public void render(PoseStack matrix, Minecraft mc, @Nullable BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        Hydration hydration = WaterHelper.getItemHydration(heldItem);
        if (hydration == null) {
            HydrationOverlay.resetAlpha();
            return;
        }
        Gui gui = mc.f_91065_;
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)WaterHud.WATER_BAR);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_69405_((int)770, (int)771);
        MobEffectInstance effectInstance = mc.f_91074_.m_21124_((MobEffect)HomeostaticEffects.THIRST.get());
        player.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> {
            int waterLevel = data.getWaterLevel() + hydration.amount();
            float waterSaturationLevel = data.getWaterSaturationLevel() + hydration.saturation();
            WaterHelper.drawWaterBar(scaledWidth, scaledHeight, effectInstance, gui, matrix, waterSaturationLevel, waterLevel, tickCount);
        });
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if ((unclampedAlpha += (float)alphaDirection * 0.125f) >= 1.5f) {
            alphaDirection = (byte)-1;
        } else if (unclampedAlpha <= -0.5f) {
            alphaDirection = 1;
        }
        alpha = Math.max(0.0f, Math.min(1.0f, unclampedAlpha)) * Math.min(1.0f, 0.65f);
        ++tickCount;
        tickCount %= 1200;
    }

    public static void resetAlpha() {
        alpha = 0.0f;
        unclampedAlpha = 0.0f;
        alphaDirection = 1;
    }
}

