/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.EnhancedVisualsOverlay;
import homeostatic.overlay.HydrationOverlay;
import homeostatic.overlay.Overlay;
import homeostatic.overlay.TemperatureGlobeOverlay;
import homeostatic.overlay.TemperatureInfo;
import homeostatic.overlay.TemperatureOverlay;
import homeostatic.overlay.WaterHud;
import homeostatic.overlay.WetnessOverlay;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;

public class OverlayManager {
    public static final OverlayManager INSTANCE = new OverlayManager();
    public final WaterHud waterHud = new WaterHud();
    public final WetnessOverlay wetnessOverlay = new WetnessOverlay();
    public final TemperatureOverlay temperatureOverlay = new TemperatureOverlay();
    public final TemperatureGlobeOverlay temperatureGlobeOverlay = new TemperatureGlobeOverlay();
    public final TemperatureInfo temperatureInfo = new TemperatureInfo();
    public final EnhancedVisualsOverlay enhancedVisualsOverlay = new EnhancedVisualsOverlay();
    public final HydrationOverlay hydrationOverlay = new HydrationOverlay();

    private OverlayManager() {
    }

    public void render(PoseStack matrix, Overlay overlay, boolean scaled, int rightHeight) {
        Minecraft mc = Minecraft.m_91087_();
        BlockPos pos = Objects.requireNonNull(mc.m_91288_()).m_142538_();
        if (mc.f_91073_ != null && mc.f_91073_.m_46749_(pos)) {
            int scaledHeight;
            int scaledWidth;
            if (scaled) {
                float scale = (float)ConfigHandler.Client.scale();
                scaledWidth = (int)((float)mc.m_91268_().m_85445_() / scale);
                scaledHeight = (int)((float)mc.m_91268_().m_85446_() / scale);
                matrix.m_85836_();
                matrix.m_85841_(scale, scale, scale);
            } else {
                scaledWidth = mc.m_91268_().m_85445_();
                scaledHeight = mc.m_91268_().m_85446_() - rightHeight;
                matrix.m_85836_();
            }
            overlay.render(matrix, mc, pos, scaledWidth, scaledHeight);
            matrix.m_85849_();
        }
    }

    public void renderOverlay(PoseStack matrix) {
        this.render(matrix, this.temperatureInfo, true, 0);
    }

    public void renderWaterOverlay(PoseStack matrix, int rightHeight) {
        if (ConfigHandler.Client.forceWaterBarPosition()) {
            rightHeight = 0;
        }
        this.render(matrix, this.waterHud, false, rightHeight);
        this.render(matrix, this.wetnessOverlay, false, 0);
    }

    public void renderTemperatureOverlay(PoseStack matrix) {
        switch (ConfigHandler.Client.temperatureHudOption()) {
            case "RIGHT_THERMOMETER": {
                this.render(matrix, this.temperatureOverlay, false, 0);
                break;
            }
            default: {
                this.render(matrix, this.temperatureGlobeOverlay, false, 0);
            }
        }
    }

    public void renderEnhancedVisualsOverlay(PoseStack matrix) {
        this.render(matrix, this.enhancedVisualsOverlay, false, 0);
    }

    public void renderHydrationOverlay(PoseStack matrix, int rightHeight) {
        this.render(matrix, this.hydrationOverlay, false, rightHeight);
    }
}

