/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.Homeostatic;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.capabilities.Temperature;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.Overlay;
import homeostatic.util.Alignment;
import homeostatic.util.ColorHelper;
import homeostatic.util.TempHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;

public class TemperatureGlobeOverlay
extends Overlay {
    public static final ResourceLocation ICONS = Homeostatic.loc("textures/gui/icons.png");
    protected static final int ICON_WIDTH = 18;
    protected static final int ICON_HEIGHT = 14;

    TemperatureGlobeOverlay() {
    }

    @Override
    public void render(PoseStack matrix, Minecraft mc, @Nullable BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
        player.getCapability(CapabilityRegistry.TEMPERATURE_CAPABILITY).ifPresent(arg_0 -> this.lambda$render$1(scaledWidth, scaledHeight, mc, matrix, (Player)player, arg_0));
    }

    private int getTempOffset(Tuple<TempHelper.TemperatureRange, Integer> rangeStep) {
        TempHelper.TemperatureRange range = (TempHelper.TemperatureRange)((Object)rangeStep.m_14418_());
        int step = (Integer)rangeStep.m_14419_() / 2;
        int offset = range == TempHelper.TemperatureRange.COLD ? 120 + step * 15 : 120 - step * 15;
        return offset;
    }

    private /* synthetic */ void lambda$render$1(int scaledWidth, int scaledHeight, Minecraft mc, PoseStack matrix, Player player, Temperature data) {
        int offsetX = Alignment.getX(ConfigHandler.Client.globePosition(), scaledWidth, 18, ConfigHandler.Client.globeOffsetX());
        int pY = Alignment.getY(ConfigHandler.Client.globePosition(), scaledHeight, ConfigHandler.Client.globeOffsetY());
        float textScale = 0.5f;
        int textOffsetY = Alignment.getIconTextY(ConfigHandler.Client.globePosition(), scaledHeight, ConfigHandler.Client.globeTextOffsetY(), textScale);
        int pUOffset = 80;
        String coreTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.1f\u00b0" : "%.1f";
        String localTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.0f\u00b0" : "%.0f";
        String coreTempSmall = String.format(coreTempFormat, TempHelper.convertMcTemp(data.getCoreTemperature(), ConfigHandler.Client.useFahrenheit()));
        String localTemp = String.format(localTempFormat, TempHelper.convertMcTemp(data.getLocalTemperature(), ConfigHandler.Client.useFahrenheit()));
        AtomicBoolean showTemperature = new AtomicBoolean(ConfigHandler.Common.showTemperatureValues());
        int coreOffsetX = Alignment.getIconTextX(ConfigHandler.Client.globePosition(), scaledWidth, mc.f_91062_.m_92895_(coreTempSmall), ConfigHandler.Client.globeOffsetX(), textScale, 18);
        int localOffsetX = Alignment.getIconTextX(ConfigHandler.Client.globePosition(), scaledWidth, mc.f_91062_.m_92895_(localTemp), ConfigHandler.Client.globeOffsetX(), textScale, 18);
        Tuple<TempHelper.TemperatureRange, Integer> localRangeStep = TempHelper.getLocalTemperatureRangeStep(data.getLocalTemperature());
        Tuple<TempHelper.TemperatureRange, Integer> coreRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getCoreTemperature());
        int pV = this.getTempOffset(coreRangeStep);
        int localPV = this.getTempOffset(localRangeStep);
        this.m_93228_(matrix, offsetX, pY, pUOffset, pV, 18, 14);
        this.m_93228_(matrix, offsetX, pY, pUOffset + 18, localPV, 18, 14);
        if (ConfigHandler.Common.requireThermometer()) {
            player.getCapability(CapabilityRegistry.THERMOMETER_CAPABILITY).ifPresent(thermometer -> showTemperature.set(thermometer.hasThermometer()));
        }
        if (showTemperature.get()) {
            matrix.m_85841_(textScale, textScale, textScale);
            mc.f_91062_.m_92750_(matrix, localTemp, (float)(localOffsetX - 1), (float)(textOffsetY - 19), ColorHelper.getLocalTemperatureColor(localRangeStep));
            mc.f_91062_.m_92750_(matrix, coreTempSmall, (float)(coreOffsetX - 1), (float)textOffsetY, ColorHelper.getGlobeTemperatureColor(coreRangeStep));
        }
    }
}

