/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.Overlay;
import homeostatic.util.Alignment;
import homeostatic.util.ColorHelper;
import homeostatic.util.FontHelper;
import homeostatic.util.TempHelper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;

public class TemperatureInfo
extends Overlay {
    @Override
    public void render(PoseStack matrix, Minecraft mc, BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        player.getCapability(CapabilityRegistry.TEMPERATURE_CAPABILITY).ifPresent(data -> {
            TempHelper.TemperatureDirection skinTemperatureDirection = TempHelper.getSkinTemperatureDirection(data.getLocalTemperature(), data.getSkinTemperature());
            TempHelper.TemperatureDirection coreTemperatureDirection = TempHelper.getCoreTemperatureDirection(data.getLastSkinTemperature(), data.getCoreTemperature(), data.getSkinTemperature());
            String skinIcon = TemperatureInfo.getDirectionIcon(skinTemperatureDirection);
            String coreIcon = TemperatureInfo.getDirectionIcon(coreTemperatureDirection);
            String localTemp = String.format(" %.2f", TempHelper.convertMcTemp(data.getLocalTemperature(), ConfigHandler.Client.useFahrenheit()));
            String skinTemp = String.format("s: %.2f%s", TempHelper.convertMcTemp(data.getSkinTemperature(), ConfigHandler.Client.useFahrenheit()), skinIcon);
            String coreTemp = String.format(" c: %.2f%s ", TempHelper.convertMcTemp(data.getCoreTemperature(), ConfigHandler.Client.useFahrenheit()), coreIcon);
            Tuple<TempHelper.TemperatureRange, Integer> localRangeStep = TempHelper.getLocalTemperatureRangeStep(data.getLocalTemperature());
            Tuple<TempHelper.TemperatureRange, Integer> coreRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getCoreTemperature());
            Tuple<TempHelper.TemperatureRange, Integer> skinRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getSkinTemperature());
            int localTempWidth = mc.f_91062_.m_92895_(localTemp);
            int skinTempWidth = mc.f_91062_.m_92895_(skinTemp);
            int coreTempWidth = mc.f_91062_.m_92895_(coreTemp);
            String string = ConfigHandler.Client.debugPosition();
            Objects.requireNonNull(mc.f_91062_);
            int y = Alignment.getTextY(string, scaledHeight, 1, 9, ConfigHandler.Client.debugOffsetY(), 1.0f);
            FontHelper.draw(mc, matrix, localTemp, Alignment.getTextX(ConfigHandler.Client.debugPosition(), scaledWidth, localTempWidth, ConfigHandler.Client.debugOffsetX(), 1.0f), y, ColorHelper.getLocalTemperatureColor(localRangeStep));
            int n = Alignment.getTextX(ConfigHandler.Client.debugPosition(), scaledWidth, skinTempWidth, ConfigHandler.Client.debugOffsetX(), 1.0f);
            Objects.requireNonNull(mc.f_91062_);
            FontHelper.draw(mc, matrix, skinTemp, n, y + 9, ColorHelper.getTemperatureColor(skinRangeStep));
            int n2 = Alignment.getTextX(ConfigHandler.Client.debugPosition(), scaledWidth, coreTempWidth, ConfigHandler.Client.debugOffsetX(), 1.0f);
            Objects.requireNonNull(mc.f_91062_);
            FontHelper.draw(mc, matrix, coreTemp, n2, y + 9 * 2, ColorHelper.getTemperatureColor(coreRangeStep));
        });
    }

    public static String getDirectionIcon(TempHelper.TemperatureDirection direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case TempHelper.TemperatureDirection.COOLING -> "\u21a7";
            case TempHelper.TemperatureDirection.COOLING_RAPIDLY -> "\u21ca";
            case TempHelper.TemperatureDirection.WARMING -> "\u21a5";
            case TempHelper.TemperatureDirection.WARMING_RAPIDLY -> "\u21c8";
            case TempHelper.TemperatureDirection.NONE -> "\u00b7";
            case TempHelper.TemperatureDirection.COOLING_NORMALLY -> "\u02ec";
            case TempHelper.TemperatureDirection.WARMING_NORMALLY -> "\u02c6";
        };
    }
}

