/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.Homeostatic;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.capabilities.Temperature;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.Overlay;
import homeostatic.overlay.TemperatureInfo;
import homeostatic.util.Alignment;
import homeostatic.util.ColorHelper;
import homeostatic.util.TempHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;

public class TemperatureOverlay
extends Overlay {
    public static final ResourceLocation ICONS = Homeostatic.loc("textures/gui/icons.png");
    protected static final int ICON_WIDTH = 13;
    protected static final int ICON_HEIGHT = 26;

    @Override
    public void render(PoseStack matrix, Minecraft mc, @Nullable BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
        player.getCapability(CapabilityRegistry.TEMPERATURE_CAPABILITY).ifPresent(arg_0 -> this.lambda$render$1(scaledWidth, scaledHeight, mc, matrix, (Player)player, arg_0));
    }

    private int getTempLineOffset(Tuple<TempHelper.TemperatureRange, Integer> rangeStep) {
        TempHelper.TemperatureRange range = (TempHelper.TemperatureRange)((Object)rangeStep.m_14418_());
        int step = (Integer)rangeStep.m_14419_() / 2;
        int offset = range == TempHelper.TemperatureRange.COLD ? Math.max(7 - step, 1) : Math.min(8 + step, 15);
        return offset;
    }

    private /* synthetic */ void lambda$render$1(int scaledWidth, int scaledHeight, Minecraft mc, PoseStack matrix, Player player, Temperature data) {
        int offsetX = Alignment.getX(ConfigHandler.Client.thermometerPosition(), scaledWidth, 13, ConfigHandler.Client.thermometerOffsetX());
        int pY = Alignment.getY(ConfigHandler.Client.thermometerPosition(), scaledHeight, ConfigHandler.Client.thermometerOffsetY());
        float textScale = 0.5f;
        TempHelper.TemperatureDirection coreTemperatureDirection = TempHelper.getCoreTemperatureDirection(data.getLastSkinTemperature(), data.getCoreTemperature(), data.getSkinTemperature());
        TempHelper.TemperatureDirection skinTemperatureDirection = TempHelper.getSkinTemperatureDirection(data.getLocalTemperature(), data.getSkinTemperature());
        String coreDirection = TemperatureInfo.getDirectionIcon(coreTemperatureDirection);
        String skinDirection = TemperatureInfo.getDirectionIcon(skinTemperatureDirection);
        String coreTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.1f\u00b0" : "%.1f";
        String localTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.0f\u00b0" : "%.0f";
        String coreTempSmall = String.format(coreTempFormat, TempHelper.convertMcTemp(data.getCoreTemperature(), ConfigHandler.Client.useFahrenheit()));
        String localTemp = String.format(localTempFormat, TempHelper.convertMcTemp(data.getLocalTemperature(), ConfigHandler.Client.useFahrenheit()));
        int textOffsetX = Alignment.getIconTextX(ConfigHandler.Client.thermometerPosition(), scaledWidth, mc.f_91062_.m_92895_(coreTempSmall), ConfigHandler.Client.thermometerOffsetX(), textScale, 13);
        int localTextOffsetX = Alignment.getIconTextX(ConfigHandler.Client.thermometerPosition(), scaledWidth, mc.f_91062_.m_92895_(localTemp), ConfigHandler.Client.thermometerOffsetX(), textScale, 13);
        int textOffsetY = Alignment.getIconTextY(ConfigHandler.Client.thermometerPosition(), scaledHeight, ConfigHandler.Client.thermometerTextOffsetY(), textScale);
        int directionOffsetX = Alignment.getIconTextX(ConfigHandler.Client.thermometerPosition(), scaledWidth, mc.f_91062_.m_92895_(coreDirection), ConfigHandler.Client.thermometerOffsetX(), textScale, 13);
        int pV = 0;
        int pUOffset = 53;
        Tuple<TempHelper.TemperatureRange, Integer> localRangeStep = TempHelper.getLocalTemperatureRangeStep(data.getLocalTemperature());
        Tuple<TempHelper.TemperatureRange, Integer> coreRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getCoreTemperature());
        Tuple<TempHelper.TemperatureRange, Integer> skinRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getSkinTemperature());
        int lineOffset = this.getTempLineOffset(coreRangeStep);
        AtomicBoolean showTemperature = new AtomicBoolean(ConfigHandler.Common.showTemperatureValues());
        if (data.getCoreTemperature() > 1.7659639f) {
            this.m_93228_(matrix, offsetX, pY, pUOffset, pV + 26, 13, 26);
        } else if (data.getCoreTemperature() < 1.5898795f) {
            this.m_93228_(matrix, offsetX, pY, pUOffset, pV + 52, 13, 26);
        } else {
            this.m_93228_(matrix, offsetX, pY, pUOffset, pV, 13, 26);
        }
        this.m_93228_(matrix, offsetX, pY, pUOffset + 13, pV + lineOffset, 13, 26);
        if (ConfigHandler.Common.requireThermometer()) {
            player.getCapability(CapabilityRegistry.THERMOMETER_CAPABILITY).ifPresent(thermometer -> showTemperature.set(thermometer.hasThermometer()));
        }
        matrix.m_85841_(textScale, textScale, textScale);
        if (ConfigHandler.Client.showThermometerRateChangeSymbols()) {
            mc.f_91062_.m_92750_(matrix, coreDirection, (float)(directionOffsetX - 8), (float)(textOffsetY - 15), ColorHelper.getLocalTemperatureColor(coreRangeStep));
            mc.f_91062_.m_92750_(matrix, skinDirection, (float)(directionOffsetX + 8), (float)(textOffsetY - 15), ColorHelper.getLocalTemperatureColor(skinRangeStep));
        }
        if (showTemperature.get()) {
            mc.f_91062_.m_92750_(matrix, localTemp, (float)localTextOffsetX, (float)(textOffsetY - 50), ColorHelper.getLocalTemperatureColor(localRangeStep));
            mc.f_91062_.m_92750_(matrix, coreTempSmall, (float)textOffsetX, (float)textOffsetY, ColorHelper.getTemperatureColor(coreRangeStep));
        }
    }
}

