/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.proxy;

import homeostatic.common.block.HomeostaticBlocks;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.recipe.ArmorEnhancement;
import homeostatic.common.recipe.HelmetThermometer;
import homeostatic.common.recipe.HomeostaticRecipes;
import homeostatic.common.recipe.PurifiedLeatherFlask;
import homeostatic.common.recipe.RemoveArmorEnhancement;
import homeostatic.config.ConfigHandler;
import homeostatic.network.NetworkHandler;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="homeostatic")
public class CommonProxy {
    public void start() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ConfigHandler.init();
        this.registerListeners(bus);
    }

    public void registerListeners(IEventBus bus) {
        bus.register(RegistryListener.class);
    }

    public static final class RegistryListener {
        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            NetworkHandler.init();
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerMobEffects(RegistryEvent.Register<MobEffect> event) {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            bus.register((Object)new HomeostaticEffects());
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerItems(RegistryEvent.Register<Item> event) {
            HomeostaticItems.init((IForgeRegistry<Item>)event.getRegistry());
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            HomeostaticBlocks.init((IForgeRegistry<Block>)event.getRegistry());
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerFluids(RegistryEvent.Register<Fluid> event) {
            HomeostaticFluids.init((IForgeRegistry<Fluid>)event.getRegistry());
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void setupRegistries(FMLConstructModEvent event) {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            HomeostaticEffects.EFFECT_REGISTRY.register(bus);
            HomeostaticRecipes.RECIPE_REGISTRY.register(bus);
            ArmorEnhancement.init();
            PurifiedLeatherFlask.init();
            HelmetThermometer.init();
            RemoveArmorEnhancement.init();
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
            event.getRegistry().register(ArmorEnhancement.ARMOR_ENHANCEMENT_SERIALIZER);
            event.getRegistry().register(PurifiedLeatherFlask.PURIFIED_LEATHER_FLASK_SERIALIZER);
            event.getRegistry().register(HelmetThermometer.HELMET_THERMOMETER_SERIALIZER);
            event.getRegistry().register(RemoveArmorEnhancement.REMOVE_ARMOR_ENHANCEMENT_SERIALIZER);
        }
    }
}

