/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import homeostatic.config.ConfigHandler;
import homeostatic.util.TempHelper;
import java.awt.Color;
import net.minecraft.util.Tuple;

public class ColorHelper {
    public static final Color neutral = ColorHelper.decode("#d9d8d4");

    public static int getTemperatureColor(Tuple<TempHelper.TemperatureRange, Integer> rangeStep) {
        Color hot = ConfigHandler.Client.temperatureColorHot();
        Color cold = ConfigHandler.Client.temperatureColorCold();
        return ColorHelper.getTemperatureColorFromRange(rangeStep, hot, cold, false);
    }

    public static int getGlobeTemperatureColor(Tuple<TempHelper.TemperatureRange, Integer> rangeStep) {
        Color color = ColorHelper.decode("#FFFFFF");
        return ColorHelper.getTemperatureColorFromRange(rangeStep, color, color, true);
    }

    public static int getTemperatureColorFromRange(Tuple<TempHelper.TemperatureRange, Integer> rangeStep, Color hot, Color cold, boolean invert) {
        TempHelper.TemperatureRange range = (TempHelper.TemperatureRange)((Object)rangeStep.m_14418_());
        Color stepColor = range == TempHelper.TemperatureRange.HOT ? hot : cold;
        if (invert) {
            return ColorHelper.getRangeColor(stepColor, neutral, 18, (Integer)rangeStep.m_14419_() + 1);
        }
        return ColorHelper.getRangeColor(neutral, stepColor, 18, (Integer)rangeStep.m_14419_() + 1);
    }

    public static int getLocalTemperatureColor(Tuple<TempHelper.TemperatureRange, Integer> rangeStep) {
        TempHelper.TemperatureRange range = (TempHelper.TemperatureRange)((Object)rangeStep.m_14418_());
        Color tempColor = range == TempHelper.TemperatureRange.COLD ? ConfigHandler.Client.temperatureColorCold() : ConfigHandler.Client.temperatureColorHot();
        return ColorHelper.getRangeColor(neutral, tempColor, 18, (Integer)rangeStep.m_14419_() + 1);
    }

    public static Color decode(String color) {
        return Color.decode(color);
    }

    private static int getRangeColor(Color from, Color to, int steps, int step) {
        int diffRed = to.getRed() - from.getRed();
        int diffGreen = to.getGreen() - from.getGreen();
        int diffBlue = to.getBlue() - from.getBlue();
        return new Color(from.getRed() + diffRed * step / steps, from.getGreen() + diffGreen * step / steps, from.getBlue() + diffBlue * step / steps).getRGB();
    }
}

