/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.Homeostatic;
import homeostatic.common.Hydration;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.fluid.DrinkingFluid;
import homeostatic.common.fluid.DrinkingFluidManager;
import homeostatic.common.item.DrinkableItem;
import homeostatic.common.item.DrinkableItemManager;
import homeostatic.common.water.WaterInfo;
import homeostatic.config.ConfigHandler;
import homeostatic.data.integration.ModIntegration;
import homeostatic.network.NetworkHandler;
import homeostatic.network.WaterData;
import homeostatic.util.Alignment;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.network.PacketDistributor;

public class WaterHelper {
    public static void updateWaterInfo(ServerPlayer sp, float sweatLevel) {
        if (sp.f_8941_.m_9290_() != GameType.SURVIVAL) {
            return;
        }
        sp.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> {
            WaterInfo waterInfo = new WaterInfo(data.getWaterLevel(), data.getWaterSaturationLevel(), data.getWaterExhaustionLevel());
            waterInfo.update(sweatLevel);
            data.setWaterData(waterInfo);
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new WaterData(waterInfo));
        });
    }

    public static void drink(ServerPlayer sp, ItemStack stack, boolean update) {
        WaterHelper.drink(sp, WaterHelper.getItemHydration(stack), update);
    }

    public static void drink(ServerPlayer sp, ItemStack stack, @Nullable ResourceLocation fluid) {
        WaterHelper.drink(sp, stack, fluid, true);
    }

    public static void drink(ServerPlayer sp, ItemStack stack, @Nullable ResourceLocation fluid, boolean update) {
        WaterHelper.drink(sp, WaterHelper.getItemHydration(stack, fluid), update);
    }

    public static void drink(ServerPlayer sp, @Nullable Hydration hydration, boolean update) {
        if (hydration != null) {
            sp.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> {
                boolean isDirty = hydration.duration() > 0;
                float chance = hydration.chance();
                data.increaseWaterLevel(hydration.amount());
                data.increaseSaturationLevel(hydration.saturation());
                if (!sp.m_21023_((MobEffect)HomeostaticEffects.THIRST.get())) {
                    chance *= 0.5f;
                }
                if (isDirty && Homeostatic.RANDOM.nextFloat() < chance) {
                    sp.m_7292_(new MobEffectInstance((MobEffect)HomeostaticEffects.THIRST.get(), hydration.duration(), hydration.potency(), false, false, false));
                }
                if (update) {
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new WaterData(new WaterInfo(data.getWaterLevel(), data.getWaterSaturationLevel(), data.getWaterExhaustionLevel())));
                }
            });
        }
    }

    public static Hydration getItemHydration(@Nullable ItemStack stack, @Nullable ResourceLocation fluid) {
        DrinkableItem drinkableItem = stack != null ? DrinkableItemManager.get(stack) : null;
        DrinkingFluid drinkingFluid = fluid != null ? DrinkingFluidManager.get(fluid) : null;
        Hydration hydration = null;
        if (drinkingFluid != null) {
            hydration = DrinkingFluid.getHydration(drinkingFluid);
        } else if (drinkableItem != null) {
            hydration = DrinkableItem.getHydration(drinkableItem);
        }
        return hydration;
    }

    public static Hydration getItemHydration(ItemStack stack) {
        ResourceLocation fluid = null;
        if (stack.m_41720_() instanceof PotionItem) {
            ResourceLocation water = Registry.f_122828_.m_7981_((Object)Potions.f_43599_);
            String potion = stack.m_41784_().m_128461_("Potion");
            stack = new ItemStack((ItemLike)Items.f_41852_);
            fluid = !potion.contentEquals(water.toString()) ? Homeostatic.loc("purified_water") : ModIntegration.mcLoc("water");
        } else {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityRegistry.FLUID_ITEM_CAPABILITY).orElse(null);
            if (fluidHandlerItem != null) {
                fluid = Registry.f_122822_.m_7981_((Object)fluidHandlerItem.getFluidInTank(0).getFluid());
            }
        }
        return WaterHelper.getItemHydration(stack, fluid);
    }

    public static Hydration getFluidHydration(Fluid fluid) {
        ResourceLocation fluidKey = Registry.f_122822_.m_7981_((Object)fluid);
        return WaterHelper.getItemHydration(null, fluidKey);
    }

    public static void drinkWater(ServerPlayer sp) {
        WaterHelper.drinkDirtyWaterItem(sp, false);
    }

    public static void drinkDirtyWaterItem(ServerPlayer sp, boolean update) {
        ItemStack air = new ItemStack((ItemLike)Items.f_41852_);
        ResourceLocation water = ModIntegration.mcLoc("water");
        WaterHelper.drink(sp, air, water, update);
    }

    public static void drawWaterBar(int scaledWidth, int scaledHeight, MobEffectInstance effectInstance, Gui gui, PoseStack matrix, float waterSaturationLevel, int waterLevel, int tickCount) {
        int offsetY;
        int offsetX;
        int pV = 0;
        int pU = 0;
        int pUOffset = 0;
        if (ConfigHandler.Client.forceWaterBarPosition()) {
            offsetX = Alignment.getX(ConfigHandler.Client.globePosition(), scaledWidth, 9, ConfigHandler.Client.waterBarOffsetX());
            offsetY = Alignment.getY(ConfigHandler.Client.waterBarPosition(), scaledHeight, ConfigHandler.Client.waterBarOffsetY());
        } else {
            offsetX = scaledWidth / 2 + 91;
            offsetY = scaledHeight;
        }
        int pY = offsetY;
        if (effectInstance != null) {
            pU += 18;
            pUOffset += 9;
        }
        for (int i = 0; i < 10; ++i) {
            int pX = offsetX - i * 8 - 9;
            gui.m_93228_(matrix, pX, pY, pUOffset + 36, pV, 9, 9);
            if (waterSaturationLevel <= 0.0f && tickCount % (waterLevel * 3 + 1) == 0) {
                pY = offsetY + (Homeostatic.RANDOM.nextInt(3) - 1);
            }
            if (i * 2 + 1 < waterLevel) {
                gui.m_93228_(matrix, pX, pY, pU, pV, 9, 9);
            }
            if (i * 2 + 1 == waterLevel) {
                gui.m_93228_(matrix, pX, pY, pU + 9, pV, 9, 9);
            }
            if ((float)(i * 2 + 1) < waterSaturationLevel) {
                gui.m_93228_(matrix, pX, pY - 1, pU, pV + 9, 9, 9);
                gui.m_93228_(matrix, pX, pY + 1, pU + 9, pV + 9, 9, 9);
            }
            if ((float)(i * 2 + 1) != waterSaturationLevel) continue;
            gui.m_93228_(matrix, pX, pY, pU, pV + 9, 9, 9);
        }
    }

    public static ItemStack getFilledItem(ItemStack stack, Fluid fluid, int amount) {
        ItemStack copy = stack.m_41777_();
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)copy.getCapability(CapabilityRegistry.FLUID_ITEM_CAPABILITY).orElse(null);
        fluidHandlerItem.fill(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
        WaterHelper.updateDamage(copy);
        return copy;
    }

    public static ItemStack getFilledItem(ItemStack stack, ResourceLocation key, int amount) {
        Fluid fluid = (Fluid)Registry.f_122822_.m_7745_(key);
        return WaterHelper.getFilledItem(stack, fluid, amount);
    }

    public static void updateDamage(ItemStack stack) {
        if (stack.m_41763_()) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityRegistry.FLUID_ITEM_CAPABILITY).orElse(null);
            stack.m_41721_(Math.min(stack.m_41776_(), stack.m_41776_() - fluidHandlerItem.getFluidInTank(0).getAmount()));
        }
    }
}

