/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.block;

public record BlockRadiation(double maxRadiation) {
    public double getMaxRadiation() {
        return this.maxRadiation;
    }

    public double getBlockRadiation(double distance, boolean obscured, int y) {
        double radiation = distance <= 1.0 ? this.getMaxRadiation() : this.getMaxRadiation() / distance;
        if (y > 0 && y < 5) {
            radiation *= (double)(4 - y) * 0.25;
        }
        if (obscured) {
            radiation *= 0.9;
        }
        return Math.min(radiation, this.getMaxRadiation());
    }

    public double getBlockRadiation(double distance, boolean obscured, double amount, int y) {
        double radiation = 0.0;
        if (amount <= 0.0) {
            return radiation;
        }
        radiation = distance <= 1.0 ? this.getMaxRadiation() : this.getMaxRadiation() * amount / distance;
        if (y > 0 && y < 5) {
            radiation *= (double)(4 - y) * 0.25;
        }
        if (obscured) {
            radiation *= 0.9;
        }
        return Math.min(radiation, this.getMaxRadiation());
    }
}

