/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.recipe;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import homeostatic.common.TagManager;
import homeostatic.common.recipe.HomeostaticRecipes;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ArmorEnhancement
extends CustomRecipe {
    public ArmorEnhancement(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean matches(CraftingContainer pContainer, Level pLevel) {
        Pair<ItemStack, TagKey> check = this.checkContainer(pContainer);
        ItemStack armor = (ItemStack)check.getFirst();
        TagKey tagKey = (TagKey)check.getSecond();
        return tagKey != null && armor != null;
    }

    public ItemStack assemble(CraftingContainer pContainer) {
        Pair<ItemStack, TagKey> check = this.checkContainer(pContainer);
        ItemStack armorCopy = ((ItemStack)check.getFirst()).m_41777_();
        TagKey tagKey = (TagKey)check.getSecond();
        CompoundTag tags = armorCopy.m_41783_();
        if (tagKey == TagManager.Items.INSULATION) {
            if (!tags.m_128441_("insulation")) {
                tags.m_128379_("insulation", true);
            }
        } else if (tagKey == TagManager.Items.WATERPROOF) {
            if (!tags.m_128441_("waterproof")) {
                tags.m_128379_("waterproof", true);
            }
        } else if (tagKey == TagManager.Items.RADIATION_PROTECTION && !tags.m_128441_("radiation_protection")) {
            tags.m_128379_("radiation_protection", true);
        }
        return armorCopy;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return HomeostaticRecipes.ARMOR_ENHANCEMENT_SERIALIZER;
    }

    public Pair<ItemStack, TagKey> checkContainer(CraftingContainer pContainer) {
        ArrayList ingredients = Lists.newArrayList();
        TagKey<Item> tagKey = null;
        ItemStack armor = null;
        boolean hasInsulation = false;
        boolean hasWaterproof = false;
        boolean hasRadiation = false;
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack ingredient = pContainer.m_8020_(i);
            if (ingredient.m_204117_(TagManager.Items.INSULATION) && !hasWaterproof && !hasRadiation) {
                hasInsulation = true;
                tagKey = TagManager.Items.INSULATION;
                ingredients.add(ingredient);
                continue;
            }
            if (ingredient.m_204117_(TagManager.Items.WATERPROOF) && !hasInsulation && !hasRadiation) {
                hasWaterproof = true;
                tagKey = TagManager.Items.WATERPROOF;
                ingredients.add(ingredient);
                continue;
            }
            if (ingredient.m_204117_(TagManager.Items.RADIATION_PROTECTION) && !hasWaterproof && !hasInsulation) {
                hasRadiation = true;
                tagKey = TagManager.Items.RADIATION_PROTECTION;
                ingredients.add(ingredient);
                continue;
            }
            if (!(ingredient.m_41720_() instanceof ArmorItem)) continue;
            armor = ingredient;
        }
        if (ingredients.size() != 3) {
            tagKey = null;
        }
        return Pair.of(armor, tagKey);
    }

    public static class Type
    implements RecipeType<ArmorEnhancement> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

