/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.mixin;

import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeData;
import homeostatic.common.biome.BiomeRegistry;
import javax.annotation.Nullable;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Biome.BiomeBuilder.class})
public abstract class BiomeBuilderMixin {
    @Shadow
    @Nullable
    private BiomeGenerationSettings f_47590_;
    @Shadow
    private Biome.TemperatureModifier f_47586_;
    @Shadow
    @Nullable
    private Biome.Precipitation f_47581_;
    @Shadow
    @Nullable
    private MobSpawnSettings f_47589_;
    @Shadow
    @Nullable
    private Float f_47585_;
    @Shadow
    @Nullable
    private Float f_47587_;

    @Shadow
    public abstract Biome.BiomeBuilder m_47609_(float var1);

    @Shadow
    public abstract Biome.BiomeBuilder m_47597_(Biome.Precipitation var1);

    @Inject(method={"build"}, at={@At(value="HEAD")})
    private void injectBuild(CallbackInfoReturnable<Biome> cir) {
        BiomeData biomeData = null;
        BiomeRegistry.BiomeCategory biomeCategory = BiomeRegistry.BiomeCategory.MISSING;
        if (this.f_47590_ != null && this.f_47585_ != null && this.f_47589_ != null && this.f_47587_ != null) {
            biomeCategory = BiomeRegistry.getBiomeCategory(this.f_47590_, this.f_47585_.floatValue(), this.f_47589_, this.f_47586_, this.f_47587_.floatValue(), this.f_47581_);
        }
        if (biomeCategory != BiomeRegistry.BiomeCategory.MISSING) {
            biomeData = BiomeRegistry.BIOMES.get((Object)biomeCategory);
            Homeostatic.LOGGER.debug("Overriding biome %s\n%s\n%s", (Object)this.toString(), (Object)biomeCategory, (Object)biomeData);
        } else {
            Homeostatic.LOGGER.debug("Missing biome data %s", (Object)this.toString());
        }
        if (biomeData != null) {
            this.m_47597_(biomeData.getPrecipitation(this.f_47585_, this.f_47581_));
            this.m_47609_(biomeData.getTemperature(this.f_47586_, this.f_47581_));
        } else {
            Homeostatic.LOGGER.debug("Not overriding biome %s", (Object)this.toString());
        }
    }
}

