/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.network.IData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class TemperatureData
implements IData {
    float localTemperature;
    float skinTemperature;
    float coreTemperature;

    public TemperatureData(float localTemperature, BodyTemperature bodyTemperature) {
        this.localTemperature = localTemperature;
        this.skinTemperature = bodyTemperature.getSkinTemperature();
        this.coreTemperature = bodyTemperature.getCoreTemperature();
    }

    public TemperatureData(FriendlyByteBuf buf) {
        this.localTemperature = buf.readFloat();
        this.skinTemperature = buf.readFloat();
        this.coreTemperature = buf.readFloat();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.localTemperature);
        buf.writeFloat(this.skinTemperature);
        buf.writeFloat(this.coreTemperature);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> Minecraft.m_91087_().f_91074_.getCapability(CapabilityRegistry.TEMPERATURE_CAPABILITY).ifPresent(data -> {
                data.setLocalTemperature(this.localTemperature);
                data.setSkinTemperature(this.skinTemperature);
                data.setCoreTemperature(this.coreTemperature);
            }));
        }
    }
}

